C
C GRAF10$: Plot colours
C MENU10$: Colours
C
C Subroutines for SIMPLOT
C
C
      SUBROUTINE X_GRAF10 (NPRESS)
C
C ACTION: Call MENU10$ from i_press_10
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 29/10/2000
C         07/10/2002 increased IJ TO 300
C         12/11/2004 increased IK to 12
C
C          NPRESS: (input/output)
C
      IMPLICIT   NONE
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C
      INTEGER    IJ, IK
      PARAMETER (IJ = 300, IK = 12)
      INTEGER    ISEND, JCOLOR(IJ), KCOLOR(IK), LCOLOR, NFILES
      CHARACTER  FSAV(IJ)*1024
      LOGICAL    MONO, VIDEO
      EXTERNAL   X_MENU10
      IF (NPRESS.EQ.10) THEN
C
C ISEND = 3: retrieve
C
         ISEND = 3
         CALL X_MENU10 (IJ, IK, ISEND, JCOLOR, KCOLOR, LCOLOR, NFILES,
     +                  FSAV,
     +                  MONO, VIDEO)
C
C ISEND = 2: edit then store
C
         ISEND = 2
         CALL X_MENU10 (IJ, IK, ISEND, JCOLOR, KCOLOR, LCOLOR, NFILES,
     +                  FSAV, MONO, VIDEO)
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C

      SUBROUTINE X_MENU10 (IJ, IK, ISEND, JCOLOR, KCOLOR, LCOLOR,
     +                     NFILES,
     +                     FSAV,
     +                     MONO, VIDEO)

      
      USE MODULE_CLEARWIN, ONLY : JCOLOR_1, KCOLOR_1, LCOLOR_1,
     +                            NFILES_1,
     +                            FSAV_1, 
     +                            MONO_1, VIDEO_1,
     +                            L_1, M_1, QUERY_EXIT     
C
C ACTION : Set colours ... MENU06 in v3.2
C AUTHOR : W. G. Bardsley, University of Manchester, U.K. 8/11/93
C          26/01/1995 Added MONO and VIDEO
C          14/07/1997 win32 version
C          29/10/2000 extensive re-editing
C          18/11/2000 removed KCOLOR(6) and KCOLOR(7) which referred to
C                     text and arrows as these are now set in PLTOBJ$
C                     KCOLOR(6) and KCOLOR(7) now have no use. However
C                     they are retained for possible future use.
C          01/02/2001 Added FSAV and FSAV1
C          10/04/2001 used KCOLOR(6) = border, KCOLOR(7) = graph paper
C          20/07/2001 added DENDRO_GRAM
C          07/10/2002 increased NMAX TO 300
C          12/11/2004 increased NKCOL1 to 12, KCOLOR(8) = BACKGROUND
C          19/09/2006 added BI_PLOT 
C          20/04/2007 added INTENTS and removed SYMBOLS and SYMLAB$
C          01/02/2008 introduced MODULE_SAVEGKS and call to LVIEW1
C          16/08/2008 added code for outline symbols (30 =< M =< 33)
C          29/11/2010 added KCOLOR(9) = colour for extra title
C          16/01/2014 added QUERY_EXIT and RE_DISPLAY
C          18/02/2014 removed RE_DISPLAY  
C
C          IJ: (input/unchanged) dimension
C          IK: (input/unchanged) dimension
C       ISEND: (input/unchanged) as follows:-
C               ISEND = 1: store
C               ISEND = 2: edit then store
C               ISEND = 3: retrieve
C      JCOLOR: (input/output) line/symbol colours
C      KCOLOR: (input/output) colours for titles etc.
C      LCOLOR: (input/output) background = KCOLOR(8)
C        FSAV: (input/output) file names
C        MONO: (input/output) black on white if .true.
C       VIDEO: (input/output) white on black if .true.
C
C KCOLOR values 
C -------------
C      KCOLOR(1): main title
C      KCOLOR(2): axes
C      KCOLOR(3): labels
C      KCOLOR(4): legends
C      KCOLOR(5): panel keys
C      KCOLOR(6): border
C      KCOLOR(7): graticule
C      KCOLOR(8): background
C      KCOLOR(9): extra title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: IJ, IK, ISEND
      INTEGER,             INTENT (INOUT) :: JCOLOR(IJ), KCOLOR(IK),
     +                                       LCOLOR, NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(IJ)
      LOGICAL,             INTENT (INOUT) :: MONO, VIDEO
C
C Locals
C
      INTEGER    MODE, NKCOL1, NMAX
      PARAMETER (MODE = 0, NKCOL1 = 12, NMAX = 300)
      INTEGER    KFILE, NDEC, NSTART, NTEXT
      INTEGER    I, IADD1, IMID, LPREV
      INTEGER    IX, IY
      PARAMETER (IX = 4, IY = 4)
      INTEGER    NUMOPT
      CHARACTER  TEXT(NMAX + 2)*129, X_TRIM40*40, WORD6*6, WORD40*40
      CHARACTER  COLOUR(0:71)*20
      CHARACTER  SELECT(3)*8
      CHARACTER  LTYPE*20, STYPE*30
      CHARACTER  BLANK*1, GRAVE*1
      PARAMETER (BLANK = ' ', GRAVE = '`')
      LOGICAL    AGAIN, OK
      LOGICAL    BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, STORE,
     +           TWO_PLOTS, VECTOR_FIELD
      PARAMETER (STORE = .FALSE.)
      LOGICAL    TITLES
      PARAMETER (TITLES = .TRUE.)
      EXTERNAL   SAVE11$
      EXTERNAL   W_PALETT
      EXTERNAL   X_PUTADV, X_LVIEW2, X_TRIM40, X_LVIEW1, X_TRIML1
      INTRINSIC  MIN
      DATA LPREV / 1 / 
      DATA COLOUR / 'Black 0', 'Blue 1', 'Green 2', 'Cyan 3', 'Red 4',
     +              'Magenta 5', 'Brown 6',
     +              'Grey(0.6667) 7', 'Grey(0.3333) 8',
     +              'Light Blue 9', 'Light Green 10', 'Light Cyan 11',
     +              'Light Red 12', 'Light Magenta 13',
     +              'Light Yellow 14', 'Intense White 15' ,
     +              'Grey (0.4000) 16', 'Grey (0.4667) 17',
     +              'Grey (0.5333) 18', 'Grey (0.6000) 19',
     +              'Grey (0.7333) 20', 'Grey (0.8000) 21',
     +              'Grey (0.8667) 22', 'Grey (0.9333) 23',
     +              'Dark Red 24', 'Bright Blue 25', 'Bright Green 26',
     +              'Bright Cyan 27', 'Bright Red 28',
     +              'Bright Magenta 29', 'Bright Yellow 30',
     +              'Dark Green 31', 'Dark Blue 32',
     +              'Pale Blue 33', 'Pale Green 34', 'Pale Cyan 35',
     +              'Pale Red 36', 'Pale Magenta 37', 'Pale Yellow 38',
     +              'Pale Brown 39',
     +              'Colour 40', 'Colour 41', 'Colour 42', 'Colour 43',
     +              'Colour 44', 'Colour 45', 'Colour 46', 'Colour 47',
     +              'Colour 48', 'Colour 49', 'Colour 50', 'Colour 51',
     +              'Colour 52', 'Colour 53', 'Colour 54', 'Colour 55',
     +              'Colour 56', 'Colour 57', 'Colour 58', 'Colour 59',
     +              'Colour 60', 'Colour 61', 'Colour 62', 'Colour 63',
     +              'Colour 64', 'Colour 65', 'Colour 66', 'Colour 67',
     +              'Colour 68', 'Colour 69', 'Colour 70', 'Colour 71'/
      IF (ISEND.EQ.1) THEN
C
C Store
C
         KCOLOR(8) = LCOLOR
         DO I = 1, MIN(IJ,NMAX)
            JCOLOR_1(I) = JCOLOR(I)
         ENDDO
         IF (NMAX.GT.IJ) THEN
            DO I = IJ + 1, NMAX
               JCOLOR_1(I) = 0
            ENDDO
         ENDIF
         DO I = 1, MIN(IK,NKCOL1)
            KCOLOR_1(I) = KCOLOR(I)
         ENDDO
         IF (NKCOL1.GT.IK) THEN
            DO I = IK + 1, NKCOL1
               KCOLOR_1(I) = 0
            ENDDO
         ENDIF
         DO I = 1, NFILES
            FSAV_1(I) = FSAV(I)
         ENDDO
         IF (IJ.GT.NFILES) THEN
            DO I = NFILES + 1, MIN(IJ,NMAX)
               FSAV_1(I) = BLANK
            ENDDO
         ENDIF
         LCOLOR_1 = LCOLOR
         NFILES_1 = NFILES
         MONO_1 = MONO
         VIDEO_1 = VIDEO
      ELSEIF (ISEND.EQ.2) THEN
C
C Edit then store
C
         CALL SAVE11$(BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, STORE,
     +                TWO_PLOTS, VECTOR_FIELD)
         AGAIN = .TRUE.
         DO WHILE (AGAIN)
            KCOLOR(8) = LCOLOR
            SELECT(1) = BLANK
            SELECT(2) = BLANK
            SELECT(3) = BLANK
            IF (.NOT.MONO .AND. .NOT.VIDEO) THEN
               SELECT(1) = 'Selected'
               IF (PIE_CHART) THEN
                  WRITE (TEXT,100) COLOUR(KCOLOR(1)), 'No axes',
     +                             COLOUR(KCOLOR(3)), COLOUR(KCOLOR(4)),
     +                             COLOUR(KCOLOR(5)), COLOUR(KCOLOR(6)),
     +                             COLOUR(KCOLOR(7)),
     +                             COLOUR(LCOLOR),
     +                            'No symbols/lines',
     +                             COLOUR(KCOLOR(9)),    
     +                             SELECT(1), SELECT(2), SELECT(3)
               ELSEIF (BAR_CHART .AND. NFILES.EQ.1) THEN
                  WRITE (TEXT,100) COLOUR(KCOLOR(1)), COLOUR(KCOLOR(2)),
     +                             COLOUR(KCOLOR(3)), COLOUR(KCOLOR(4)),
     +                             COLOUR(KCOLOR(5)), COLOUR(KCOLOR(6)),
     +                             COLOUR(KCOLOR(7)),
     +                             COLOUR(LCOLOR),
     +                            'No symbols/lines',
     +                             COLOUR(KCOLOR(9)),    
     +                             SELECT(1), SELECT(2), SELECT(3)
               ELSE
                  WRITE (TEXT,100) COLOUR(KCOLOR(1)), COLOUR(KCOLOR(2)),
     +                             COLOUR(KCOLOR(3)), COLOUR(KCOLOR(4)),
     +                             COLOUR(KCOLOR(5)), COLOUR(KCOLOR(6)),
     +                             COLOUR(KCOLOR(7)),
     +                             COLOUR(LCOLOR),
     +                            'As selected',
     +                             COLOUR(KCOLOR(9)),    
     +                             SELECT(1), SELECT(2), SELECT(3)
               ENDIF
            ELSEIF (MONO .AND. .NOT.VIDEO) THEN
               SELECT(2) = 'Selected'
               WRITE (TEXT,100) COLOUR(15), COLOUR(15),
     +                          COLOUR(15), COLOUR(15),
     +                          COLOUR(15), COLOUR(15),
     +                          COLOUR(0),  COLOUR(0),
     +                          COLOUR(0),
     +                          COLOUR(0),
     +                          SELECT(1), SELECT(2), SELECT(3)
            ELSEIF (MONO .AND. VIDEO) THEN
               SELECT(3) = 'Selected'
               WRITE (TEXT,100) COLOUR(0), COLOUR(0),
     +                          COLOUR(0), COLOUR(0),
     +                          COLOUR(0), COLOUR(0),
     +                          COLOUR(15), COLOUR(15),
     +                          COLOUR(15),
     +                          COLOUR(15),
     +                          SELECT(1), SELECT(2), SELECT(3)
            ENDIF
            NUMOPT = 14
            IMID = NUMOPT
            CALL X_LVIEW2 (IX, IY, IMID, NUMOPT, 
     +                     TEXT,
     +                     TITLES)
            IF (IMID.LT.NUMOPT) QUERY_EXIT = .TRUE.
            NDEC = IMID
            OK = .TRUE.
            IF (PIE_CHART .AND. NDEC.EQ.2) THEN
C
C Error: No axes in pie charts
C              
               CALL X_PUTADV ('No axes in pie charts')
            ELSEIF (PIE_CHART .AND. NDEC.EQ.9) THEN
C
C Error: Set pie chart colours using the [Data] option
C            
               CALL X_PUTADV (
     +'Set pie chart colours using the [Data] option')
            ELSEIF (BAR_CHART .AND. NDEC.EQ.9 .AND. NFILES.EQ.1) THEN
C
C Error: Set bar chart colours using the [Data] option
C            
               CALL X_PUTADV (
     +'Set bar chart colours using the [Data] option')
            ELSEIF (NDEC.LE.9) THEN
C
C NDEC =< 9
C            
               IF (NDEC.LT.8) THEN
C
C NDEC < 8: plot features (add 1 then subtract before calling PALETT$)
C                 
                  IMID = KCOLOR(NDEC) + 1
               ELSEIF (NDEC.EQ.8) THEN
C
C NDEC = 8: background (add 1 then subtract before calling PALETT$)
C               
                  IMID = LCOLOR + 1
               ELSEIF (NDEC.EQ.9) THEN
C
C NDEC = 9: data i.e. symbols and/or lines, etc.
C               
                  IF (MONO) THEN
                     IF (VIDEO) THEN
                        CALL X_PUTADV ('Symbols are black on white')
                     ELSE
                        CALL X_PUTADV ('Symbols are white on black')
                     ENDIF
                     OK = .FALSE.
                  ENDIF
                  IF (OK) THEN
                     IF (NFILES.EQ.1) THEN
                        KFILE = 1
                     ELSE
C
C Select a file
C
                        WRITE (TEXT,200) 
                        IADD1 = 2
                        DO I = 1, MIN(NFILES,NMAX - 1)
C
C Record line and symbol type in LTYPE and STYPE
C
                           IF (L_1(I).EQ.1) THEN
                              LTYPE = 'Solid'
                           ELSEIF (L_1(I).EQ.2) THEN
                              LTYPE = 'Dashed'
                           ELSEIF (L_1(I).EQ.3) THEN
                             LTYPE = 'Dotted'
                           ELSEIF (L_1(I).EQ.4) THEN
                              LTYPE = 'Dash-Dot'
                           ELSEIF (L_1(I).EQ.5) THEN
                              LTYPE = 'Vector >>>'
                           ELSEIF (L_1(I).EQ.6) THEN
                              LTYPE = 'Vector <<<'
                           ELSEIF (L_1(I).EQ.7) THEN
                              LTYPE = 'cdf'
                           ELSEIF (L_1(I).EQ.8) THEN
                              LTYPE = 'survival'
                           ELSEIF (L_1(I).EQ.9) THEN
                              LTYPE = 'Polygon'
                           ELSE
                              LTYPE = 'None'
                           ENDIF
                           IF (M_1(I).EQ.1) THEN
                              STYPE = 'Dot'
                           ELSEIF (M_1(I).EQ.2) THEN
                              STYPE = 'Plus'
                           ELSEIF (M_1(I).EQ.3) THEN
                              STYPE = 'Cross'
                           ELSEIF (M_1(I).EQ.4) THEN
                              STYPE = 'Asterisk'
                           ELSEIF (M_1(I).EQ.5) THEN
                              STYPE = 'Circle'
                           ELSEIF (M_1(I).EQ.6) THEN
                              STYPE = 'Circle-half'
                           ELSEIF (M_1(I).EQ.7) THEN
                              STYPE = 'Circle-full'
                           ELSEIF (M_1(I).EQ.8) THEN
                              STYPE = 'Triangle'
                           ELSEIF (M_1(I).EQ.9) THEN
                              STYPE = 'Triangle-half'
                           ELSEIF (M_1(I).EQ.10) THEN
                              STYPE = 'Triangle-full'
                           ELSEIF (M_1(I).EQ.11) THEN
                              STYPE = 'Square'
                           ELSEIF (M_1(I).EQ.12) THEN
                              STYPE = 'Square-half'
                           ELSEIF (M_1(I).EQ.13) THEN
                              STYPE = 'Square-full'
                           ELSEIF (M_1(I).EQ.14) THEN
                              STYPE = 'Diamond'
                           ELSEIF (M_1(I).EQ.15) THEN
                              STYPE = 'Diamond-half'
                           ELSEIF (M_1(I).EQ.16) THEN
                              STYPE = 'Diamond-full'
                           ELSEIF (M_1(I).EQ.17) THEN
                              STYPE = 'Minus'
                           ELSEIF (M_1(I).EQ.18) THEN
                              STYPE = 'Male'
                           ELSEIF (M_1(I).EQ.19) THEN
                              STYPE = 'Female'
                           ELSEIF (M_1(I).EQ.20) THEN
                              STYPE = 'Bar-hollow'
                           ELSEIF (M_1(I).EQ.21) THEN
                              STYPE = 'Bar-filled'
                           ELSEIF (M_1(I).EQ.22) THEN
                              STYPE = 'Bar-diag-up'
                           ELSEIF (M_1(I).EQ.23) THEN
                              STYPE = 'Bar-diag-down'
                           ELSEIF (M_1(I).EQ.24) THEN
                              STYPE = 'Bar-crossed'
                           ELSEIF (M_1(I).EQ.25) THEN
                              STYPE = 'Bar-horizontal'
                           ELSEIF (M_1(I).EQ.26) THEN
                              STYPE = 'Bar-vertical'
                           ELSEIF (M_1(I).EQ.27) THEN
                              STYPE = 'Bar-dash'
                           ELSEIF (M_1(I).EQ.28) THEN
                              STYPE = 'Bar-dot'
                           ELSEIF (M_1(I).EQ.29) THEN
                              STYPE = 'Bar-dash-dot'
                           ELSEIF (M_1(I).EQ.30) THEN
                              STYPE = 'Circle-outline'
                           ELSEIF (M_1(I).EQ.31) THEN
                              STYPE = 'Triangle-outline'
                           ELSEIF (M_1(I).EQ.32) THEN
                              STYPE = 'Square-outline'
                           ELSEIF (M_1(I).EQ.33) THEN
                              STYPE = 'Diamond-outline' 
                           ELSEIF (M_1(I).EQ.34) THEN
                              STYPE = 'Inverted-triangle'                                 
                           ELSEIF (M_1(I).EQ.35) THEN
                              STYPE = 'Inverted-triangle-half'
                           ELSEIF (M_1(I).EQ.36) THEN
                              STYPE = 'Inverted-triangle-full'
                           ELSEIF (M_1(I).EQ.37) THEN
                              STYPE = 'Inverted-triangle-outline'    
                           ELSE
                              STYPE = 'None'
                           ENDIF
                           IADD1 = IADD1 + 1
                           WORD40 = X_TRIM40(FSAV(I))
                           WRITE(WORD6,'(I6)') JCOLOR(I)
                           CALL X_TRIML1 (WORD6)
                           TEXT(IADD1) = 
     +                  WORD40//GRAVE//STYPE//GRAVE//LTYPE//GRAVE//WORD6
                        ENDDO
                        IF (LPREV.LT.1 .OR. LPREV.GT.NFILES) LPREV = 1
                        IMID = LPREV
                        NSTART = 3
                        NTEXT = IADD1
                        NUMOPT = IADD1 - 2
                        CALL X_LVIEW1 (IX, IY, IMID, NUMOPT, NSTART,
     +                                 NTEXT,
     +                                 TEXT,
     +                                 TITLES)
                        LPREV = IMID
                        KFILE = IMID
                     ENDIF
                     IF (BAR_CHART .AND. KFILE.EQ.1) THEN
                        OK = .FALSE.
                        CALL X_PUTADV (
     +'Set bar chart colours using the [Data] option')
                     ELSE
                        IMID = JCOLOR(KFILE) + 1
                     ENDIF
                  ENDIF
               ENDIF
               IF (OK) THEN
                  IMID = IMID - 1
                  CALL W_PALETT (IMID, MODE)
                  IF (NDEC.LT.8) THEN
                     KCOLOR(NDEC) = IMID
                  ELSEIF (NDEC.EQ.8) THEN
                     LCOLOR = IMID
                     KCOLOR(8) = LCOLOR
                  ELSE
                     JCOLOR(KFILE) = IMID
                  ENDIF
               ENDIF
            ELSEIF (NDEC.EQ.10) THEN 
C
C NDEC = 10: Extra title
C            
               IMID = KCOLOR(9)
               CALL W_PALETT (IMID, MODE)
               KCOLOR(9) = IMID  
            ELSEIF (NDEC.EQ.11) THEN
C
C NDEC = 11: full colour display
C            
               MONO = .FALSE.
               VIDEO = .FALSE.
            ELSEIF (NDEC.EQ.12) THEN
C
C NDEC = 12: white on black
C            
               MONO = .TRUE.
               VIDEO = .FALSE.
            ELSEIF (NDEC.EQ.13) THEN
C
C NDEC = 13: black on white
C            
               MONO = .TRUE.
               VIDEO = .TRUE.
            ELSEIF (NDEC.EQ.14) THEN
C
C NDEC = 14: apply
C            
               AGAIN = .FALSE.
            ENDIF
         ENDDO
C
C Store
C
         KCOLOR(8) = LCOLOR
         DO I = 1, MIN(IJ,NMAX)
            JCOLOR_1(I) = JCOLOR(I)
         ENDDO
         DO I = 1, MIN(IK,NKCOL1)
            KCOLOR_1(I) = KCOLOR(I)
         ENDDO
         DO I = 1, NFILES
            FSAV_1(I) = FSAV(I)
         ENDDO
         LCOLOR_1 = LCOLOR
         NFILES_1 = NFILES
         MONO_1 = MONO
         VIDEO_1 = VIDEO
      ELSEIF (ISEND.EQ.3) THEN
C
C Retrieve
C
         DO I = 1, MIN(IJ,NMAX)
            JCOLOR(I) = JCOLOR_1(I)
         ENDDO
         DO I = 1, MIN(IK,NKCOL1)
            KCOLOR(I) = KCOLOR_1(I)
         ENDDO
         LCOLOR = LCOLOR_1
         NFILES = NFILES_1
         MONO = MONO_1
         VIDEO = VIDEO_1
         DO I = 1, NFILES_1
            FSAV(I) = FSAV_1(I)
         ENDDO
      ENDIF     
C
C Format statement
C      
  100 FORMAT (
     + 'Type of Graphical Item    `Current Item Colour'
     +/'Main Title          `',A
     +/'Axes                `',A
     +/'Labels              `',A
     +/'Legends             `',A
     +/'Panel keys          `',A
     +/'Border/3D-shading   `',A
     +/'Graticule           `',A
     +/'Background          `',A
     +/'Symbols/lines/labels`',A
     +/'Extra title         `',A
     +/'Colour display      `',A
     +/'White on Black      `',A
     +/'Black on White      `',A
     +/'Apply')
  200 FORMAT (
     + 'Select the data file required for a colour change'
     +/'Data files that are currently available for plotting',
     +'`Plot symbol type','`Plot line type','`Colour')     
      END
C
C
