C
C GRAF11$
C MENU11$
C SAVE11$ ... moved to w_clearwin 06/06/2011
C
C Subroutines for SIMPLOT
C
      SUBROUTINE X_GRAF11 (NPRESS)
C
C ACTION: call MENU11$ from i_press_11
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 29/10/2000
C
C         NPRESS: (input/output) input as number of button pressed but returned
C                                as follows:
C                                NPRESS = 11 on entry: unchanged
C                                otherwise returned with sign reversed
C
      IMPLICIT   NONE 
C
C Argument
C
      INTEGER, INTENT (INOUT) :: NPRESS
C
C Locals
C      
      INTEGER    ISEND
      INTEGER    NLOG
      PARAMETER (NLOG = 12)
      INTEGER    MTRANS
      DOUBLE PRECISION  ASYMP, ASAV, YMAXT(0:23), YMINT(0:23),
     +                  YSAV1, YSAV2, RTOL
      LOGICAL    NATLOG(NLOG), POWERX, POWERY, POWERZ
      EXTERNAL   X_MENU11
      IF (NPRESS.EQ.11) THEN
         ISEND = 3
         CALL X_MENU11 (ISEND, MTRANS, NLOG,
     +                  ASYMP, ASAV, YMAXT, YMINT,
     +                  YSAV1, YSAV2, RTOL, NATLOG, POWERX, POWERY,
     +                  POWERZ)
         ISEND = 2
         CALL X_MENU11 (ISEND, MTRANS, NLOG,
     +                  ASYMP, ASAV, YMAXT, YMINT,
     +                  YSAV1, YSAV2, RTOL, NATLOG, POWERX, POWERY,
     +                  POWERZ)
      ELSE
         NPRESS = - NPRESS
      ENDIF
      END
C
C
      SUBROUTINE X_MENU11 (ISEND, MTRANS, NLOG,
     +                     ASYMP, ASAV, YMAXT, YMINT,
     +                     YSAV1, YSAV2, RTOL, 
     +                     NATLOG, POWERX, POWERY, POWERZ)

      USE MODULE_CLEARWIN, ONLY : ASYMP_1, ASAV_1, RTOL_1, YSAV1_1,
     +                            YSAV2_1, YMAXT_1, YMINT_1,
     +                            NATLOG_1, POWERX_1, POWERY_1,
     +                            POWERZ_1, QUERY_EXIT 
C
C ACTION : Choose transformation for GKSSTY
C AUTHOR : W. G. Bardsley, University of Manchester, 28/10/93
C                            
C          ISEND: (input/unchanged) as follows:
C                  ISEND = 1: store
C                  ISEND = 2: edit then store
C                  ISEND = 3: retrieve
C
C          14/07/1997 Win32 version
C          22/07/1997 Edited for extended transformation list
C          01/02/2000 changed NATLOG to array
C          29/10/2000 extensive re-editing
C          20/07/2001 added DENDRO_GRAM
C          19/09/2006 added BI_PLOT for call to SAVE11$ 
C          20/04/2007 added INTENTS 
C          18/01/2008 transferred all saved variables to MODULE_SAVEGKS
C          16/01/2014 added QUERY_EXIT and RE_DISPLAY
C          18/02/2014 removed RE_DISPLAY
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, NLOG  
      INTEGER,          INTENT (INOUT) :: MTRANS
      DOUBLE PRECISION, INTENT (INOUT) :: ASYMP, ASAV, RTOL, YSAV1,
     +                                    YSAV2, YMAXT(0:23),
     +                                    YMINT(0:23)
      LOGICAL,          INTENT (INOUT) :: NATLOG(NLOG), POWERX, POWERY,
     +                                    POWERZ
C
C Locals
C      
      INTEGER    N15
      PARAMETER (N15 = 15)
      INTEGER    I, IMID, NDEC
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 17)
      INTEGER    JSTART, JTEXT, JUMOPT
      PARAMETER (JSTART = 9, JTEXT = 22, JUMOPT = 14)
      INTEGER    JUMBLD(JTEXT), KCOLOR, KTEXT
      PARAMETER (KCOLOR = 9, KTEXT = 22)
      DOUBLE PRECISION XBIG, YBIG, ZBIG
      CHARACTER  CIPHER(12)*5, LINE*100, TEXT(30)*100
      LOGICAL    AGAIN, YES
      LOGICAL    BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, TWO_PLOTS,
     +           VECTOR_FIELD
      LOGICAL    BORDER, STORE, TITLES
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   X_GETDM1, X_PUTADV, SAVE11$, SAVETR$
      EXTERNAL   X_LVIEW1, X_YESNO2, W_PATCH1, X_LVIEW2
      INTRINSIC  DBLE, MAX, LOG, LOG10, MIN
      DATA       JUMBLD / 1*1, 21*0 /
      IF (ISEND.EQ.1) THEN
C
C Store
C
         STORE = .TRUE.
         CALL SAVETR$(MTRANS,
     +                STORE)
         ASAV_1 = ASAV
         ASYMP_1 = ASYMP
         DO I = 0, 23
            YMAXT_1(I) = YMAXT(I)
            YMINT_1(I) = YMINT(I)
         ENDDO
         YSAV1_1 = YSAV1
         YSAV2_1 = YSAV2
         RTOL_1 = RTOL
         DO I = 1, MIN(NLOG,N15)
            NATLOG_1(I) = NATLOG(I)
         ENDDO
         IF (N15.GT.NLOG) THEN
            DO I = NLOG + 1, N15
               NATLOG_1(I) = .TRUE.
            ENDDO
         ENDIF
         POWERX_1 = POWERX
         POWERY_1 = POWERY
         POWERZ_1 = POWERZ
      ELSEIF (ISEND.EQ.2) THEN
C
C Check if allowed
C
         STORE = .FALSE.
         CALL SAVE11$(BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, STORE,
     +                TWO_PLOTS, VECTOR_FIELD)
         IF (BAR_CHART .OR. BI_PLOT .OR. DENDRO_GRAM .OR. PIE_CHART .OR.
     +       TWO_PLOTS .OR. VECTOR_FIELD) RETURN
C
C Edit then store
C
         WRITE (TEXT,100)
         IMID = NUMOPT
         TITLES = .TRUE.
         CALL X_LVIEW2 (IXL, IYL, IMID, NUMOPT,
     +                  TEXT,
     +                  TITLES)
         NDEC = IMID
         IF (NDEC.LT.NUMOPT) THEN
C
C Action is required
C
            QUERY_EXIT = .TRUE.
            MTRANS = NDEC - 1
            POWERX = .FALSE.
            POWERY = .FALSE.
            POWERZ = .FALSE.
            IF (MTRANS.GT.7) THEN
C
C Logs have been selected
C
               AGAIN = .TRUE.
               DO WHILE (AGAIN)
                  DO I = 1, 12
                     IF (NATLOG(I)) THEN
                        CIPHER(I) = '(Yes)'
                     ELSE
                        IF (I.LT.11) THEN
                           CIPHER(I) = ' '
                        ELSE
                           CIPHER(I) = '(No)'
                        ENDIF
                     ENDIF
                  ENDDO
                  WRITE (TEXT,200) (CIPHER(I), I = 1, 12)
                  IMID = JUMOPT
                  TITLES = .FALSE.
                  CALL X_LVIEW1 (IXL, IYL, IMID, JUMOPT, JSTART, JTEXT,
     +                           TEXT,
     +                           TITLES)
                  IF (IMID.EQ.11) THEN
C
C Toggle powers
C
                     NATLOG(11) = .NOT.NATLOG(11)
                     AGAIN = .TRUE.
                  ELSEIF (IMID.EQ.12) THEN
C
C Toggle intermediate ticks
C
                    NATLOG(12) = .NOT.NATLOG(12)
                     AGAIN = .TRUE.
                  ELSEIF (IMID.LT.JUMOPT - 1) THEN
C
C Select base = IMID
C
                     DO I = 1, 10
                        NATLOG(I) = .FALSE.
                     ENDDO
                     NATLOG(IMID) = .TRUE.
                     AGAIN = .TRUE.
                  ELSEIF (IMID.EQ.JUMOPT - 1) THEN
C
C Help
C
                     WRITE (TEXT,300)
                     CALL W_PATCH1 (KCOLOR, IXL, IYL, LSHADE, JUMBLD,
     +                              KTEXT, 
     +                              TEXT,
     +                              BORDER)
                     AGAIN = .TRUE.
                  ELSE
                     AGAIN = .FALSE.
                  ENDIF
               ENDDO
               POWERX = .FALSE.
               POWERY = .FALSE.
               POWERZ = .FALSE.
               IF (NATLOG(11)) THEN
C
C Special action if powers selected
C
                  IF (MTRANS.EQ.12 .OR. MTRANS.EQ.20) THEN
                     CALL X_PUTADV (
     +'Divisions will be log(1/x) but numbers will be dilution factors')
                  ELSE
                     CALL X_PUTADV (
     +'Divisions will be logs but numbers will be powers of the base')
                  ENDIF
C
C Test for log base b
C
                  IF (MTRANS.LE.15) THEN
                     IF (MTRANS.EQ.8  .OR. MTRANS.EQ.10 .OR.
     +                   MTRANS.EQ.11 .OR. MTRANS.EQ.12 .OR.
     +                   MTRANS.EQ.13 .OR. MTRANS.EQ.15) POWERX = .TRUE.
                     IF (MTRANS.EQ.9  .OR. MTRANS.EQ.10 .OR.
     +                   MTRANS.EQ.11 .OR. MTRANS.EQ.14 .OR.
     +                   MTRANS.EQ.15) POWERY = .TRUE.
                  ELSE
C
C Test for log base 10
C
                     IF (MTRANS.EQ.16 .OR. MTRANS.EQ.18 .OR.
     +                   MTRANS.EQ.19 .OR. MTRANS.EQ.20 .OR.
     +                   MTRANS.EQ.21 .OR. MTRANS.EQ.23) POWERX = .TRUE.
                     IF (MTRANS.EQ.17 .OR. MTRANS.EQ.18 .OR.
     +                   MTRANS.EQ.19 .OR. MTRANS.EQ.22 .OR.
     +                   MTRANS.EQ.23) POWERY = .TRUE.
                  ENDIF
                  POWERZ = POWERY
               ELSEIF (MTRANS.EQ.12 .OR. MTRANS.EQ.20) THEN
                  CALL X_PUTADV (
     +'Divisions will be log(1/x) but numbers will be dilution factors')
               ENDIF
               IF (MTRANS.EQ.11 .OR. MTRANS.EQ.19) THEN
C
C Special action for Hill plot
C
                  WRITE (LINE,400) ASYMP, ASAV
                  YES = .FALSE.
                  CALL X_YESNO2 (ICOLOR, IXL, IYL, 
     +                           LINE,
     +                           YES)
                  IF (YES) THEN
                     XBIG = DBLE(ASAV)
                     YBIG = ASYMP
                     ZBIG = DBLE(1.0D+00/RTOL)
                     CALL X_GETDM1 (XBIG, YBIG, ZBIG,
     + 'Value of A for Hill Plot (y-asymptote as x tends to infinity)')
                     ASYMP = YBIG
                     IF (NATLOG(10)) THEN
                        YMAXT(19) = LOG10
     +                       (MAX(RTOL, YSAV2/(MAX(RTOL, ASYMP-YSAV2))))
                        YMINT(19) = LOG10
     +                    (MAX(RTOL, YSAV1/(MAX(RTOL, ASYMP-YSAV1))))
                     ELSE
                        YMAXT(11) = LOG
     +                     (MAX(RTOL,YSAV2/(MAX(RTOL,ASYMP-YSAV2))))
                        YMINT(11) = LOG
     +                     (MAX(RTOL,YSAV1/(MAX(RTOL,ASYMP-YSAV1))))
                     ENDIF
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
C
C Store
C
         STORE = .TRUE.
         CALL SAVETR$(MTRANS,
     +                STORE)
         ASAV_1 = ASAV
         ASYMP_1 = ASYMP
         DO I = 0, 23
            YMAXT_1(I) = YMAXT(I)
            YMINT_1(I) = YMINT(I)
         ENDDO
         YSAV1_1 = YSAV1
         YSAV2_1 = YSAV2
         RTOL_1 = RTOL
         DO I = 1, MIN(NLOG,N15)
            NATLOG_1(I) = NATLOG(I)
         ENDDO
         POWERX_1 = POWERX
         POWERY_1 = POWERY
         POWERZ_1 = POWERZ
      ELSEIF (ISEND.EQ.3) THEN
C
C Retrieve
C
         STORE = .FALSE.
         CALL SAVETR$(MTRANS,
     +                STORE)
         ASAV = ASAV_1
         ASYMP = ASYMP_1
         DO I = 0, 23
            YMAXT(I) = YMAXT_1(I)
            YMINT(I) = YMINT_1(I)
         ENDDO
         YSAV1 = YSAV1_1
         YSAV2 = YSAV2_1
         RTOL = RTOL_1
         DO I = 1, MIN(NLOG,N15)
            NATLOG(I) = NATLOG_1(I)
         ENDDO
         POWERX = POWERX_1
         POWERY = POWERY_1
         POWERZ = POWERZ_1
      ENDIF  
C
C Format statements
C      
  100 FORMAT (
     + 'Name of the Data Transformation  `x-axis   `y-axis'
     +/'Original axes               `x        `y'
     +/'Reversed axes               `y        `x'
     +/'Dixon                       `x        `1/y'
     +/'Single reciprocal           `1/x      `y'
     +/'Double reciprocal           `1/x      `1/y'
     +/'Scatchard                   `y        `y/x'
     +/'Eadie-Hofstee               `y/x      `y'
     +/'Hanes                       `x        `x/y'
     +/'X-semilog                   `log[x]   `y'
     +/'Y-semilog                   `x        `log[y]'
     +/'log-log                     `log[x]   `log[y]'
     +/'Hill: 0 < y < A             `log[x]   `log[y/(A - y)]'
     +/'Dilution curve: 0 < x <= 1  `log[1/x] `y'
     +/'Reverse Y-semilog           `log[y]   `x'
     +/'Reverse X-semilog           `y        `log[x]'
     +/'Reverse log-log             `log[y]   `log[x]'
     +/'Cancel                      `...      ` ...')
  200 FORMAT (
     + 'Logarithmic axes and labelling with powers'
     +/
     +/'To transform to logs all values must be positive.'
     +/'Use base n for n-fold dilution in a dilution curve,'
     +/'e.g. 2 for doubling, otherwise use the default (10).'
     +/'Simplot estimates ranges for bases 2 and 10 but, to'
     +/'get integer label powers, adjust the plotting range'
     +/'(extremes in logs of course) and no. of tick marks.'
     +/'log to base e (Natural)       `',A
     +/'log to base 2 (Doubling)      `',A
     +/'log to base 3 (Trebling)      `',A
     +/'log to base 4 (Fourfold)      `',A
     +/'log to base 5 (Fivefold)      `',A
     +/'log to base 6                 `',A
     +/'log to base 7                 `',A
     +/'log to base 8                 `',A
     +/'log to base 9                 `',A
     +/'log to base 10 (Decadic)      `',A
     +/'Plot labels as powers ?       `',A
     +/'Plot intermediate tick marks ?`',A
     +/'Help'
     +/'Apply')
  300 FORMAT (
     + 'Logarithmic axes and labelling with powers'
     +/
     +/'When your data are read into this program it estimates'
     +/'two extreme plotting ranges, for base 2 and base 10 logs,'
     +/'which should give a reasonable labelling scheme for these'
     +/'two bases. For any other bases, or to get the labels as'
     +/'appropriate integers, you have to select the most sensible'
     +/'range and number of tick marks to get good subdivisions.'
     +/'There are two ways to label the axes. You can let the value'
     +/'on the label correspond to the value of the log, which is'
     +/'the most logical way. However there is a tendency to plot'
     +/'using logarithmic transformations, but label using powers'
     +/'of the base. If you use this method, you should edit the'
     +/'legend to clarify what you are plotting. A variation on'
     +/'this theme is when immunologists plot log(1/x) but label'
     +/'the axis with dilution factors. This type of plot will'
     +/'often use base 2 (doubling dilution) or 10, and default'
     +/'labelling is in proportions, e.g. 1, 1/2, 1/4, 1/8, etc.'
     +/
     +/'To emphasize the fact that a log scale is used when powers'
     +/'are used for labels, you can add intermediate tick marks'
     +/'if required.')
  400 FORMAT (
     +'Change value of A ? (Current =',1P,E11.3,', Min =',E11.3,')')
      END
C
C
