c
c
      subroutine x_graphs (icount, n,
     +                     abort, la, ls, store)
c
c action: create/read w_graphs.cfg
c author: w.g.bardsley, university of manchester, u.k., 26/08/2009
c         26/06/2010 added call to x_infofl
c         15/01/2011 added call to x_sim256
c         06/02/2011 added opions 8 and 9
c         11/02/2011 added options 10, 11, 12 and store
c
c icount: lines read off w_graphs.cfg  
c      n: dimension of la and ls
c  abort: success/failure indicator
c     la: advanced logicals
c     ls: simple logicals
c  store: if .true. create output file directly
c
c nmax controls the maximum number of parameters  
c
       implicit none
c
c arguments
c       
      integer, intent (in)    :: n
      integer, intent (out)   :: icount
      logical, intent (out)   :: abort
      logical, intent (inout) :: la(n), ls(n)
      logical, intent (in)    :: store 
c
c locals
c    
      integer    i, ios, j, nout
      integer    nmax, n6
      parameter (nmax = 20, n6 = 6)
      integer    ia(nmax), is(nmax)
      character  title*80 
      character  cfg_graphs*12
      parameter (cfg_graphs = 'w_graphs.cfg') 
      character  graphs*1024, x_sim256*1024
      logical    exist, read_only
      external   x_attrib, x_putfat, x_getnou, x_infofl, x_sim256
      save       ia, is
      data       ia / 1, 0, 0, 0, 0, 0, 1, 0, 0, 1,
     +                1, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
      data       is / 1, 0, 0, 0, 0, 0, 1, 0, 0, 0,
     +                0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
c
c initialise then check dimensions
c 
      abort = .true.
      icount = 0
      if (n.gt.0) then 
         if (.not.store) then    
            do i = 1, n
               la(i) = .false.
               ls(i) = .false.
            enddo
         endif   
      else
         call x_putfat ('N < 1 is illegal in call to X_GRAPHS')
         return    
      endif   
      if (n.gt.nmax) then
         call x_putfat ('N > 20 is illegal in call to X_GRAPHS')  
         return
      endif  
c
c check for w_graphs.cfg
c           
      graphs = x_sim256(cfg_graphs)
      call x_attrib (graphs,
     +               exist, read_only)
      if (exist .and. read_only) then
         call x_infofl (n6,
     +                  graphs)        
         return
      endif  
      if (.not.exist) then
c
c create a default copy
c        
         call x_getnou (nout)
         open (unit = nout, file = graphs)
         write (nout,100)
         do i = 1, nmax
            write (nout,'(2i3)') is(i), ia(i)
         enddo
         write (nout,200)
         write (nout,300)   
         close (unit = nout)
      endif   
c
c open the configuration file
c      
      call x_getnou (nout)
      open (unit = nout, file = graphs, iostat = ios)
      if (ios.eq.0 .and. store) then
         write (nout,100)
         do i = 1, nmax
            if (i.le.n) then
               if (la(i)) then
                  ia(i) = 1
               else
                  ia(i) = 0
               endif 
               if (ls(i)) then
                  is(i) = 1
               else
                  is(i) = 0
               endif
            endif              
            write (nout,'(2i3)') is(i), ia(i)
         enddo
         icount = n
         write (nout,200)
         write (nout,300)   
      else  
         if (ios.eq.0) read (nout,'(a)',iostat=ios) title
         if (ios.eq.0) then
            do while (ios.eq.0)
               read (nout,*,iostat=ios) i, j
               if (ios.eq.0 .and. icount.lt.n .and. icount.lt.nmax) then
                  icount = icount + 1
                  if (i.eq.0) then
                     ls(icount) = .false.
                  else
                     ls(icount) = .true.
                  endif
                  if (j.eq.0) then
                     la(icount) = .false.
                  else
                     la(icount) = .true.
                  endif 
               endif           
            enddo
         else
            close (unit = nout)
            return     
         endif  
      endif
      close (unit = nout)
      abort = .false.
c      
c format statements
c      
  100 format ('Graph style configuration type %2')
  200 format (
     + '%Simple/Advanced graphics pairs (0 = .false., 1 = .true.) for:')
  300 format (  
     +/' 1. Box round data plotted' 
     +/' 2. Frame around graph' 
     +/' 3. Offset axes' 
     +/' 4. X_grid lines (parallel to Y-axis)' 
     +/' 5. Y_grid lines (parallel to X-axis)' 
     +/' 6. Lines intersecting at (0,0) if in range' 
     +/' 7. Tick marks pointing in'
     +/' 8. Advanced only: Display panel' 
     +/' 9. Advanced only: Panel at side' 
     +/'10. Advanced only: Plot lines in panels' 
     +/'11. Reserved only: Plot symbols i panels' 
     +/'12. Advanced only: Border round plot' 
     +/'13. Reserved ...' 
     +/'14. Reserved ...' 
     +/'15. Reserved ...' 
     +/'16. Reserved ...' 
     +/'17. Reserved ...' 
     +/'18. Reserved ...' 
     +/'19. Reserved ...' 
     +/'20. Reserved ...')
      end
c
c      
           

      