c
c
      subroutine x_grfsig (isend, mtrans, nfig, nsig,
     +                     symbol)
c
c action: set significant figures for axes labels plotted by gksgrf$
c author: w.g.bardsley, university of manchester, u.k., 19/07/2009
c         27/08/2009 added nfig to arguments
c         14/09/2011 developed from grfsig$
c
c  isend: (input/unchanged) as follows:
C          isend = 0: set nsig directly   ... nfig is not used
c          isend = 1: set nfig directly   ... nsig is not used
c          isend = 2: return nsig by menu ... nfig is not used
c          isend = 3: retrieve both nfig and nsig
c mtrans: (input unchanged) must be 0 =< mtrans =< 23
c   nfig: (input/output) no. significant figures  
c   nsig: (input/output) must be 1, 2, or 3
c symbol: (input/unchanged) must be X, Y, Z, x, y, z, E, or e
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, mtrans
      integer,             intent (inout) :: nfig, nsig
      character (len = 1), intent (in)    :: symbol 
c
c locals
c      
      integer    mx(0:23), my(0:23), mz(0:23)
      integer    nx(0:23), ny(0:23), nz(0:23)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 3, numsta = 3, numtxt = numopt + numsta - 1)
      integer    numbld(numtxt)
      character  text(numtxt)*100
      logical    x, y
      external   x_putfat, x_lstbox
      save       mx, my, mz, nx, ny, nz
      data       mx, my, mz / 24*3, 24*3, 24*3 /
      data       nx, ny, nz / 24*2, 24*2, 24*2 /
      data       numbld / 4, 0, 0, 0, 0 /
c
c initialise x, y
c      
      x = .false.
      y = .false.
c
c check symbol and mtrans
c      
      if (symbol.eq.'X' .or. symbol.eq.'x') then
         x = .true.
      elseif (symbol.eq.'Y' .or. symbol.eq.'y') then
         y = .true.
      elseif (symbol.ne.'Z' .and. symbol.ne.'z' .and.
     +        symbol.ne.'E' .and. symbol.ne.'e') then
         call x_putfat (
     +  'symbol is not x, y, z (or e) in call to x_grfsig')
         return
      endif   
      if (mtrans.lt.0 .or. mtrans.gt.23) then
         call x_putfat (
     +  'mtrans out of range (0,23) in call to x_grfsig')
         return
      endif   
c
c action depends on isend
c       
      if (isend.eq.0) then
c
c isend = 0: check nsig then assign nx, ny, nz directly
c        
         if (nsig.lt.1 .or. nsig.gt.3) then
            call x_putfat ('nsig < 1 or nsig > 3 in call to x_grfsig')
         else
            if (x) then
               nx(mtrans) = nsig
            elseif (y) then
               ny(mtrans) = nsig
            else
               nz(mtrans) = nsig
            endif          
         endif        
      elseif (isend.eq.1) then
c
c isend = 1: check nfig then assign mx, my, mz directly
c
         if (nfig.ge.1 .and. nfig.le.7) then
            if (x) then
               mx(mtrans) = nfig
            elseif (y) then
               my(mtrans) = nfig
            else
               mz(mtrans) = nfig
            endif  
         endif  
      elseif (isend.eq.2) then
c
c isend = 2: assign nsig, nx, ny, or nz using lstbox  
c        
         write (text,100) symbol
         if (x) then
            numdec = nx(mtrans)
         elseif (y) then
            numdec = ny(mtrans)
         else 
            numdec = nz(mtrans)
         endif
         call x_lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                  text) 
         nsig = numdec
         if (x) then
            nx(mtrans) = numdec
         elseif (y) then
            ny(mtrans) = numdec
         else
            nz(mtrans) = numdec 
         endif 
      elseif (isend.eq.3) then
c
c isend = 3: retrieve nsig and nfig
c      
         if (x) then
            nfig = mx(mtrans)
            nsig = nx(mtrans) 
         elseif (y) then
            nfig = my(mtrans)
            nsig = ny(mtrans)
         else
            nfig = mz(mtrans)
            nsig = nz(mtrans) 
         endif
      else
         call x_putfat ('isend < 1 or isend > 3 in call to x_grfsig')
      endif 
c
c format statement
c      
  100 format (
     + 'Precision for',1x,a,1x,'axis labels'
     +/
     +/'Low'
     +/'Automatic'       
     +/'High')
      end
c
c