c
c
      subroutine x_grftic (isend, ntic,
     +                     symbol)
c
c action: set tick marks for axes labels plotted by gksgrf$
c author: w.g.bardsley, university of manchester, u.k., 19/07/2009
c
c  isend: (input/unchanged) as follows:
c          isend = 1: set a value directly
c          isend = 2: set a value by menu
c          isend = 3: retrieve a value
c   ntic: (input/output) must be 1 =< ntic =< 9
c symbol: (input/unchanged) must be X, Y, Z, x, y, or z
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend
      integer,             intent (inout) :: ntic
      character (len = 1), intent (in)    :: symbol 
c
c locals
c      
      integer    ntemp, nx, ny, nz
      integer    nbot, nmid, ntop
      parameter (nbot = 1, nmid = 4, ntop = 9)
      character  line*100
      logical    x, y, z
      external   x_putfat, x_getjm1
      save       nx, ny, nz
      data       nx, ny, nz / nmid, nmid, nmid /
c
c initialise x, y, z
c      
      x = .false.
      y = .false.
      z = .false.
c
c check symbol
c      
      if (symbol.eq.'X' .or. symbol.eq.'x') then
         x = .true.
      elseif (symbol.eq.'Y' .or. symbol.eq.'y') then
         y = .true.
      elseif (symbol.eq.'Z' .or. symbol.eq.'z') then
         z = .true.
      else
         call x_putfat ('symbol is not x, y, or z in call to x_grftic')
         return
      endif   
c
c action depends on isend
c       
      if (isend.eq.1) then

c
c isend = 1: check ntic then assign nx, ny, or nz directly
c        
         if (ntic.lt.nbot .or. ntic.gt.ntop) then
            write (line,100) nbot, ntop
            call x_putfat (line)
         else
            if (x) then
               nx = ntic
            elseif (y) then
               ny = ntic
            elseif (z) then
               nz = ntic
            endif          
         endif
      elseif (isend.eq.2) then
c
c isend = 2: assign nx, ny, or nz using getjm1
c        
         write (line,200) symbol
         if (x) then
            ntemp = nx
         elseif (y) then
            ntemp = ny
         else
            ntemp = nz
         endif
         call x_getjm1 (nbot, ntemp, ntop,
     +                  line) 
         ntic = ntemp
         if (x) then
            nx = ntemp
         elseif (y) then
            ny = ntemp
         else
            nz = ntemp 
         endif                          
      elseif (isend.eq.3) then
c
c isend = 3: retrieve nsig
c      
         if (x) then
            ntic = nx 
         elseif (y) then
            ntic = ny
         else
            ntic = nz 
         endif          
      else
         call x_putfat ('isend < 1 or isend > 3 in call to x_grftic')
      endif 
c
c format statement
c      
  100 format ('ntic <',i2,', or ntic >',i2,' in call to x_grftic')
  200 format (
     +'Number of intervals (i.e. tick marks - 1) for',1x,a,1x,'axis')
      end
c
c