c
c
      subroutine x_gstyle (n,
     +                     la, ls, store)
c
c action: set or retrieve plotting styles
c author: w.g.bardsley, university of manchester, u.k., 26/08/2009
c         02/11/2011 now stores/retrievs using w_graphs.cfg  
c
c     n: dimension of la and ls
c    la: advanced logicals
c    ls: simple logicals
c store: controls action required as follows:
c        store = .false. then just retrieve current values
c        store = .true. then display check box to change defaults and      
c                       return the new defauilts
c
c nmax controls the maximum number of parameters but in this version 
c it is assumed that there will only be up to 10 simple parameters and 
c up to nmax advanced parameters. ia and is set the raw defaults and
c the configuration file w_graphs.cfg allows up to 15 parameters.
c
       implicit none
c
c arguments
c       
      integer, intent (in)  :: n
      logical, intent (in)  :: store
      logical, intent (out) :: la(n), ls(n)
c
c locals
c    
      integer    i, icount
      integer    n10, nmax, nmax2
      parameter (n10 = 10, nmax = 20, nmax2 = 2*nmax)
      character  text(nmax2)*50, title*80 
      logical    abort
      logical    l_all(nmax2)
      logical    store1
      parameter (store1 = .false.)
      external   x_putfat, w_chkbox, x_graphs
      intrinsic  min
c
c initialise then check dimensions
c 
      if (n.gt.0) then      
         do i = 1, n
            la(i) = .false.
            ls(i) = .false.
         enddo
      else
         call x_putfat ('n < 1 is illegal in call to x_gstyle')
         return    
      endif   
      if (n.gt.nmax) then
         call x_putfat ('n > 20 is illegal in call to x_gstyle')  
         return
      endif   
c
c check for w_graphs.cfg and retrieve current defaults
c           
      call x_graphs (icount, n,
     +               abort, la, ls, store1)
      if (abort .or. icount.le.0) return      
      
      if (store) then
c
c set up values
c        
         write (title,100)
         write (text,200)
         do i = 1, n10
            if (i.le.icount) then  
               l_all(i) = ls(i)
            else
               l_all(i) = .false.
            endif      
         enddo
         do i = 1, nmax
            if (i.le.icount) then
               l_all(n10 + i) = la(i)
            else
               l_all(n10 + i) = .false.
            endif      
         enddo
c
c i sets the overall number of options provided and would have to be
c greater than 20 if there are more than 10 advanced parameters
c         
         i = 24
         call w_chkbox (i,
     +                  text, title,
     +                  l_all)
         do i = 1, icount
            ls(i) = l_all(i)
            la(i) = l_all(n10 + i)
         enddo  
         call x_graphs (icount, n,
     +                  abort, la, ls, store) 
      endif  
  100 format ('Select the Simple and Advanced graph style defaults')
  200 format (
     + 'Simple: Box round data plotted' 
     +/'Simple: Frame around graph' 
     +/'Simple: Offset axes' 
     +/'Simple: X_grid lines (parallel to Y-axis)' 
     +/'Simple: Y_grid lines (parallel to X-axis)' 
     +/'Simple: Lines intersecting at (0,0) if in range' 
     +/'Simple: Tick marks pointing in'
     +/'Reserved'
     +/'..'
     +/'..'
     +/'Advanced: Box round data plotted' 
     +/'Advanced: Frame around graph' 
     +/'Advanced: Offset axes' 
     +/'Advanced: X_grid lines (parallel to Y-axis)' 
     +/'Advanced: Y_grid lines (parallel to X-axis)' 
     +/'Advanced: Lines intersecting at (0,0) if in range' 
     +/'Advanced: Tick marks pointing in'
     +/'Advanced: Panel ... Display'
     +/'Advanced: Panel ... Position at side'
     +/'Advanced: Panel ... Show line types'
     +/'Advanced: Panel ... Show symbol types'
     +/'Advanced: Border round plot'
     +/'..'
     +/'..'
     +/'..')            
      end
c
c      
           

      