c
c
      subroutine x_infofl (isend,
     +                     fname)
c
c action: provide information about a file
c author: w.g.bardsley, university of manchester, u.k., 31/12/2006
c         28/01/2007 derived from infofl
c         22/06/2010 added calls to x_attrib and w_fpath2 
c         24/01/2011 increased maximum length to 100 characters
c         27/12/2012 added isend = 9
c 
c isend: (input/unchanged) as follows
c        isend = 1: file missing 
c        isend = 2: file created 
c        isend = 3: file deleted 
c        isend = 4: file incorrectly formatted
c        isend = 5: file cannot be viewed/edited/printed 
c        isend = 6: file is read only 
c        isend = 7: file cannot be opened
c        isend = 8: file is empty 
c        isend = 9: file has been located
c fname: (input/unchanged) file name 
c
c Note: parameter nmax must be the maximum possible isend value
c
      implicit none
c
c arguments
c 
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: fname  
c
c locals
c
      integer    l 
      integer    nmax, ntext
      parameter (nmax = 9, ntext = 3)
      integer    numbld(nmax)
      character (len = 1024) w_fpath2, word256
      character (len = 100 ) info(nmax), text(ntext)
      character (len = 100 ) word100, x_trim100
      character (len = 12  ) word12, f$simfit_svg
      parameter (f$simfit_svg = 'f$simfit.svg')
      logical    there, read_only
      external   x_attrib, x_trim100, x_patch2, w_fpath2
      intrinsic  len_trim
      data       numbld / nmax*0 /
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.nmax) return
c
c silence some messages, e.g. isend = 2, and fname = ...f$simfit.svg
c        
      if (isend.eq.2) then
         l = len_trim(fname)
         if (l.ge.12) then
            word12 = fname(l - 11:l)
            if (word12.eq.f$simfit_svg) return
         endif
      endif           
c
c get there and read_only
c        
      call x_attrib (fname,
     +               there, read_only)        
      if (isend.eq.1 .or. isend.eq.3) then
c
c check that the file is actually missing
c        
         if (there) return
      elseif (.not.there) then
c
c check that the file exists
c      
         return
      endif        
      if (isend.eq.6 .and. .not.read_only) return
      if (isend.eq.2) then  
         word256 = w_fpath2(fname)
         word100 = x_trim100(word256)
      else    
         word100 = x_trim100(fname)  
      endif   
      write (info,100)
      write (text,200) info(isend), word100
      numbld(3) = 1
      call x_patch2 (numbld, ntext,
     +               text) 
  100 format (
     + 'The following file could not be located ...'
     +/'The following file has now been created ...'
     +/'The following file has now been deleted ...'
     +/'The following file is not formatted correctly ...'
     +/'The following file cannot be viewed, printed or edited ...'
     +/'The following file is read-only and must have write permission'
     +/'The following file cannot be opened or connected ...'
     +/'The following file is empty ...'
     +/'The following file has been located ...')
  200 format (
     + a
     +/
     +/a)
      end
c
c