c
c
      subroutine x_isitmf (ncol, nrow,
     +                     fname)
c
c action: test if fname is a matrix file
c author: w.g.bardsley, university of manchester, u.k., 19/01/2006 
c         26/02/2006 added intents
c         22/08/2008 now ncol and nrow are diagnostic
c
c          ncol: (output) =< 0 for error, or else number of columns > 0 if OK
c          nrow: (output) =< 0 for error, or else number of rows > 0 if OK
c         fname: (input/unchanged) file to be analysed
c
c  error values: ncol nrow 
c                  -1   -1 ... file does not exist
c                  -2   -2 ... file cannot be opened
c                  -3   -3 ... title cannot be read
c                  -4   -4 ... header dimensions cannot be read
c                  -5   -5 ... file does not have n*m values
c                    
c
      implicit  none
c
c arguments
c
      integer,             intent (out) :: ncol, nrow
      character (len = *), intent (in)  :: fname
c
c locals
c
      integer   i, ios, j, m, n, nin
      double precision x
      character title*80
      logical   there
      external  x_getnou
c
c initialise ncol = -1, nrow = -1 and check if the file exists
c
      ncol = -1
      nrow = -1
      inquire (file = fname, exist = there, iostat = ios)
      if (there .and. ios.eq.0) then
c
c connect unit = nin to the file
c        
         ncol = -2
         nrow = -2  
         call x_getnou (nin)
         open (unit = nin, file = fname, iostat = ios)
         if (ios.eq.0) then
            ncol = -3
            nrow = -3
            read (nin,'(a)',iostat=ios) title
            if (ios.eq.0) then
               ncol = -4
               nrow = -4
               read (nin,*,iostat=ios) n, m
               if (ios.eq.0) then
                  if (m.gt.0 .and. n.gt.0) then
                     i = 0
                     do while (ios.eq.0 .and. i.lt.n)
                        i = i + 1
                        read (nin,*,iostat=ios) (x, j = 1, m)
                     enddo
c
c if n rows and m columns have been read then assign ncol and nrow
c
                     if (ios.eq.0 .and. i.eq.n) then
                        nrow = n
                        ncol = m
                     else
                        ncol = -5
                        nrow = -5   
                     endif
                  endif
               endif
            endif
         endif
         close (unit = nin)
      endif
      end
c
c
