c
c
      subroutine x_isolat (symbol, text)
c
c action: replace symbols by ISOLATIN1 for characters > 127
c author: w.g.bardsley, university of manchester, u.k., 17/11/2003  
c         21/03/2007 added intents
c         21/12/2010 also used 8 for \
c         27/12/2010 extensive editing to trap octal codes
c         28/08/2011 moved into w_clearwin.dll
c
c  text: (input) is unchanged
c symbol: (input/output) is unchanged unless a character in text
c         is outside the 7 bit ASCII set, when the corresponding symbol is
c         replaced by '8' to inform the PostScript interpreter to use the
c         ISOLatin1 character set encoding. This is intended to facilitate
c         the use of accented characters by English users.
c
      implicit   none 
c
c arguments
c                      
      character (len = *), intent (in)    :: text   
      character (len = *), intent (inout) :: symbol
c
c locals
c      
      integer    i, icount, ios, j, jcount, k, x_len200, n
      character (len = 1) bslash, cipher, eight, letter, question, zero 
      parameter (bslash = '\', eight = '8', question = '?', zero = '0')
      external   x_len200
      intrinsic  ichar, index
      n = x_len200(text)
      if (n.gt.0) then
         if (index(text,bslash).gt.0) then
c
c the string contains at least one backslash so search for octal codes
c           
            icount = 0
            do i = 1, n
               letter = text(i:i)
               k = ichar(letter)
               if (letter.eq.bslash) then
c
c a backslash has been encountered 
c                 
                  jcount = 0 
                  if (i.lt.n - 2) then
c
c it could be the start of an octal code
c                    
                     j = i + 1
                     letter = text(j:j)
                     read (letter,'(i1)',iostat=ios) k
                     if (ios.eq.0) then
                        if (k.ge.0 .and. k.le.7) then
c
c first integer after backslash could be an octal code
c                          
                           jcount = jcount + 1
                           j = j + 1
                           letter = text(j:j)
                           read (letter,'(i1)',iostat=ios) k
                           if (ios.eq.0) then
                              if (k.ge.0 .and. k.le.7) then
c
c second integer could be part of an octal code
c                               
                                 jcount = jcount + 1
                                 j = j + 1
                                 letter = text(j:j)
                                 read (letter,'(i1)',iostat=ios) k
                                 if (ios.eq.0) then
                                     if (k.ge.0 .and. k.le.7) then
c
c it is an octal code so substitute then increment icount        
c                                       
                                        jcount = jcount + 1
                                     endif   
                                 endif   
                              endif   
                           endif          
                        endif         
                     endif 
                  endif
                  j = i - icount
                  symbol(j:j) = eight 
                  if (jcount.eq.3) then
                     icount = icount + 3
                  elseif (text(i + 1:i + 1).eq.bslash) then 
                     icount = icount + 1
                  endif    
               elseif (k.gt.127) then
                  j = i - icount
                  cipher = symbol(j:j)
                  if (cipher.eq.question .or. cipher.eq.zero) 
     +               symbol(j:j) = eight
               endif
            enddo
         else
c
c no backslash so just requires simple substitution
c           
            do i = 1, n
               letter = text(i:i)
               k = ichar(letter)
               if (k.gt.127) then
                  cipher = symbol(i:i)
                  if (cipher.eq.question .or. cipher.eq.zero) 
     +               symbol(i:i) = eight
               endif
            enddo
         endif 
c
c pad symbol if required
c             
         j = x_len200(symbol)
         if (j.lt.n) then
            do i = j + 1, n
               symbol(i:i) = zero
            enddo   
         endif  
      endif
      end
c
c
