c
c
      subroutine x_keybrd (fname,
     +                     abort)
c
c action: input temporary data from the console
c author: w.g.bardsley, university of manchester, u.k. 18/10/2020
c     
      implicit   none
c
c arguments
c
      character (len = *), intent (out) :: fname
      logical,             intent (out) :: abort
c
c locals
c         
      integer    numdec
      integer    numopt, numsta, numtxt
      parameter (numopt = 9, numsta = 11, numtxt = numsta + numopt - 1)
      integer    numbld(numtxt) 
      integer    isend, ncmax, nmax, nmin, nrmax
      parameter (isend = 3, ncmax = 30, nmin = 0, nrmax = 30)
      integer    ncols, nrows
      integer    i, icount, ios, itype, j, l, nout 
      double precision x(nrmax,ncmax)
      character (len = 100) line, text(numtxt) 
      character (len = 32 ) date
      character (len = 3  ) word3
      character (len = 1  ) blank
      logical    curve, fixcol, fixrow, label, order, weight
      logical    repeet
      parameter (blank = ' ')
      external   x_lstbox
      external   w_editor, x_getjm1, x_putadv, x_usrdir, x_getnou,
     +           x_ymdhms, help_formats
      intrinsic  nint
      data       numbld / numtxt*0 /
      data       icount / -1 /
c
c initialise parameters
c      
      itype = 1
      ncols = 0
      nrows = 0
      curve = .false.
      fixcol = .true.
      fixrow = .true.
      label = .true.
      order = .false.
      weight = .false.
      abort = .true.
      fname = blank
c
c loop over the options
c      
      write (text,100)
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         call x_lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                  text)
         if (numdec.eq.1) then
c 1 column of integers (n dimensional vector with n =< 30)           
            itype = 2
            nmax = nrmax/2
            call x_getjm1 (nmin, nrows, nmax,
     +                     'Number of rows required')
            if (nrows.gt.0) then
                repeet = .false.
                ncols = 1
            else
                repeet = .true.    
            endif  
         elseif (numdec.eq.2) then
c 1 table of integers (n by m matrix with n*m =< 30)       
            itype = 2
            nmax = nrmax/2
            call x_getjm1 (nmin, nrows, nmax,
     +                     'Number of rows required')
            if (nrows.gt.0) then
               nmax = ncmax/nrows 
               call x_getjm1 (nmin, ncols, nmax,
     +                        'Number of columns required')  
            endif
            if (ncols.gt.0 .and.nrows.gt.0) then
               repeet = .false.
            else
               repeet = .true.
            endif      
         elseif (numdec.eq.3) then
c 2 by 2 contingency table (4 non-negative integers)  
            itype = 2      
            ncols = 2
            nrows = 2 
            call x_putadv ('Frequencies must be non-negative')
            repeet = .false.
         elseif (numdec.eq.4) then
c 3 by 3 contingency tabel (9 non-negative integers)   
             itype = 2     
             ncols = 3
             nrows = 3
             call x_putadv ('Frequencies must be non-negative')  
             repeet = .false.
         elseif (numdec.eq.5) then
c 1 column of numbers (n dimensional vector n =< 30)  
            itype = 1
            nmax = nrmax/2
            call x_getjm1 (nmin, nrows, nmax,
     +                     'Number of rows required')
            if (nrows.gt.0) then
               ncols = 1
               repeet = .false.
            else
               repeet = .true.
            endif        
         elseif (numdec.eq.6) then
c 2 columns of numbers for plotting/fitting (n =< 15)       
            itype = 1
            order = .true.
            curve = .true.
            nmax = nrmax/2
            call x_getjm1 (nmin, nrows, nmax,
     +                     'Number of rows required')
            if (nrows.gt.0) then
               ncols = 2   
               call x_putadv ('Column 1 must be in nondecreasing order')   
            endif 
            if (ncols.gt.0 .and. nrows.gt.0) then
               repeet = .false.
            else
               repeet = .true.
            endif       
         elseif (numdec.eq.7) then 
c 1 table of numbers (n by m matrix with n*m =< 30)  
            itype = 1      
            nmax = nrmax/2
            call x_getjm1 (nmin, nrows, nmax,
     +                     'Number of rows required')
            if (nrows.gt.0) then
               nmax = ncmax/nrows 
               call x_getjm1 (nmin, ncols, nmax,
     +                        'Number of columns required')    
            endif
            if (ncols.gt.0 .and. nrows.gt.0) then
               repeet = .false.
            else
               repeet = .true.
            endif       
         elseif (numdec.eq.numopt - 1) then
            repeet = .true.
            call help_formats ('formats')
         elseif (numdec.eq.numopt) then
            ncols = 0
            nrows = 0  
            repeet = .false. 
         endif
      enddo 
c
c type in the data if ncols and nrows are both positive
c      
      if (ncols.gt.0 .and. nrows.gt.0) then
         abort = .false.
         line = text(1)
         call w_editor (isend, itype, ncols, nrmax, nrows,
     +                  x,
     +                  line,
     +                  curve, fixcol, fixrow, label, order,
     +                  weight)  
         call x_usrdir(l,
     +                 fname)
         if (fname(l:l).ne.'\') then
            l = l + 1
            fname(l:l)= '\'
         endif
         icount = icount + 1
         if (icount.le.1) then
            word3 = 'txt'
         elseif (icount.lt.10) then
            write (word3,'(a2,i1)') '00', icount
         elseif (icount.lt.100) then  
            write (word3,'(a1,i2)') '0', icount 
         else 
             write (word3,'(i3)') icount 
         endif       
         fname(l + 1:l + 19) = 'temporary_data.'//word3   
         call x_getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         line = 'Temporary typed-in data' 
         if (ios.eq.0) write (nout,'(a)', iostat=ios) line
         if (ios.eq.0) write (nout,'(2i6)',iostat=ios) nrows, ncols
         if (ios.eq.0) then
            do i = 1, nrows 
               if (ios.eq.0) then
                  if (numdec.le.4) then
                     write (nout,'(15i8)',iostat=ios)
     +                     (nint(x(i,j)), j = 1, ncols)
                  else
                     write (nout,'(15(1p,e13.5))',iostat=ios)
     +                     (x(i,j), j = 1, ncols)
                  endif
               endif
               if (ios.ne.0) then
                  close (unit = nout)
                  abort = .true.
                  fname = blank 
                  return
               endif    
            enddo
            write (nout,'(i6)', iostat=ios) 1
            call x_ymdhms (date)
            write (nout,'(a)',iostat=ios) date
         endif 
         close (unit = nout)  
      else
         abort = .true.
         fname = blank                     
      endif
c
c format statement
c
  100 format (
     + 'Typing in data values directly from the keyboard'
     +/     
     +/'The best way to input data into Simfit is to prepare a sample'     
     +/'(i.e. vector) or table (i.e. matrix) file using programs like:'
     +/'MAKFIL `... for curve fitting data,'     
     +/'MAKMAT `... for rectangular data tables, or'
     +/'MAKLIB `... for library files referencing several data files.'
     +/'Also data tables can be pasted in from the clipboard, or you'      
     +/'can now choose to type in small data sets from the keyboard.'      
     +/     
     +/'1 column of integers (n dimensional vector with n =< 30)'  
     +/'1 table of integers (n by m matrix with n*m =< 30)'   
     +/'2 by 2 contingency table (4 non-negative integers)'     
     +/'3 by 3 contingency tabel (9 non-negative integers)'     
     +/'1 column of numbers (n dimensional vector n =< 30)' 
     +/'2 columns of numbers for plotting/fitting (n =< 15)'      
     +/'1 table of numbers (n by m matrix with n*m =< 30)'
     +/'Help'
     +/'Quit ... Exit input from console procedure')
      end
c
c           