C
C
      SUBROUTINE X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                     OPTS)
C
C ACTION : Get a decision from a list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          16/02/2007 derived from LBOX02
C
      IMPLICIT   NONE
C
C Arguments
C              
      INTEGER,             INTENT (IN)    :: ICOLOR, IX, IY, NUMOPT,
     +                                       NUMPOS(NUMOPT)
      INTEGER,             INTENT (INOUT) :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: OPTS(NUMOPT)
C
C Local allocatable array
C                         
      INTEGER, ALLOCATABLE :: NUMBLD(:)
C
C Locals
C
      INTEGER    LSHADE, NSTART
      PARAMETER (LSHADE = 0, NSTART = 1)
      INTEGER    I, IERR, JCOLOR, NMAX, NTEXT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   W_LBOX01
      EXTERNAL   X_PUTFAT
C
C Check
C      
      IF (NUMOPT.LT.1) THEN
         CALL X_PUTFAT ('NUMOPT < 1 in call to X_LBOX02')
         NUMDEC = 1
         RETURN
      ELSEIF (NUMOPT.EQ.1) THEN
         NUMDEC = NUMOPT
         RETURN   
      ENDIF  
      NMAX = NUMOPT  
      IERR = 0
      IF (ALLOCATED(NUMBLD)) DEALLOCATE(NUMBLD, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(NUMBLD(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Proceed
C
      DO I = 1, NUMOPT
         NUMBLD(I) = 0
      ENDDO
      NTEXT = NUMOPT
      IF (ICOLOR.EQ.0 .OR. ICOLOR.EQ.1 .OR. ICOLOR.EQ.4) THEN
         JCOLOR = ICOLOR
      ELSE
         JCOLOR = 7
      ENDIF
      CALL W_LBOX01 (JCOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +               NUMPOS, NSTART, NTEXT,
     +               OPTS,
     +               BORDER, FLASH, HIGH)
      DEALLOCATE(NUMBLD, STAT = IERR)
      END
C
C
