C
C
      INTEGER FUNCTION X_LEN300 (STRNG)
C
C ACTION : Returns X_LEN300 as the number of characters in the string, but
C          counting capital letters as more than 1 character for the simdem
C          list box controls, or X_LEN300 = 0 if STRING is all blanks
C          The parameter FACTOR controls the extra width for capital letters. 
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/12/2007 developed from X_LEN200
C
      IMPLICIT   NONE
C
C Argument
C      
      CHARACTER (LEN = *), INTENT (IN) :: STRNG
C
C Locals
C
      INTEGER    I, IADD1, J, L 
      DOUBLE PRECISION FACTOR
      PARAMETER (FACTOR = 0.3333D+00)
      CHARACTER  LETTER*1      
      INTRINSIC  DBLE, LEN_TRIM, CEILING
C
C Call LEN_TRIM then return if string is empty
C
      L = LEN_TRIM(STRNG)
      X_LEN300 = L
      IF (L.GT.0) THEN
         IADD1 = 0
         DO I = 1, L
            LETTER = STRNG(I:I)
            J = ICHAR(LETTER)
            IF (J.GE.65 .AND. J.LE.90) IADD1 = IADD1 + 1
         ENDDO
         IF (IADD1.GT.0) THEN
            J = CEILING(DBLE(IADD1)*FACTOR)
            X_LEN300 = X_LEN300 + J  
         ENDIF
      ENDIF  
      END
C
C
