
c x_linux1: no calls to other x_linux? routines
c           returns Linux/Wine configuration parameters and their length
c x_linux2: calls x_linux1 and x_linux3
c           checks for a Linux binary and, if so, returns command as with winepath  
c x_linux3: calls x_linux1
c           returns .true. or .false. for Linux OS 
c x_linux4: calls x_linux1 and x_linux3
c           sets up Linux defaults
c
      subroutine x_linux1 (isend, l,
     +                     strng) 
c
c action: get Linux/Wine configuration parameters
c author: w.g.bardsley, university of manchester, u.k., 30/12/2006 
c         01/02/2007 derived from linux1
c         24/05/2007 replaced w_answer by w_hbox01
c         03/08/2010 introduced getenv@
c         14/01/2011 added call to x_sim256 and x_trim80
c         13/04/2013 increased shell to (len = 1024)
c         23/06/2017 increased shell to 2048 and added test for length of shell 
c         26/06/2017 replaced drive_c by dosdevices/c:/ and path 6 to the bin folder
c         12/09/2019 added test for '*' in shell as (by error) 64-bit can return a string of '*' in windows
c
c isend: (input/unchanged) isend =  1, return strng = the version details 
c                          isend =  2, return strng = the Wine root  
c                          isend =  3, return strng = The Wine Home 
c                          isend =  4, return strng = the Linux home directory 
c                          isend =  5, return strng = the Linux C: drive 
c                          isend =  6, return strng = the Linux bin path
c                          isend =  7, return strng = Wine binary path 1
c                          isend =  8, return strng = Wine binary path 2
c                          isend =  9, return strng = Wine binary path 3  
c                          isend = 10, return strng = Wine binary path 4  
c                          isend = 11, return strng = Editor
c                          isend = 12, return strng = Explorer
c                          isend = 13, return strng = PS-driver
c                          isend = 14, return strng = Clipboard_viewer
c                          isend = 15, return strng = PS-viewer
c                          isend = 16, return strng = PDF-reader
c                          isend = 17, return strng = Calculator
c     l: (output) trimmed length of strng
c strng: (output) trimmed string as determined by isend 
c
c Note: the maximum number of non-blank lines read from the configuration
c       file is limited by the parameter imax and the first line is 
c       set by the value of itype1 and reserved for future developments 
c
      implicit none
c
c arguments
c
      integer,             intent (in)  :: isend
      integer,             intent (out) :: l
      character (len = *), intent (out) :: strng  
c
c locals
c       
      integer    i, ios, itype1, k, x_len200, nout
      integer    imax, imin, itype, iwin
      parameter (imax = 17, imin = 1, itype = 2, iwin = 0)
      integer    icolor, ix, iy, numbin, numhdr, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, numbin = 14, numhdr = 16,
     +           numtxt = 17) 
      integer    lshade, nstart, numopt 
      parameter (lshade = 0, nstart = 15, numopt = 2) 
      integer    jsend, nmax, n, ntext, numdec
      parameter (nmax = numbin + 1) 
      integer    kvalue(nmax), numbld(numhdr), numpos(numopt)        
      integer    l_wine, l_user 
      double precision xvalue(nmax)
      double precision zero
      parameter (zero = 0.0d+00) 
      character (len = 2048) shell, w_getenv
      character  header(numhdr)*100, lines(imax)*1024,
     +           option*100, query(numtxt)*100, temp*1024,
     +           text(numtxt)*1024 
      character  bin(numbin)*80, info(numbin + 1)*40, svalue(nmax)*80
      character  home*1, wine*60, root*1, user*60
      character  blank*1, cfg_fname*12, linux*7, os*9, windows*9
      parameter (blank = ' ', cfg_fname = 'l_simfit.cfg', 
     +           linux = '%linux%', windows = '%windows%')     
      character  fname*1024, x_sim256*1024, x_trim80*80
      character  bslash*1, fslash*1
      parameter (bslash = '\', fslash = '/') 
      logical    first, read_only, there, yesno 
      logical    askif
      parameter (askif = .false.) 
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      external   x_getnou, x_len200, x_putfat, x_triml1, w_hbox01,
     +           x_getany, x_putadv, x_attrib, x_infofl, w_deleet,
     +           w_getenv, x_sim256, x_trim80, x_getstr     
      intrinsic  index  
      save       first
      data       first / .true. /
      data       numbld / numhdr*0 / 
      data       numpos / numopt*1 /!hot key 1 is for L(inux) or W(indows) 
      fname = x_sim256(cfg_fname)
      if (first) then  
c
c first time check if read_only and up to date
c                    
         first = .false.
         call x_attrib (fname,
     +                  there, read_only) 
         if (there) then
            if (read_only) then
c
c warn the user if file is read-only
c            
               k = 6
               call x_infofl (k,
     +                        fname)
            else   
c
c read the version number and deleet if it is obsolete
c            
               call x_getnou (nout)
               open (unit = nout, file = fname, iostat = ios)
               if (ios.eq.0) read (nout,*,iostat=ios) k
               close (unit = nout)
               if (ios.eq.0 .and. k.ne.0) then  
                  if (k.ne.itype) then
                     call w_deleet (fname,
     +                              askif, there)               
                  endif
               endif    
            endif
         endif   
      else
c      
c otherwise see if fname can be located      
c
         inquire (file = fname, exist = there, iostat = ios)         
      endif   
c
c initialise 
c      
      l = 0
      strng = blank
      if (.not.there) then
c
c Part 1: not there so advise user then create a default
c =======
c   
         shell = w_getenv('shell')
         i = x_len200(shell)
         if (i.lt.1 .or. shell.eq.blank) then
c
c it must be windows
c           
            numdec = 2
         elseif (index(shell,'/').gt.0) then
c
c it must be linux
c         
            numdec = 1
         else  
c
c ask the user
c            
            write (header,100) x_trim80(fname)
            numbld(3) = 1 
            numdec = 2
            call w_hbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt,
     +                     numpos, nstart, numhdr,
     +                     header,
     +                     fixed, full, high)
            numbld(3) = 0
         endif   
         if (numdec.eq.1) then
            yesno = .true.
         else
            yesno = .false.
         endif         
         home = 'H'
         user = 'YOUR_home_user_name'
         wine = 'WINE_home_user_name'    
         root = 'Z'
         if (yesno) then
            itype1 = itype  
            os = linux      
            write (query,200)
            jsend = 3      
            n = 1
            ntext = n + 1
            kvalue(1) = 0
            xvalue(1) = zero   
            text(ntext) = blank 
            text(1) = query(2)
            svalue(1) = root
            call x_getstr (text(1), svalue(1))
            root = svalue(1)(1:1)
            text(1) = query(3)
            svalue(1) = home
            call x_getstr (text(1), svalue(1))
            home = svalue(1)(1:1)              
            write (text(1),300) 'home name (e.g. bill)'
            svalue(1) = user
            call x_getstr (text(1), svalue(1))
            user = svalue(1)(1:60) 
            write (text(1),300) 'Wine installation name (e.g. bill)' 
            svalue(1) = wine(1:60)
            call x_getstr (text(1), svalue(1))
            wine = svalue(1)(1:60)
            call x_triml1 (home) 
            call x_triml1 (user)
            call x_triml1 (wine) 
            l_user = x_len200 (user)
            l_wine = x_len200 (wine)
            write (text,400) itype1, os,
     +                       root,    
     +                       home,
     +                       user(1:l_user), 
     +                       wine(1:l_wine), wine(1:l_wine),
     +                       root, root, root, root
c
c edit the configuration details
c                       
            info(1) = 'Edit these values as required'
            do i = 1, numbin 
               bin(i) = text(3 + i)(1:80)
               info(i + 1) = query(3 + i)(1:40) 
            enddo
            jsend = 3  
            n = numbin
            ntext = n + 1
            do i = 1, numbin
               kvalue(i) = 0
               xvalue(i) = zero
            enddo
            call x_getany (jsend, kvalue, n, ntext,
     +                     xvalue,
     +                     bin, info)                
            do i = 1, numbin
               text(3 + i) = bin(i)
            enddo            
         else
            itype1 = iwin 
            os = windows 
            l_user = x_len200 (user)
            l_wine = x_len200 (wine)
            write (text,400) itype1, os,
     +                       root,    
     +                       home,
     +                       user(1:l_user), 
     +                       wine(1:l_wine), wine(1:l_wine),
     +                       root, root, root, root
         endif
c
c create the file
c                                                
         call x_getnou (nout)
         open (unit = nout, file = fname, iostat = ios) 
         do i = 1, numtxt
            write (nout,'(a)',iostat=ios) text(i)
         enddo 
         write (nout,500) cfg_fname  
         write (nout,600)  
         write (nout,700)  
         close (unit = nout) 
         if (yesno) then 
            write (option,800)
            call x_putadv (option)
         endif   
      endif 
c
c Part 2: extract the arguments
c =======
c      
      if (isend.ge.imin .and. isend.le.imax) then         
c
c if imin =< isend =< imax then try to read lines 1 to isend
c      
         call x_getnou (nout)
         open (unit = nout, file = fname, iostat = ios)
         if (ios.eq.0) then
            temp = blank 
            k = 0
            do while (k.lt.isend .and. ios.eq.0)      
               read (nout,'(a)',iostat=ios) temp
               if (temp.ne.blank .and. ios.eq.0) then
                  k = k + 1 
                  lines(k) = temp
               endif   
            enddo   
         endif   
         close (unit = nout) 
c
c if all is well get the string required
c         
         if (ios.eq.0) then  
            temp = lines(isend)
            call x_triml1 (temp)
            l = x_len200 (temp)
            if (l.gt.0) then
               strng = temp 
            else  
               write (temp,900) isend, cfg_fname
               call x_putfat (temp)
               l = 0   
            endif     
c
c check for / and \ and correct if required
c            
            if (isend.gt.1 .and. l.gt.0) then
               if (isend.ge.4 .and. isend.le.6) then 
                  k = index(strng,bslash)
                  do while (k.gt.0) 
                     strng(k:k) = fslash
                     k = index(strng,bslash)
                  enddo
                  if (strng(l:l).ne.fslash) then
                     l = l + 1
                     strng(l:l) = fslash
                  endif 
               elseif (isend.ge.2.and.isend.le.3 .or.
     +                 isend.ge.7.and.isend.le.10) then                  
                  k = index(strng,fslash)
                  do while (k.gt.0) 
                     strng(k:k) = bslash
                     k = index(strng,fslash)
                  enddo 
                  if (strng(l:l).ne.bslash) then
                     l = l + 1
                     strng(l:l) = bslash
                  endif   
               endif   
            endif
         endif    
      endif                       
c
c format statements
c      
  100 format (
     + 'This configuration file is obsolete or missing'
     +/ 
     +/a
     +/
     +/'A correctly formatted version is required so'
     +/'Simfit can work properly in Linux or Windows.' 
     +/
     +/'Windows users must create a Windows version,'
     +/'but Linux users must create a Linux version.'
     +/'It can be edited later using the [Configure],'
     +/'[Advanced], [Check], and [Apply] options'
     +/'from the Simfit main menu.'
     +/
     +/'Now select the operating system required.'
     +/'Linux version'
     +/'Windows version')
  200 format (       
     + 'Version number (0 %windows% for Windows users)'
     +/'Case-insensitive Wine logical drive for Linux root, e.g. Z'
     +/'Case-insensitive Wine logical drive for your Home, e.g. H'
     +/'Linux-style path to Home'
     +/'Linux-style path to C: drive'
     +/'Linux-style path to Simfit' 
     +/'Search path 1 for binaries (obsolete)'
     +/'Search path 2 for binaries (obsolete)'
     +/'Search path 3 for binaries (obsolete)' 
     +/'Search path 4 for binaries (obsolete)'
     +/'Editor, e.g. gedit'
     +/'Explorer, e.g. nautilus' 
     +/'PS-driver, e.g. evince'
     +/'Clipboard viewer, e.g. glipper'
     +/'PS-viewer, e.g. evince'
     +/'PDF-viewer, e.g. evince'
     +/'Calculator, e.g. kcalc, gnome-calculator')       
  300 format ('CASE-SENSITIVE',1x,a)         
  400 format (
     + i1,1x,a   
     +/a,':\'     
     +/a,':\'
     +/'/home/',a,'/'
     +/'/home/',a,'/.wine/dosdevices/c:/'
     +/'/home/',a,'/.wine/dosdevices/c:/Program Files/Simfit/bin/'
     +/a,':\usr\bin\'
     +/a,':\usr\local\bin\'
     +/a,':\opt\kde3\bin\'  
     +/a,':\opt\gnome\bin\'
     +/'notepad'
     +/'explorer'
     +/'gsview'
     +/'***Not Used'
     +/'gsview'
     +/'sumatraPDF'
     +/'calc')
  500 format (   
     +/'Details for the above configuration parameters'
     +/'=============================================='
     +/'The first lines of',1x,a,1x,'must be as follows:' 
     +/' 1: version (use 0 %windows% to disable for Windows users)'
     +/' 2: case-insensitive Wine drive for the root, e.g. Z:\'  
     +/' 3: case-insensitive Wine drive for your Home, e.g. H:\'
     +/' 4: CASE-SENSITIVE full Linux path to your Home directory'
     +/' 5: CASE-SENSITIVE full Linux path to Wine C drive'
     +/' 6: CASE-SENSITIVE full Linux path to the Simfit bin folder'
     +/' 7: case-insensitive Wine system binary search path 1'
     +/' 8: case-insensitive Wine system binary search path 2'    
     +/' 9: case-insensitive Wine system binary search path 3'
     +/'10: case-insensitive Wine system binary search path 4'
     +/'11: favourite editor, e.g. notepad, kwrite, kedit, gedit' 
     +/'12: favourite explorer, e.g. explorer, konqueror, nautilus'  
     +/'13: favourite PS-driver, e.g. gsview, kprinter, lpr' 
     +/'14: favourite clipboard viewer (Not required)' 
     +/'15: favourite PS-viewer, e.g. gsview, kghostview, ggv' 
     +/'16: favourite PDF-reader, e.g. sumatraPDF, kpdf, evince' 
     +/'17: favourite calculator, e.g. calc, kcalc, gcalctool') 
  600 format (  
     +/'WINDOWS USERS' 
     +/'-------------'
     +/'The first line of this file (l_simfit.cfg) must be'
     +/'0 %windows%'
     +/'to disable Linux functions, otherwise Simfit will not run'
     +/'correctly in Windows.'
     +/
     +/'LINUX USERS'  
     +/'-----------'   
     +/'The first line of this file (l_simfit.cfg) must be'
     +/'N %linux%'
     +/'where N is the version number, to enable Linux functions,'
     +/'otherwise Simfit will not run correctly in Linux.' 
     +/'If you run simfit using a command such as'
     +/'      wine w_simfit.exe'
     +/'or equivalent from your home directory, the configuration files'
     +/'      l_simfit.cfg and w_simfit.cfg'
     +/'used to configure Simfit may be stored in your home directory.'
     +/'However, running Simfit from a Wine sub-menu, or by some other'
     +/'methods may mean that copies from the Simfit folder are used.'
     +/'Copies of these files in your home directory and/or the Simfit'
     +/'directory must be edited for the Wine root, and Linux user,'
     +/'etc. without using abbreviations like $HOME or ~.'
     +/'If in doubt, delete these two files and re-start Simfit, when'
     +/'new default versions will be created.')
  700 format (   
     +/'When running Simfit in Linux under Wine, the drive letter used'
     +/'for the root is used to test if a Linux binary has been called'
     +/'instead of a Windows executable. If a Linux auxiliary has been'
     +/'selected, then the Linux path to Simfit may also be required'
     +/'to construct a command line argument in Linux format, e.g.,'
     +/'to read the manual, the Wine path to /usr/bin/evince could be'
     +/ 
     +/'Z:\usr\bin\evince'
     +/
     +/'while the Linux command line passed to this program might be'
     +/
     +/'/home/!/.wine/*/Program Files/Simfit/doc/w_manual.pdf'
     +/'(where ! = your name, and * = dosdrives/c: or else * = drive_c)'
     +/
     +/'and not the Wine name C:\Program Files\Simfit\doc\w_manual.pdf' 
     +/
     +/'Note that Simfit must be configured to add quotation marks if'
     +/'there are space characters in the path, as in this example.')
  800 format (
     +'Use [Configure] then [Advanced] to check/edit your choices')   
  900 format ('Cannot read line',i3,1x,'from',1x,a)   
      end
c
c 
