c
c x_linux1: no calls to other x_linux? routines
c           returns Linux/Wine configuration parameters and their length
c x_linux2: calls x_linux1 and x_linux3
c           checks for a Linux binary and, if so, returns command as with winepath  
c x_linux3: calls x_linux1
c           returns .true. or .false. for Linux OS 
c x_linux4: calls x_linux1 and x_linux3
c           sets up Linux defaults
c
     
c
c
      subroutine x_linux2 (binary, command_line)
c
c action: check for a Linux binary and, if so, alter the command line
c author: w.g.bardsley, university of manchester, u.k., 31/12/2006 
c
c       binary: (input/unchanged) the executable program
c command_line: (input/output) the command line, usually a file
c
c Note: calls to linux1 return the argument as follows:
c isend = 1 ... Version
c isend = 2 ... Root,         e.g Z:\    
c isend = 3 ... Home,         e.g H:\
c isend = 4 ... Linux Home,   e.g. /home/bill/
c isend = 5 ... Linux C:,     e.g. /home/bill/.wine/dosdrives/c:
c isend = 6 ... Linux Simfit, e.g. /home/bill/.wine/dosdrives/c:/Program Files/simfit/bin 
c isend = 7 ... Search path,  e.g. Z:\usr\bin\
c isend = 8 ... Search path,  e.g. Z:\usr\local\bin\
c isend = 9 ... Search path,  e.g. Z:\opt\kde4\bin\  
c isend = 10 ... Search path, e.g. Z:\opt\gnome\bin\  
c isend = 11 ... editor
c isend = 12 ... explorer               
c isend = 13 ... PS-driver  
c isend = 14 ... clipboard viewer  
c isend = 15 ... PS-viewer  
c isend = 16 ... PDF-reader  
c isend = 17 ... calculator  
c                                            
c
      implicit none
c
c arguments
c
      character (len = *), intent (in)    :: binary  
      character (len = *), intent (inout) :: command_line      
c
c locals
c      
              
      integer    isend, j, k, l
      integer    x_len200 
      character (len = 1024) copy, temp, test
      character (len = 3   ) word3
      character  back_slash*1, blank*1, colon_slash*2, forward_slash*1
      parameter (back_slash = '\', blank = ' ', colon_slash = ':\',
     +           forward_slash = '/')
      logical    x_linux3
      external   x_linux1, x_linux3, x_lcase1, x_triml1, x_simdir,
     +           x_len200, x_docdir, x_demdir 
      intrinsic  index   
c
c Part 1: First see if the binary is a Linux program and if so trim command_line
c ======
c                                 
      if (x_linux3(binary)) then
         call x_triml1 (command_line)
      else
         return
      endif  
c
c Part 2: It is a Linux binary so now check the command_line for a simple file name
c ======
c                                         
      if (command_line.eq.blank) return
      k = index (command_line, back_slash)
      if (k.le.0) return  
c
c Part 3: initialise, then check for the Home directory 
c =======
c    
      copy = blank
      temp = blank
      test = blank
      l = x_len200(command_line)
      if (l.gt.3) then
        word3 = command_line(1:3)
      else
        word3 = '***'
      endif    
c
c temp is now set to the trimmed lower case version of the original command line
c      
      temp = command_line
      call x_lcase1 (temp)
      isend = 3
      call x_linux1 (isend, l,
     +               test)  
      if (l.le.0) return
      copy = test
      call x_lcase1 (copy)   
      k = index (temp, copy(1:l))
      if (k.eq.1) then 
c
c the file begins with e.g. H:\ or h:\
c          
         j = l
         k = x_len200(command_line)
         if (k.gt.j) then
            isend = 4
            call x_linux1 (isend, l,
     +                     test) 
            if (l.le.0) return 
            copy = test(1:l)//command_line(j + 1:k)
            k = index (copy, back_slash)
            do while (k.gt.0)  
               copy(k:k) = forward_slash
               k = index (copy, back_slash)
            enddo 
            command_line = copy 
            goto 20
         endif   
      endif       
c
c Part 4: Now check the command line for the simfit doc, dem, and simfit path
c =======
c        
      call x_docdir (l,
     +               test)
      if (l.le.0) return
      call x_lcase1 (test)
      k = index (temp, test(1:l)) 
      if (k.gt.0) then 
c
c the file is in the Simfit doc directory
c      
         isend = 6
         call x_linux1 (isend, l,
     +                  test)
         test (l - 3:l - 1) = 'doc'
         if (l.le.0) return 
         j = index (command_line, back_slash, back = .true.)  
         if (j.gt.0) then   
            k = x_len200 (command_line) 
            if (k.gt.j) then
               copy = test(1:l)//command_line(j + 1:k)
               command_line = copy         
            endif   
            goto 20
         endif   
      endif     
      call x_demdir (l,
     +               test)
      if (l.le.0) return
      call x_lcase1 (test)
      k = index (temp, test(1:l)) 
      if (k.gt.0) then 
c
c the file is in the Simfit doc directory
c      
         isend = 6
         call x_linux1 (isend, l,
     +                  test)
         test (l - 3:l - 1) = 'dem'
         if (l.le.0) return 
         j = index (command_line, back_slash, back = .true.)  
         if (j.gt.0) then   
            k = x_len200 (command_line) 
            if (k.gt.j) then
               copy = test(1:l)//command_line(j + 1:k)
               command_line = copy         
            endif   
            goto 20
         endif   
      endif           
      call x_simdir (l,
     +               test)
      if (l.le.0) return
      call x_lcase1 (test)
      k = index (temp, test(1:l)) 
      if (k.gt.0) then 
c
c the file is in the Simfit directory
c      
         isend = 6
         call x_linux1 (isend, l,
     +                  test)
         if (l.le.0) return 
         j = index (command_line, back_slash, back = .true.)  
         if (j.gt.0) then   
            k = x_len200 (command_line) 
            if (k.gt.j) then
               copy = test(1:l)//command_line(j + 1:k)
               command_line = copy         
            endif   
            goto 20
         endif   
      endif
c
c Part 5 : Finally check the command line for an arbitrary path
c =======
c                      
      if (temp(1:1) .eq. back_slash) then
         j = 1
      elseif (temp(2:3) .eq. colon_slash) then
         j = 3
      else
         j = 0
      endif
      if (j.gt.0) then      
c
c the command line starts with \ or ?:\, e.g. C:\
c          
         isend = 5
         call x_linux1 (isend, l, 
     +                  test) 
         if (l.le.0) return
         k = x_len200 (command_line)  
         if (k.gt.j) then
            copy = test(1:l)//command_line(j + 1:k)
            k = index (copy, back_slash)
            do while (k.gt.0) 
               copy(k:k) = forward_slash        
               k = index(copy, back_slash)
            enddo   
            command_line = copy     
            goto 20
         endif
      endif  
   20 continue
c
c make sure all \ have been changed to / and c:\ changed to d:\ if required
c      
      if (word3(2:3).eq.':\') then
         if (word3(1:1).ne.'c' .and. word3(1:1).ne.'C') then
            l = index(command_line,'dosdevices')
            if (l.gt.0) then
               command_line(l + 11:l + 13) = word3
            endif  
         endif  
      endif   
      k = index(command_line, back_slash)
      do while (k.gt.0)       
         command_line(k:k) = forward_slash
         k = index(command_line, back_slash)
      enddo    
      end
c
c         
 
             