c
c x_linux1: no calls to other x_linux? routines
c           returns Linux/Wine configuration parameters and their length
c x_linux2: calls x_linux1 and x_linux3
c           checks for a Linux binary and, if so, returns command as with winepath  
c x_linux3: calls x_linux1
c           returns .true. or .false. for Linux OS 
c x_linux4: calls x_linux1 and x_linux3
c           sets up Linux defaults
c
      
c
c
      logical function x_linux3 (fname)
c
c action: test for operating system or if a binary is a Linux binary
c author: w.g.bardsley, university of manchester, u.k., 02/01/2007 
c         17/01/2007 improved test when argument is * or ? 
c         01/02/2007 derived from linux3
c
c fname: (input/unchanged) query or possible Linux program
c 
c There are two cases: 
c -------------------
c 1) fname = * or ?: l_simfit.cfg is investigated to see if it is a linux OS
c 2)      otherwise: returned as .true. only if fname starts with, e.g. Z:\ 
c
      implicit none
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c       
      integer    l
      integer    ios, isend, itemp, itype
      character  copy*1024, test*1024, temp*50
      character  linux*5, windows*7, quest*1, star*1, word1*1
      parameter (quest = '?', star = '*', linux = 'linux',
     +           windows = 'windows')
      logical    first, linux_os
      external   x_linux1, x_triml1, x_lcase1 
      intrinsic  index
      save       first, linux_os
      data       first, linux_os / .true., .false. /      
c
c initialise
c        
      x_linux3 = .false.
      copy = fname
      call x_lcase1 (copy)
      call x_triml1 (copy) 
      word1 = copy(1:1)
c
c check for operating system if fname = ? or *
c      
      if (word1.eq.quest .or.  word1.eq.star) then 
         if (first) then
            first = .false.
            isend = 1
            call x_linux1 (isend, l,
     +                     test)         
            read (test,*,iostat=ios) itemp, temp 
            if (ios.eq.0) then
               itype = itemp
            else
               itype = 0
            endif 
            if (itype.le.0 .or. index(test,windows).gt.0) return              
            if (itype.gt.0 .or. index(test,linux).gt.0) then
               x_linux3 = .true.
               linux_os = .true.
            endif   
         else
            x_linux3 = linux_os
         endif       
      else         
c
c check if it is like Z:\...
c      
         isend = 2
         call x_linux1 (isend, l,
     +                  test) 
         if (l.le.0) return 
         call x_lcase1 (test)
         if (index(copy, test(1:l)).eq.1) x_linux3 = .true.
      endif
      end
c
c

        