c
c x_linux1: no calls to other x_linux? routines
c           returns Linux/Wine configuration parameters and their length
c x_linux2: calls x_linux1 and x_linux3
c           checks for a Linux binary and, if so, returns command as with winepath  
c x_linux3: calls x_linux1
c           returns .true. or .false. for Linux OS 
c x_linux4: calls x_linux1 and x_linux3
c           sets up Linux defaults
c
      subroutine x_linux4 (isend, 
     +                     cval,
     +                     abort)
c
c action: linux configuration defaults
c author: w.g.bardsley, university of manchester, u.k., 10/01/2007
c         17/01/2007 extensive revision to try user supplied defaults 
c         01/02/2007 derived from linux4
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: isend 
      character (len = *), intent (inout) :: cval(12)
      logical,             intent (out)   :: abort
c
c locals
c              
      integer    i, j, k, l(4)
      integer    x_len200 
      character  path(4)*1024
      character  dfolt1(12)*80, dfolt2(12)*80, dfolt3(12)*80, test*80
      character  blank*1, bslash*1, fslash*1 
      parameter (blank = ' ', bslash = '\', fslash = '/')
      logical    action(12), x_linux3, there 
      logical    first, linux_os
      external   x_linux1, x_linux3, x_len200, x_triml1 
      intrinsic  index
      save       first, linux_os
      data       first, linux_os / .true., .false. /
      data       action /  .true.,  .true., .false., .false.,
     +                    .false.,  .true.,  .true.,  .true.,
     +                    .false.,  .true.,  .true.,  .true. /  
c
c first set of defaults (some will be overwritten)
c     
      data       dfolt1 / 'kwrite',
     +                    'konqueror',
     +                    'C:\Program Files\Simfit\bin',
     +                    'Not required in Linux',
     +                    'Not required in Linux',
     +                    'kprinter',
     +                    'klipper',
     +                    'gs',
     +                    'Not required in Linux',
     +                    'kghostview',
     +                    'kpdf',
     +                    'kcalc' /  
c
c second set of defaults
c     
      data       dfolt2 / 'kedit',
     +                    'konqueror',
     +                    'C:\Program Files\Simfit\bin',
     +                    'Not required in Linux',
     +                    'Not required in Linux',
     +                    'kprinter',
     +                    'glipper',
     +                    'ghostscript',
     +                    'Not required in Linux',
     +                    'kghostview',
     +                    'kpdf',
     +                    'speedcrunch' /     
c
c third set of defaults (3, 4, 5, and 9 are not used)
c     
      data       dfolt3 / 'gedit',
     +                    'nautilus',
     +                    'C:\Program Files\Simfit\bin',
     +                    'Not required in Linux',
     +                    'Not required in Linux', 
     +                    'lpr',
     +                    'glipper',
     +                    'gs',
     +                    'Not required in Linux',
     +                    'evince',   
     +                    'evince',
     +                    'gnome-calculator' /  
c
c initialise and check for linux_os
c     
      abort = .true.
      if (first) then  
         first = .false.       
c
c first time pick up linux_os and dfolt1 from l_simfit.cfg
c    
         linux_os = x_linux3('?')
         if (.not.linux_os) return      
         j = 11
         call x_linux1 (j, k,
     +                  dfolt1(1))!editor
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(2))!explorer               
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(6))!PS-driver 
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(7))!clipboard viewer
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(10))!PS-viewer
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(11))!PDF-reader
         j = j + 1
         call x_linux1 (j, k,
     +                  dfolt1(12))!calculator
      else 
        if (.not.linux_os) return
      endif  
c
c linux4 has been called correctly so pick up the search 
c paths by calling linux1 with isend = 7, 8, and 9
c                
      j = 6
      do i = 1, 4
         j = j + 1   
         call x_linux1 (j, l(i),
     +                  path(i))
         if (l(i).le.0 .or. path(i).eq.blank) return
      enddo  
c
c seems OK so set abort = .false. and proceed
c       
      abort = .false.
      if (isend.eq.1) then  
c
c isend = 1: set up defaults if isend = 1, then return
c =========
c                
         do i = 1, 12  
            if (action(i)) then 
               there = .false.     
               j = 0  
               do while(j.lt.4 .and. .not.there)
                  j = j + 1
                  cval(i) = path(j)(1:l(j))//dfolt1(i)
                  inquire (file = cval(i), exist = there) 
                  if (.not.there) then
                     cval(i) = path(j)(1:l(j))//dfolt2(i)
                     inquire (file = cval(i), exist = there)
                  endif
                  if (.not.there) then
                     cval(i) = path(j)(1:l(j))//dfolt3(i)
                     inquire (file = cval(i), exist = there)
                  endif    
               enddo
               if (.not.there) then  
                  cval(i) = path(1)//dfolt1(i)
               endif   
            else 
               cval(i) = dfolt1(i)
            endif
         enddo  
         return
      endif 
c
c isend not equal to 1: so check the current settings
c ====================
c                                          
      do i = 1, 12
        
         if (action(i)) then
          
            inquire (file = cval(i), exist = there)
            if (.not.there) then  
c
c if blank create a default otherwise extract the file name and search
c            
               if (cval(i).eq.blank) then 
                  cval(i) = path(1)(1:l(1))//dfolt1(i)  
               else   
                  call x_triml1 (cval(i))
                  k = index(cval(i),fslash)
                  do while (k.gt.0)
                     cval(i)(k:k) = bslash
                     k = index(cval(i),fslash) 
                  enddo 
               endif   
               inquire (file = cval(i), exist = there) 
               if (.not.there) then 
                  j = index(cval(i),bslash,back=.true.)
                  if (j.le.0) j = 1   
                  k = x_len200 (cval(i))
                  test = cval(i)(j + 1:k)
               endif  
               j = 0
               do while (j.lt.4 .and. .not.there)  
c
c search the paths for the program requested
c               
                  j = j + 1     
                  cval(i) = path(j)(1:l(j))//test
                  inquire (file = cval(i), exist = there) 
                  if (.not.there) then
                     cval(i) = path(j)(1:l(j))//test
                     inquire (file = cval(i), exist = there)
                  endif   
               enddo   
               j = 0
               do while (j.lt.4 .and. .not.there)
c
c try the defaults again
c               
                  j = j + 1     
                  cval(i) = path(j)(1:l(j))//dfolt1(i)
                  inquire (file = cval(i), exist = there) 
                  if (.not.there) then
                     cval(i) = path(j)(1:l(j))//dfolt2(i)
                     inquire (file = cval(i), exist = there)
                  endif 
                  if (.not.there) then
                     cval(i) = path(j)(1:l(j))//dfolt3(i)
                     inquire (file = cval(i), exist = there)
                  endif     
               enddo
            endif      
            
         else
         
            if (i.ne.3) cval(i) = dfolt1(i)
            
         endif
         
      enddo                           
      end
c
c                      