C
C
      SUBROUTINE X_LISTBX (NUMDEC, NUMOPT,
     +                     OPTS)
C
C ACTION : Get a decision from a tabbing list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/2/97
C          11/09/1998 dimension increased to 101
C          03/01/2000 derived from LBOX02
C          06/12/2000 now calls LVIEW2
C          18/12/2000 NMAX = 201 and now checks for graves and tabbing
C          07/01/2001 NMAX = 500 
C          26/02/2007 revised, added INTENTS and ALLOCATABLES
C          12/06/2007 this version calls X_LVIEW2, X_PUTFAT, and X_LBOX02 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NUMOPT
      INTEGER,             INTENT (INOUT) :: NUMDEC  
      CHARACTER (LEN = *), INTENT (IN)    :: OPTS(NUMOPT) 
C
C Local allocatable array
C                        
      INTEGER, ALLOCATABLE :: NUMPOS(:)
      CHARACTER (LEN = 129), ALLOCATABLE :: TEXT(:)
C
C Locals
C      
      INTEGER    IERR
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      INTEGER    I, NGRAVE
      CHARACTER  BLANK*1, GRAVE*1
      PARAMETER (BLANK = ' ', GRAVE = '`')
      LOGICAL    TITLES
      PARAMETER (TITLES = .FALSE.)
      EXTERNAL   X_LVIEW2, X_PUTFAT, X_LBOX02
      INTRINSIC  INDEX
C
C Check arguments supplied
C
      IF (NUMOPT.LT.1) THEN
         CALL X_PUTFAT ('NUMOPT < 1 in call to X_LISTBX')
         RETURN
      ENDIF
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF
      IF (NUMDEC.LT.1 .OR. NUMDEC.GT.NUMOPT) THEN
         CALL X_PUTFAT ('NUMDEC out of range in call to X_LISTBX')
         NUMDEC = NUMOPT
         RETURN
      ENDIF
C
C Check for tabbing
C
      NGRAVE = 0  
      I = 0
      DO WHILE (NGRAVE.EQ.0 .AND. I.LT.NUMOPT)
         I = I + 1
         IF (INDEX(OPTS(I),GRAVE).GT.0) NGRAVE = NGRAVE + 1
      ENDDO 
C
C Copy OPTS into TEXT
C      
      IERR = 0
      IF (ALLOCATED(TEXT)) DEALLOCATE(TEXT,STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(TEXT(NUMOPT + 1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      DO I = 1, NUMOPT
         TEXT(I) = OPTS(I)
      ENDDO     
      IF (NGRAVE.GT.0) THEN
C
C Tabbing so call X_LVIEW2
C                                      
         TEXT(NUMOPT + 1) = BLANK
         CALL X_LVIEW2 (IX, IY, NUMDEC, NUMOPT, 
     +                  TEXT,
     +                  TITLES)
         DEALLOCATE (TEXT, STAT = IERR)
      ELSE
C
C No tabbing so call X_LBOX02
C  
         IERR = 0
         IF (ALLOCATED(NUMPOS)) DEALLOCATE(NUMPOS, STAT = IERR)
         IF (IERR.NE.0) RETURN
         ALLOCATE(NUMPOS(NUMOPT), STAT = IERR)
         DO I = 1, NUMOPT
            NUMPOS(I) = 1
         ENDDO   
         IF (IERR.NE.0) RETURN    
         CALL X_LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS, 
     +                  TEXT) 
         DEALLOCATE (NUMPOS, STAT = IERR)
      ENDIF 
      END
C
C
