C
C
      SUBROUTINE X_LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                     TEXT,
     +                     TITLES)
C
C ACTION : Get a decision from a tabbed list view. Tabbing at grave accents.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 01/12/2000
C          07/01/2001 included check for | in option supplied
C          18/11/2006 added INTENTS
C          16/02/2007 derived from LVIEW1
C          01/06/2007 deleted W_DBLEUP 
C
C IX, IY: (input/unchanged) position of the control
C NUMDEC: (input/output) no. of decision made by user (enter with default value)
C NUMOPT: (input/unchanged) no. of options available
C   TEXT: (input/unchanged)header, titles, options available and trailing text
C TITLES: (input/unchanged) if .TRUE. use the titles supplied in TEXT(NSTART - 1)
C                           if .FALSE. create titles and insert before TEXT(NSTART)
C
C          Strategy
C          ========
C          Only NUMDEC is returned altered by this routine. Everything else
C          is copied and then the original arguments are returned unchanged.
C          The TEXT character array is processed according to the values of
C          NSTART, NTEXT, NUMOPT and TITLES as follows.
C          a) [TITLES = .TRUE.] TEXT(NSTART - 1) is taken to be the titles and
C             so no new lines are created. TEXT(1) to TEXT(NSTART - 2) are the
C             header, which is tabbed at grave characters. TEXT(NSTART) to
C             TEXT(NSTART + NUMOPT - 1) are the menu items, and
C             TEXT(NSTART + NUMOPT) to TEXT(NTEXT) are the trailer, tabbed at
c             grave characters, just like the header.
C          b) [TITLES = .FALSE.] A new line is inserted (to space out the
C             columns and act as a dummy title). Then the TEXT is processed
C             exactly as in a).
C          Then the menu items are processed so that every line starts with
C          a bar and every grave in the menu is replaced by a bar. Finally
C          the character array ITEMS is analysed to make sure every line has
C          precisely the same number of columns, i.e. NCOL bars, separating
C          NCOL columns.
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IX, IY, NUMOPT, NSTART,
     +                                       NTEXT
      INTEGER,             INTENT (INOUT) :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NTEXT) 
      LOGICAL,             INTENT (IN)    :: TITLES
C
C Locals
C      
      INTEGER    NMAX, NCMAX, N1, N2
      PARAMETER (NMAX = 500, NCMAX = 10, N1 = 1, N2 = 2)
      INTEGER    I, IADDUP, ICOUNT, J, K, L, X_LEN200, M, N, NBAR,
     +           NBEGIN, NBOT, NCOL, NTOTAL, NTOP, NWIDE(NCMAX)
      CHARACTER  ITEMS(NMAX + 1)*100, LINE*100, OPTS(NMAX + 1)*100
      CHARACTER  A*1, BAR*1, BLANK*1, GRAVE*1
      PARAMETER (A = 'x', BAR = '|', BLANK = ' ', GRAVE = '`')
      EXTERNAL   W_LVIEW1, X_LEN200, X_PUTFAT
      INTRINSIC  INDEX
C
C Include this code if a dimension check is required
C
      IF (NUMOPT.GT.NMAX) THEN
         CALL X_PUTFAT ('Dimension NMAX exceeded in call to X_LVIEW1')
         RETURN
      ENDIF

c
c Part 1: check the arguments supplied and fill in the array opts
c =======
c
      if (numopt.eq.n1) then
         numdec = n1
         return
      endif

      nbar = 0
      if (titles) then
         if (numopt.lt.n1 .or. numopt + n1.gt.ntext .or.
     +       nstart.lt.n2 .or. nstart + numopt - n1.gt.ntext) then
             call x_putfat (
     +'nstart/numopt/ntext inconsistent in call to X_LVIEW1')
             return
         endif
         ntop = nstart - n2
         do i = n1, numopt + n1
            opts(i) = text(ntop + i)
            if (index(opts(i),bar).gt.0) nbar = nbar + 1
         enddo
         nbegin = nstart
         ntotal = ntext
         k = nstart - n1
      else
         if (numopt.lt.n1 .or. numopt.gt.ntext .or.
     +       nstart.lt.n1 .or. nstart + numopt - n1.gt.ntext) then
             call x_putfat (
     +'nstart/numopt/ntext inconsistent in call to X_LVIEW1')
             return
         endif
         ntop = nstart - n1
         do i = n1, numopt
            opts(i) = text(ntop + i)
            if (index(opts(i),bar).gt.0) nbar = nbar + 1
         enddo
         nbegin = nstart + n1
         ntotal = ntext + n1
         k = nstart
      endif

      if (nbar.gt.0) then
         call x_putfat ('Options supplied contain illegal | character')
         return
      endif

      nbot = ntext - (nstart + numopt - n1)
      if (numdec.lt.n1) numdec = n1
      if (numdec.gt.numopt) numdec = numopt
C
C Part 2: Initialise then process all options
C =======
C
      DO I = 1, NCMAX
         NWIDE(I) = 0
      ENDDO
      NCOL = 0
C
C Process each option
C
      IF (TITLES) THEN
         N = NUMOPT + 1
      ELSE
         N = NUMOPT
      ENDIF
      DO I = 1, N
         IADDUP = 0
         ICOUNT = 0
         M = X_LEN200(OPTS(I))
         LINE = BAR//OPTS(I)(1:M)
         J = INDEX(LINE,GRAVE)
         K = 2
C
C Replace every grave by a bar and calculate NWIDE
C
         DO WHILE (J.GT.0)
            ICOUNT = ICOUNT + 1
            L = J - K
            IF (L.GT.NWIDE(ICOUNT)) THEN
               NWIDE(ICOUNT) = L
            ENDIF
            IADDUP = IADDUP + L + 1
            K = J + 1
            LINE(J:J) = BAR
            J = INDEX(LINE,GRAVE)
         ENDDO
C
C Now deal with the last column
C
         ICOUNT = ICOUNT + 1
         J = M - IADDUP
         IF (J.GT.NWIDE(ICOUNT)) NWIDE(ICOUNT) = J
         IF (ICOUNT.GT.NCOL) NCOL = ICOUNT
C
C Then copy the line into the ITEMS array
C
         ITEMS(I) = LINE
      ENDDO
C
C Create titles using character A and appropriate bars if no title is supplied
C
      IF (.NOT.TITLES) THEN
         DO I = NUMOPT + 1, 2, - 1
            ITEMS(I) = ITEMS(I - 1)
         ENDDO
         ICOUNT = 0
c
c overall no. characters = sum(column widths + bars + 4 extra characters)
c
         DO I = 1, NCOL
            ICOUNT = ICOUNT + NWIDE(I) + 5
         ENDDO
         ITEMS(1) = BLANK
         DO I = 1, ICOUNT
            ITEMS(1)(I:I) = A
         ENDDO
         ICOUNT = 1
         ITEMS(1)(ICOUNT:ICOUNT) = BAR
         DO I = 1, NCOL - 1
            ICOUNT = ICOUNT + NWIDE(I) + 5
            ITEMS(1)(ICOUNT:ICOUNT) = BAR
         ENDDO
       ENDIF
C
C Finally make sure that all lines have precisely NCOL bars
C
      DO I = 1, NUMOPT + 1
         J = X_LEN200(ITEMS(I))
         IADDUP = 0
         DO K = 1, J
            IF (ITEMS(I)(K:K).EQ.BAR) IADDUP = IADDUP + 1
         ENDDO
         IF (IADDUP.LT.NCOL) THEN
            DO K = 1, NCOL - IADDUP
               J = J + 1
               ITEMS(I)(J:J) = BAR
             ENDDO
         ENDIF
      ENDDO
C
C Part 3: copy the header and trailer, using w_dbleup to trap % and $
C =======
C
      ICOUNT = 0
      IF (NTOP.GT.0) THEN
         DO I = 1, NTOP
            ICOUNT = ICOUNT + 1
            OPTS(ICOUNT) = TEXT(I)
         ENDDO
      ENDIF
      DO I = 1, NUMOPT + 1
         ICOUNT = ICOUNT + 1
         OPTS(ICOUNT) = ITEMS(I)
      ENDDO
      IF (NBOT.GT.0) THEN
         J = NSTART + NUMOPT - 1
         DO I = 1, NBOT
            ICOUNT = ICOUNT + 1
            J = J + 1
            OPTS(ICOUNT) = TEXT(J)
         ENDDO
      ENDIF
C
C Part 4: call w_lview1 with the new arguments
C =======
C
      CALL W_LVIEW1 (IX, IY, NUMDEC, NUMOPT, NBEGIN, NTOTAL,
     +               OPTS,
     +               TITLES)
      END
C
C
