c
c
      subroutine x_nagdem (isend,
     +                     fname)
c
c action: demonstrate the nag library test files
c author: w.g.bardsley, university of manchester, u.k., 26/02/2005
c         23/11/2006 edited, and added full paths to files as the NAG
c                    files and list.nag are stored in the simfit folder 
c         19/01/2007 changed to look locally if Simfit folder does not exist 
c                    and introduced calls to infofl and simdir
c         16/02/2007 derived from nagdem
c
c         isend: (input/unchanged) as follows
c                isend = 1: view only
c                isend = 2: view or open
c                o/w future developments
c         fname:(output)
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: isend
      character (len = *), intent (out) :: fname
c
c locals
c
      integer    icolor,ix, iy, mode, nmax
      parameter (icolor = 7, ix = 4, iy = 4, mode = 1, nmax = 500)
      integer    i, ios, jsend, nag, numdec, nout
      integer    numpos(nmax)
      character  demo(nmax)*1024, line*80, text(nmax)*80 
      character  full_lstnag*1024, full_word10*1024
      character  x_aux256*1024, x_sim256*1024
      character  blank*1, lstnag*12, word10*10
      parameter (blank = ' ', lstnag = 'list.nag')
      logical    repeet, there, view, simfit
      external   x_getnou, x_vuopen, x_putfat, x_triml1, w_viewer,
     +           x_lbox02, x_sim256, x_ucase1, x_infofl, x_aux256   
c
c check isend
c
      if (isend.lt.1 .or. isend.gt.2) then
         write (line,100)
         call x_putfat (line)
         return
      endif
c
c check for 'list.nag'
c                                 
      full_lstnag = x_sim256(lstnag)
      inquire (file = full_lstnag, exist = there)
      if (there) then
        simfit = .true.
      else
        simfit = .false.
      endif    

      if (.not.there) then
         full_lstnag = x_aux256(lstnag)
         inquire (file = full_lstnag, exist = there)
      endif  
      
      if (.not.there) then   
         jsend = 1
         call x_infofl (jsend,
     +                  lstnag)         
         return
      endif
c
c open the file
c
      call x_getnou (nout)
      open (unit = nout, file = full_lstnag, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)   
         jsend = 4
         call x_infofl (jsend,
     +                  full_lstnag)         
         return
      endif
c
c read the contents
c
      nag = 1
      demo(nag) = 'Cancel'
      text(nag) = demo(nag)(1:80)
      do while (nag.lt.nmax .and. ios.eq.0)
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0) then
            call x_triml1 (line)
            word10 = line(1:10)
            if (simfit) then
               full_word10 = x_sim256(word10)
            else   
               full_word10 = x_aux256(word10)
            endif   
            inquire (file = full_word10, exist = there)
            if (there) then
               nag = nag + 1
               demo(nag) = full_word10  
               call x_ucase1 (word10)
               line(1:10) = word10
               text(nag) = line  
            endif
         endif
      enddo
      close (unit = nout)
c
c check that file is not empty
c
      if (nag.eq.1) then 
         jsend = 5
         call x_infofl (jsend,
     +                  full_lstnag)         
         return
      endif   
      do i = 1, nag
         numpos(i) = 1
      enddo   
      repeet = .true.
      numdec = 1
      view = .true.
      fname = blank
      do while (repeet)
         if (isend.eq.1) then
c
c view only
c
            call x_lbox02 (icolor, ix, iy, numdec, nag, numpos,
     +                     text)
            view = .true.
         else
c
c view or select
c
            call x_vuopen (numdec, nag,
     +                     text,
     +                     view)
         endif
         if (numdec.eq.1) then
c
c cancel has been selected
c
            repeet = .false.
            fname = blank
         else
            fname = demo(numdec)
            if (view) then
c
c view the selected file
c
               call w_viewer (mode,
     +                        fname, blank, blank)
            else
c
c return with the file selected
c
               return
            endif
         endif
      enddo    
c
c format statement
c      
  100 format ('ISEND out of range in call to X_NAGDEM')
      end
c
c
