C
C NAG substitute routines from maths.dll to make W_CLEARWIN.DLL
C free standing.
C Routines start with X_ so there will be no clashes.
C
C G01EEF
C G01FAF
C G01FBF
C G01FEF
C S14ABF
C X02AJF     
C X02AMF
C
     
C
C
      SUBROUTINE X_G01EEF (XVAL, AVAL, BVAL, TOLVAL, PVAL, QVAL, PDFVAL,
     +                     IFAIL)
C
C ACTION : beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          AS 63 Majumder and Bhattacharjee, 409-411, 1973
C
C          This version uses log(beta) to avoid underflow problems
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, PDFVAL, QVAL, TOLVAL, XVAL
C
C Local variables
C
      INTEGER   I, NS
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-10, ONE = 1.0D+00)
      DOUBLE PRECISION ABLIM, XMAX, XMIN, XMIN4
      PARAMETER (ABLIM = 1.0D+06, XMIN = 1.0D-16, XMAX = ONE - XMIN,
     +           XMIN4 = XMIN**4)
      DOUBLE PRECISION ACU, AI, BETA, BETAIN, CX, P, PP, PSQ, Q, QQ,
     +                 RX, TEMP, TERM, X, XX, X1, X2, X3
      DOUBLE PRECISION X_S14ABF
      LOGICAL INDEX1
      EXTERNAL X_S14ABF
      INTRINSIC ABS, EXP, INT, LOG
C
C Initialise
C
      IFAIL = 0
      PDFVAL = ZERO
      PVAL = ZERO
      QVAL = ZERO
C
C Is it safe ?
C
      IF (XVAL.LT.ZERO .OR. XVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         X = XVAL
         IF (X.LE.XMIN4) THEN
            X = XMIN4
         ELSEIF (X.GT.XMAX) THEN
            X = XMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
      ACU = TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA
C
       I = 1
       X1 = X_S14ABF(P, I)
       I = 1
       X2 = X_S14ABF(Q, I)
       I = 1
       TEMP = P + Q
       X3 = X_S14ABF(TEMP, I)
       TEMP = X1 + X2 - X3
C********************************************
C******BETA = EXP(TEMP)....(original version)
C Use log(beta) instead of beta itself
C********************************************
       BETA = TEMP
C
C Swap tails if recommended
C
       PSQ = P + Q
       CX = ONE - X
       IF (P .LT. PSQ*X) THEN
          INDEX1 = .TRUE.
          XX = CX
          CX = X
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          XX = X
          PP = P
          QQ = Q
       ENDIF
C
C Set up the iteration
C
       TERM = ONE
       AI = ONE
       BETAIN = ONE
       NS = INT(QQ + CX*PSQ)
       RX = XX/CX
C
C Use Soper's reduction formula
C
   20 CONTINUE
      TEMP = QQ - AI
      IF (NS.EQ.0) RX = XX
   40 CONTINUE
      TERM = TERM*TEMP*RX/(PP + AI)
      BETAIN = BETAIN + TERM
      TEMP = ABS(TERM)
      IF (TEMP.LE.ACU .AND. TEMP.LE.ACU*BETAIN) GOTO 60
      AI = AI + ONE
      NS = NS - 1
      IF (NS.GE.0) GOTO 20
      TEMP = PSQ
      PSQ = PSQ + ONE
      GOTO 40
   60 CONTINUE
C
C Final calculation
C
C******************************************************************
C Use log(beta) rather than beta itself
C ....original version
C     BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX))/(PP*BETA)
C*******************************************************************
      BETAIN = BETAIN*EXP(PP*LOG(XX) + (QQ - ONE)*LOG(CX) - BETA)/PP
      IF (BETAIN.LT.ZERO) THEN
         BETAIN = ZERO
      ELSEIF (BETAIN.GT.ONE) THEN
         BETAIN = ONE
      ENDIF
      IF (INDEX1) BETAIN = ONE - BETAIN
      PVAL = BETAIN
      QVAL = ONE - PVAL
C*****************************************************
C Use log(beta) instead of beta as in original version
C     PDFVAL = X**(P - ONE)*(ONE - X)**(Q - ONE)/BETA
C*****************************************************
      PDFVAL = EXP((P - ONE)*LOG(X) + (Q - ONE)*LOG(ONE - X) - BETA)
      END
C
C
C
      DOUBLE PRECISION FUNCTION X_G01FAF (TAIL, P, IFAIL)
C
C ACTION : % points of the normal distribution
C AUTHOR : W.G.Bardsley, University of Manchester, 3/3/97
C          AS 111 J.D.Beasley and S.G.Springer App Stat 26 118-120, 1977
C ADVICE : This version does not check IFAIL on entry so it
C          is equivalent to soft fail, IFAIL = 1
C          It agrees with the NAG routine to 6 or 7 decimal places but
C          the NAG routine is more accurate in the further figures.
C
      IMPLICIT  NONE
      INTEGER   IFAIL
      DOUBLE PRECISION P
      CHARACTER TAIL*(*)
C
C Local variables
C
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION SPLIT
      PARAMETER (SPLIT = 0.42D+00)
      DOUBLE PRECISION A0, A1, A2, A3, B1, B2, B3, B4, C0, C1, C2,
     +                 C3, D1, D2
      PARAMETER (A0 =   2.50662823884D+00,
     +           A1 = -18.61500062529D+00,
     +           A2 =  41.39119773534D+00,
     +           A3 = -25.44106049637D+00,
     +           B1 =  -8.47351093090D+00,
     +           B2 =  23.08336743743D+00,
     +           B3 = -21.06224101826D+00,
     +           B4 =   3.13082909833D+00,
     +           C0 =  -2.78718931138D+00,
     +           C1 =  -2.29796479134D+00,
     +           C2 =   4.85014127135D+00,
     +           C3 =   2.32121276858D+00,
     +           D1 =   3.54388924762D+00,
     +           D2 =   1.63706781897D+00)
      DOUBLE PRECISION PMAX, PMIN
      PARAMETER (PMIN = 1.0D-300, PMAX = 0.9999999999999999D+00)
      DOUBLE PRECISION BOT, PNEW, PPND, Q, R, TOP
      CHARACTER C*1
      INTRINSIC ABS, SQRT, LOG
C
C Is it safe ?
C
      X_G01FAF = ZERO
      IF (P.LT.ZERO .OR. P.GT.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PNEW = P
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PNEW = ONE - P
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PNEW = P + HALF*(ONE - P)
      ELSEIF (C.EQ.'S' .or. c.eq.'S') THEN
         PNEW = ONE - HALF*P
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Limit the range
C
      IFAIL = 0
      IF (PNEW.LT.PMIN) THEN
         PNEW = PMIN
      ELSEIF (PNEW.GT.PMAX) THEN
         PNEW = PMAX
      ENDIF
      Q = PNEW - HALF
      IF (ABS(Q).LE.SPLIT) THEN
         R = Q*Q
         TOP = Q*(((A3*R + A2)*R + A1)*R + A0)
         BOT = (((B4*R + B3)*R + B2)*R + B1)*R + ONE
         PPND = TOP/BOT
      ELSE
         IF (Q.GT.ZERO) THEN
            R = ONE - PNEW
         ELSE
            R = PNEW
         ENDIF
         IF (R.GT.ZERO) THEN
            R = SQRT(-LOG(R))
            TOP = ((C3*R + C2)*R + C1)*R + C0
            BOT = (D2*R + D1)*R + ONE
            PPND = TOP/BOT
            IF (Q.LT.ZERO) PPND = -PPND
         ELSE
            PPND = ZERO
         ENDIF
      ENDIF
      X_G01FAF = PPND
      IFAIL = 0
      END
C
C
      DOUBLE PRECISION FUNCTION X_G01FBF (TAIL, P, DF, IFAIL)
C
C ACTION : Inverse of the t distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/3/97
C
C          ACM 396 Hill, G.W. Comm ACM vol 13 no. 10 p 619-620, 1970
C
C          Note that The entry value of IFAIL is not tested so it is
C          equivalent to soft fail with IFAIL = 1
C
C          Special cases are n=1, n=2, n<3, p=1/2 (lower/upper tails)
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION P, DF
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, THREE, FOUR, FIVE, SIX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, FOUR = 4.0D+00,
     +           FIVE = 5.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION EPSI, PMAX, PMIN, TOL
      PARAMETER (EPSI = 1.0D-32, TOL = 1.0D-06, PMIN = 1.0D-16,
     +           PMAX = ONE - PMIN)
      DOUBLE PRECISION PNEW, PVAL, R, S, TOLVAL, TVAL
      DOUBLE PRECISION PIBY2
      PARAMETER (PIBY2 = 1.5707963268D+00)
      DOUBLE PRECISION A, B, D, E, X, Y
      DOUBLE PRECISION ROOT, TEMP
      DOUBLE PRECISION X_G01FAF, X_G01FEF
      CHARACTER  C*1
      EXTERNAL   X_G01FAF, X_G01FEF
      INTRINSIC  ABS, SQRT, COS, SIN, EXP
C
C Initialise and check
C
      IFAIL = 0
      X_G01FBF = ZERO
      IF (DF.LT.ONE) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (P.LE.ZERO .OR. P.GE.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (P.LE.PMIN) THEN
         PNEW = PMIN
      ELSEIF (P.GE.PMAX) THEN
         PNEW = PMAX
      ELSE
         PNEW = P
      ENDIF
      C = TAIL(1:1)
      IF (C.EQ.'L' .OR. C.EQ.'l') THEN
         PVAL = TWO*(ONE - PNEW)
         C = 'L'
      ELSEIF (C.EQ.'U' .OR. C.EQ.'u') THEN
         PVAL = TWO*PNEW
         C = 'U'
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         PVAL = PNEW
         C = 'S'
      ELSEIF (C.EQ.'C' .OR. C.EQ.'c') THEN
         PVAL = ONE - PNEW
         C = 'C'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (C.EQ.'L' .AND. ABS(PNEW - HALF).LE.EPSI .OR.
     +    C.EQ.'U' .AND. ABS(PNEW - HALF).LE.EPSI) THEN
C
C The special case C = 'L', C = 'U' and P = 1/2
C
         TVAL = ZERO
      ELSEIF (ABS(DF - ONE).LE.EPSI) THEN
C
C The special case n = 1
C
         A = PVAL*PIBY2
         TVAL =  COS(A)/SIN(A)
      ELSEIF (ABS(DF - TWO).LE.EPSI) THEN
C
C The special case n = 2
C
         A = TWO/(PVAL*(TWO - PVAL)) - TWO
         TVAL = SQRT(A)
      ELSEIF (DF.LT.THREE) THEN
C
C Use a Beta distribution for n < 3
C
         R = HALF*DF
         S = HALF
         TOLVAL = TOL
         I = 1
         IF (C.EQ.'L') THEN
            IF (PNEW.LT.HALF) THEN
               PVAL = TWO*PNEW
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - PNEW)
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'U') THEN
            TEMP = ONE - PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'S') THEN
            TEMP = ONE - HALF*PNEW
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ELSEIF (C.EQ.'C') THEN
            TEMP = HALF*(ONE - PNEW)
            IF (TEMP.LT.HALF) THEN
               PVAL = TWO*TEMP
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = - SQRT(DF/ROOT - DF)
            ELSE
               PVAL = TWO*(ONE - TEMP)
               ROOT = X_G01FEF(PVAL, R, S, TOLVAL, I)
               TVAL = SQRT(DF/ROOT - DF)
            ENDIF
         ENDIF
      ELSE
C
C Use a Cornish-Fisher expansion for n > 3
C
         A = ONE/(DF - HALF)
         B = 48.0D+00/A**2
         E = ((20700.0D+00*A/B - 98.0D+00)*A - FOUR**2)*A + 96.36D+00
         D = ((94.5D+00/(B + E) - THREE)/B + ONE)*SQRT(A*PIBY2)*DF
         X = D*PVAL
         Y = X**(TWO/DF)
         IF (Y .GT. 0.05D+00 + A) THEN
            I = 1
            TEMP = HALF*PVAL
            X = X_G01FAF('L', TEMP, I)
            Y = X**2
            IF (DF .LT. FIVE) E = E +
     +                        0.3D+00*(DF - 4.5D+00)*(X + 0.6D+00)
            E = (((0.05D+00*D*X - FIVE)*X - 7.0D+00)*X - TWO)*X + B + E
            Y = (((((0.4D+00*Y + 6.3D+00)*Y + 36.0D+00)*Y + 94.5D+00)/E
     +            - Y - THREE)/B + ONE)*X
            Y = A*Y**2
            IF (Y .GT. 0.002D+00) THEN
               Y = EXP(Y) - ONE
            ELSE
               Y = HALF*Y**2 + Y
            ENDIF
         ELSE
            Y = ((ONE/(((DF + SIX)/(DF*Y) - 0.089D+00*D - 0.822D+00)*
     +          (DF + TWO)*THREE) + HALF/(DF + FOUR))*Y - ONE)*
     +          (DF + ONE)/(DF + TWO) + ONE/Y
         ENDIF
         TVAL = SQRT(DF*Y)
      ENDIF
      IF (C.EQ.'L') THEN
         IF (P.GT.HALF) THEN
            X_G01FBF = ABS(TVAL)
         ELSE
            X_G01FBF = - ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'U') THEN
         IF (P.GT.HALF) THEN
            X_G01FBF = - ABS(TVAL)
         ELSE
            X_G01FBF = ABS(TVAL)
         ENDIF
      ELSEIF (C.EQ.'C') THEN
         X_G01FBF = ABS(TVAL)
      ELSE
         X_G01FBF = ABS(TVAL)
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION X_G01FEF (PVAL, AVAL, BVAL, TOLVAL,
     +                                    IFAIL)
C
C ACTION : inverse beta distribution
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C
C          Developed from:-
C          AS 64 Majumder and Bhattacharjee, 411-414, 1973
C
C          This sometimes fails to converge so I implemented
C          AS 109 Correction to the previous by Cran, Martin and Thomas
C          to prevent Newton Raphson diverging. BETA is now log(beta)
C          and ACU = TOLVAL**2 (Appl Statist 26,111-114)
C
C          Subsequently I came across R83 by Berry, Mielke, Grant
C          p 309-310 (1990 ?) replacing ACU and introducing IEX and
C          FPU so TOLVAL is not now used.
C
C          This version accepts the starting estimate if the root has
C          not been located by Newton Raphson. Also it is protected
C          from overflow, e.g. with 0.001, 2345, 5678
C
C          Note: there is no test for IFAIL on entry so it is
C                equivalent to soft fail, i.e. IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION AVAL, BVAL, PVAL, TOLVAL
C
C Local variables
C
      INTEGER    I, ICOUNT, IEX, JCOUNT, NMAX
      PARAMETER (NMAX = 40)
      DOUBLE PRECISION ZERO, EPSI, HALF, ONE, TWO, THREE, FOUR, FIVE,
     +                 SIX, NINE, TEN
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-16, HALF = 0.5D+00,
     +           ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           FOUR = 4.0D+00, FIVE = 5.0D+00,
     +           SIX = 6.0D+00, NINE = 9.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION ABLIM, AMAX, AMIN, XMAX, XMIN
      PARAMETER (ABLIM = 1.0D+06, AMIN = 1.0D-16, AMAX = ONE - AMIN,
     +           XMIN = 1.0D-300, XMAX = ONE - AMIN)
      DOUBLE PRECISION EXPBOT, EXPTOP, XTINY
      PARAMETER (EXPTOP = 100.0D+00, EXPBOT = - EXPTOP, XTINY = XMIN)
      DOUBLE PRECISION SAE, FPU
      PARAMETER (SAE = - 300.0D+00)
      DOUBLE PRECISION ACU, BETA, P, PP, Q, QQ, TEMP, X1, X2, X3
      DOUBLE PRECISION A, ALPHA, R, T, TOL, XINBTA, XTEMP, Y
      DOUBLE PRECISION ADJ, G, H, PREV, YPREV, S, SQ, TX, W
      DOUBLE PRECISION F1, F2, XSAV
      DOUBLE PRECISION X_S14ABF
      LOGICAL    INDEX1
      EXTERNAL   X_G01EEF, X_S14ABF
      INTRINSIC  ABS, EXP, LOG, SQRT, MAX
C
C Initialise
C
      IFAIL = 0
      X_G01FEF = ZERO
C
C Is it safe ?
C
      IF (PVAL.LT.ZERO .OR. PVAL.GT.ONE) THEN
         IFAIL = 1
         RETURN
      ELSE
         ALPHA = PVAL
         IF (ALPHA.LE.AMIN) THEN
            ALPHA = AMIN
         ELSEIF (ALPHA.GE.AMAX) THEN
            ALPHA = AMAX
         ENDIF
      ENDIF
      IF (AVAL.LE.ZERO .OR. AVAL.GT.ABLIM .OR.
     +    BVAL.LE.ZERO .OR. BVAL.GT.ABLIM) THEN
         IFAIL = 2
         RETURN
      ELSE
         P = AVAL
         Q = BVAL
      ENDIF
C
C In this version the next definition of ACU is overwritten by IEX
C
      ACU = TOLVAL*TOLVAL
      IF (ACU.LT.EPSI) ACU = EPSI
C
C Calculate the normalising factor BETA, i.e. log(beta)
C
       I = 1
       X1 = X_S14ABF(P, I)
       I = 1
       X2 = X_S14ABF(Q, I)
       I = 1
       TEMP = P + Q
       X3 = X_S14ABF(TEMP, I)
       BETA = X1 + X2 - X3
C
C Swap tails if recommended
C
       IF (ALPHA.GT.HALF) THEN
          INDEX1 = .TRUE.
          A = ONE - ALPHA
          PP = Q
          QQ = P
       ELSE
          INDEX1 = .FALSE.
          A = ALPHA
          PP = P
          QQ = Q
       ENDIF
C
C Set up the initial approximation
C
      TEMP =  A*A
      IF (TEMP.LE.XTINY) TEMP = XTINY
C
C Calculate Hasting's approximation to y-alpha
C
      R = SQRT( - LOG(TEMP))
      Y = R - (2.30753D+00 + 0.27061D+00*R)/
     +   (ONE + (0.99229D+00 + 0.04481D+00*R)*R)
      IF (PP.GT.ONE .AND. QQ.GT.ONE) THEN
C
C The new case treated by Cran, Martin and Thomas
C
         R = (Y*Y - THREE)/SIX
         S = ONE/(TWO*PP - ONE)
         T = ONE/(TWO*QQ - ONE)
         H = TWO/(S + T)
         W = Y*SQRT(H + R)/H - (T - S)*(R + FIVE/SIX - TWO/(THREE*H))
         XINBTA = PP/(PP + QQ*EXP(TWO*W))
      ELSE
C
C Calculate Wilson and Hilferty's approximation to chi-square
C
         R = TWO*QQ
         T = ONE/(NINE*QQ)
         T = R*(ONE - T + Y*SQRT(T))**3
         IF (T.LE.ZERO) THEN
C
C Deal with negative chi-square
C
            TEMP = (ONE - A)*QQ
            IF (TEMP.LE.XTINY) TEMP = XTINY
            TEMP = (LOG(TEMP) + BETA)/QQ
            IF (TEMP.LE.EXPBOT) THEN
               TEMP = EXPBOT
            ELSEIF (TEMP.GE.EXPTOP) THEN
                TEMP = EXPTOP
            ENDIF
            XINBTA = ONE - EXP(TEMP)
         ELSE
C
C Calculate the RHS of Sheffe and Tukey's equation
C
            T = (FOUR*PP + R - TWO)/T
            IF (T.GT.ONE) THEN
C
C Solve the equation for RHS > 1
C
               XINBTA = ONE - TWO/(T + ONE)
            ELSE
C
C The alternative solution
C
               TEMP = A*PP
               IF (TEMP.LE.XTINY) TEMP = XTINY
               TEMP = (LOG(TEMP) + BETA)/PP
               IF (TEMP.LE.EXPBOT) THEN
                  TEMP = EXPBOT
               ELSEIF (TEMP.GE.EXPTOP) THEN
                  TEMP = EXPTOP
               ENDIF
               XINBTA = EXP(TEMP)
            ENDIF
         ENDIF
      ENDIF
C
C Reflect back extreme values then save the estimate
C
      IF (XINBTA.LE.0.0001D+00) THEN
         XINBTA = 0.0001D+00
      ELSEIF (XINBTA.GE.0.9999D+00) THEN
         XINBTA = 0.9999D+00
      ENDIF
      XSAV = XINBTA
C
C The starting estimate XINBTA has now been calculated
C
C......................................................................
C
C Prepare for Newton Raphson
C
      R = ONE - PP
      T = ONE - QQ
      YPREV = ZERO
      SQ = ONE
      PREV = ONE
      ICOUNT = 0
C
C The new code suggested by Berry, Mielke and Grant
C
      FPU = TEN**SAE
      IEX = MAX(-FIVE/PP**2 - ONE/A**0.2D+00 - 13.0D+00, SAE)
      ACU = TEN**IEX
C
C Main cycling point for the iteration
C
   20 CONTINUE
      ICOUNT = ICOUNT + 1
C
C Function evaluation: X1 = lower tail area
C
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL X_G01EEF (XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      IF (I.EQ.0) THEN
         Y = X1
         TEMP = BETA + R*LOG(XINBTA) + T*LOG(ONE - XINBTA)
         IF (TEMP.LE.EXPBOT) THEN
            TEMP = EXPBOT
         ELSEIF (TEMP.GE.EXPTOP) THEN
            TEMP = EXPTOP
         ENDIF
         Y = (Y - A)*EXP(TEMP)
         IF (Y*YPREV.LE.ZERO) PREV = MAX(SQ, FPU)
         G = ONE
C
C Adjust if required
C
         JCOUNT = 0
   40    CONTINUE
         JCOUNT = JCOUNT + 1
         ADJ = G*Y
         SQ = ADJ*ADJ
         IF (SQ.GE.PREV) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         TX = XINBTA - ADJ
         IF (TX.LT.ZERO .OR. TX.GT.ONE) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
C
C Check to see if it has converged or used up iterations
C
         IF (ICOUNT.EQ.NMAX .OR. PREV.LE.ACU .OR. Y*Y.LE.ACU .OR.
     +       ABS(TX - XINBTA).LE.EPSI) GOTO 60
         IF (TX.LE.XMIN .OR. TX.GE.XMAX) THEN
            IF (JCOUNT.LE.NMAX) THEN
               G = G/THREE
               GOTO 40
            ENDIF
         ENDIF
         XINBTA = TX
C
C Reflect back extreme values
C
         IF (XINBTA.LE.AMIN) THEN
            XINBTA = AMIN
         ELSEIF (XINBTA.GE.AMAX) THEN
            XINBTA = AMAX
         ENDIF
         YPREV = Y
         GOTO 20
      ENDIF
C
C Final calculation
C
   60 CONTINUE
C
C First check if the iteration has improved the solution
C
      I = 1
      TOL = TOLVAL
      XTEMP = XSAV
      CALL X_G01EEF (XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F1 = X1 - A
      I = 1
      TOL = TOLVAL
      XTEMP = XINBTA
      CALL X_G01EEF (XTEMP, PP, QQ, TOL, X1, X2, X3, I)
      F2 = X1 - A
C
C If not swap XSAV for XINBTA
C
      IF (ABS(F1).LT.ABS(F2)) XINBTA = XSAV
C
C Reverse tails if necessary
C
      IF (INDEX1) XINBTA = ONE - XINBTA
      X_G01FEF = XINBTA
      IF (X_G01FEF.LT.ZERO) THEN
         X_G01FEF = ZERO
      ELSEIF (X_G01FEF.GT.ONE) THEN
         X_G01FEF = ONE
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION X_S14ABF(XX, IFAIL)
C
C ACTION : log gamma function
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          Equivalent to IFAIL = 1 soft fail, no error trapping
C          Returns IFAIL = 2 for large values but just keeps on
C          Set to 0 to trap the poles occurring at 1 and 2
C
      IMPLICIT NONE
      INTEGER   IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      INTEGER   I, IPART
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION XLIM1, XLIM2, XLIM3, XLIM4
      PARAMETER (XLIM1 = 1.0D-10, XLIM2 = 15.0D+00, XLIM3 = 1.2D+03,
     +           XLIM4 = 1.0D300)
      DOUBLE PRECISION EPSI, FACTOR, TOP, Z1LO, Z1HI, Z2LO, Z2HI
      PARAMETER (EPSI = 1.0D-10, FACTOR = 0.918938533D+00,
     +           TOP = 450.0D+00,
     +           Z1LO = ONE - EPSI, Z1HI = ONE + EPSI,
     +           Z2LO = TWO - EPSI, Z2HI = TWO + EPSI)
      DOUBLE PRECISION A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10,
     +                 A11, A12
      PARAMETER (A12 =  1.88278283D-6,
     +           A11 = -5.48272091D-6,
     +           A10 =  1.03144033D-5,
     +            A9 = -3.13088821D-5,
     +            A8 =  1.01593694D-4,
     +            A7 = -2.98340924D-4,
     +            A6 =  9.15547391D-4,
     +            A5 = -2.42216251D-3,
     +            A4 =  9.04037536D-3,
     +            A3 = -1.34119055D-2,
     +            A2 =  1.03703361D-1,
     +            A1 =  1.61692007D-2,
     +            A0 =  8.86226925D-1)
      DOUBLE PRECISION B0, B1, B2
      PARAMETER (B0 =  8.33271644D-2,
     +           B1 = -6.16502533D-6,
     +           B2 =  3.89980902D-9)
      DOUBLE PRECISION RPART, T, Y
      INTRINSIC DBLE, INT, LOG
C
C Copy X into XX so X is returned unchanged and set IFAIL = 0
C
      X = XX
      X_S14ABF = ZERO
      IFAIL = 0
      IF (X.LE.ZERO) THEN
C
C Failure if X < 0
C
         IFAIL = 1
      ELSEIF (X.GT.Z1LO .AND. X.LT.Z1HI .OR.
     +        X.GT.Z2LO .AND. X.LT.Z2HI) THEN
C
C Trap the poles at X = 1 and X = 2
C
         IFAIL = 0!to silence ftn95
      ELSEIF (X.LE.XLIM1) THEN
C
C For very small values use -log(x)
C
         X_S14ABF = -LOG(X)
      ELSEIF (X.LE.XLIM2) THEN
C
C Medium sized values
C
         IPART = INT(X)
         T = TWO*(X - DBLE(IPART)) - ONE
         IPART = IPART - 1
         RPART = ONE
         IF (IPART.LT.0) THEN
            RPART = RPART/X
         ELSEIF (IPART.GT.0) THEN
            DO I = 1, IPART
               RPART = (X - DBLE(I))*RPART
            ENDDO
         ENDIF
         Y = (((((((((((A12*T + A11)*T + A10)*T + A9)*T + A8)*T
     +                        +  A7)*T +  A6)*T + A5)*T + A4)*T
     +                        +  A3)*T +  A2)*T + A1)*T + A0
         X_S14ABF = LOG(RPART*Y)
      ELSEIF (X.LE.XLIM3) THEN
C
C Large values
C
         T = TOP/(X*X) - ONE
         Y = (B2*T + B1)*T + B0
         X_S14ABF = (X - HALF)*LOG(X) - X + FACTOR + Y/X
      ELSE
C
C Very large values
C
         IF (X.GT.XLIM4) THEN
            IFAIL = 2
            X = XLIM4
         ENDIF
         X_S14ABF = (X - HALF)*LOG(X) - X + FACTOR
      ENDIF
      END
C
C
      DOUBLE PRECISION FUNCTION X_X02AJF()
      X_X02AJF = 1.111307226798D-016
      END
C
C
      DOUBLE PRECISION FUNCTION X_X02AMF()
      X_X02AMF = 2.574667400493D-308
      END
C
C