C
C
      SUBROUTINE X_NEWSTR (ISEND,
     +                     STRNG, SYMBOL)
C
C ACTION : Read in a new string or edit an existing one
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 23/9/96
C          08/10/1996 Added call to FHERSH
C          12/12/1996 Trimmed SYMBOL to length of STRING
C          17/11/2000 added call to xfonts$
C          17/11/2003 added call to ISOLAT$
C          17/12/2003 redimensioned ARRAY and TEMP
C          20/03/2007 added INTENTS
C          27/05/2001 improved menu and program organisation 
C          14/09/2011 developed from NEWSTR$
C
C ADVICE : ISEND is unchanged
C          ISEND = 1, new string
C          ISEND = 2, edit
C          ISEND = Any other value, ask
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ISEND 
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG, SYMBOL
C
C Locals
C      
      INTEGER    I, L1, L2, X_LEN200
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      PARAMETER (NUMOPT = 5, NUMSTA = 9, NUMTXT = NUMSTA + NUMOPT - 1)
      INTEGER    NUMBLD(30)
      CHARACTER  ARRAY*100, OPTS(30)*100, TEMP*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    REPEET
      EXTERNAL   X_LSTBOX, X_LEN200
      EXTERNAL   X_GETSTR, X_STREDI, X_PSCODE, X_XFONTS, X_ISOLAT
      DATA       NUMBLD / 30*0 /
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: Input new text then restore SYMBOL and return
C
         CALL X_GETSTR ('New text or edit the current text',
     +                  STRNG)
         SYMBOL = BLANK
         L1 = 1
         L2 = X_LEN200(STRNG)
         DO I = L1, L2
            SYMBOL(I:I) = '0'
         ENDDO
         CALL X_ISOLAT (SYMBOL, STRNG)
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: Edit then return
C
         L1 = 1
         L2 = X_LEN200(STRNG)
         ARRAY = '('//SYMBOL(L1:L2)//')fx'
         TEMP = '('//STRNG(L1:L2)//')'
         CALL X_STREDI (ARRAY, TEMP)
         L1 = 2
         L2 = X_LEN200(TEMP) - 1
         STRNG = TEMP(L1:L2)
         L2 = X_LEN200(ARRAY) - 3
         SYMBOL = ARRAY(L1:L2)
      ELSE 
C
C ISEND < 1 OR ISEND > 2: Loop over options
C         
         REPEET = .TRUE.
         DO WHILE (REPEET)
            L1 = 1
            L2 = X_LEN200(STRNG)
            WRITE (OPTS,100) STRNG, SYMBOL(L1:L2)
            NUMDEC = NUMOPT
            NUMBLD(1) = 4
            NUMBLD(4) = 1
            NUMBLD(7) = 1
            CALL X_LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                     OPTS) 
            NUMBLD(1) = 0
            NUMBLD(4) = 0         
            NUMBLD(7) = 0         
            IF (NUMDEC.EQ.1) THEN
C
C Input new text then restore SYMBOL
C
               CALL X_GETSTR ('New text or edit the current text',
     +                        STRNG)
               SYMBOL = BLANK
               L1 = 1
               L2 = X_LEN200(STRNG)
               DO I = L1, L2
                  SYMBOL(I:I) = '0'
               ENDDO
               CALL X_ISOLAT (SYMBOL, STRNG)
            ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit
C
               L1 = 1
               L2 = X_LEN200(STRNG)
               ARRAY = '('//SYMBOL(L1:L2)//')fx'
               TEMP = '('//STRNG(L1:L2)//')'
               CALL X_STREDI (ARRAY, TEMP)
               L1 = 2
               L2 = X_LEN200(TEMP) - 1
               STRNG = TEMP(L1:L2)
               L2 = X_LEN200(ARRAY) - 3
               SYMBOL = ARRAY(L1:L2)
            ELSEIF (NUMDEC.EQ.3) THEN
               CALL X_XFONTS
            ELSEIF (NUMDEC.EQ.4) THEN
               CALL X_PSCODE
            ELSE
               REPEET = .FALSE.   
            ENDIF
         ENDDO
      ENDIF

C
C Format statement
C      
  100 FORMAT (
     + 'Editing text strings and associated character keys'
     +/
     +/'The current text string is:'
     +/A
     +/
     +/'The current character key is:'
     +/A
     +/
     +/'Edit: Simple mode... Text only'
     +/'Edit: Advanced mode ... Text and Key'
     +/'Examples and Help'
     +/'Tables of codes and keys'
     +/'Accept')
      END
C       
C