c
c
      subroutine x_nsteps (isend, l_step_1, m_step_1, nfiles)
      use        module_clearwin, only : l_step, m_step
c
c action: define the line and/or symbol indices to step over  
c author: w.g.bardsley, university of manchester, u.k., 01/02/2011
c         20/01/2013 completely re-written to use module_clearwin
c         
c Note that edited values < 0 are re-set to 0
c Also the configuration file is only used when isend = 2
c
c  isend: isend = 1 ... retrieve current values
c         isend = 2 ... interactive control then return new values
c         isend = 3 ... install new defaults using values supplied
c         isend = 4 ... restore original defaults (all = 0)
c l_step: nstep values for lines
c m_step: nstep values for symbols
c nfiles: number of current files for plotting
c
      implicit none
c
c argument
c 
      integer, intent (in)    :: isend, nfiles
      integer, intent (inout) :: l_step_1(nfiles), m_step_1(nfiles)
c
c allocatable
c
c
c locals
c
      integer    i, icount, numdec 
      integer    ksend, nrmax, nsav, numcol, numopt, numtxt 
      parameter (ksend = 2, nrmax = 300, nsav = 300, numcol = 1,
     +           numopt = 8, numtxt = 24)
      integer    l_temp(nsav), m_temp(nsav)
      integer    icolor, ios, nout
      integer    ivalue, jvalue
      integer    numbld(30)
      double precision a(nrmax,numcol)
      character  title*80, text(30)*100
      character (len = 14) word14
      character (len = 1024) fname, x_sim256
      logical    repeet, there
      external   x_patch2, x_editi1, x_listbx, x_getnou, x_sim256, 
     +           x_putadv
      external   w_table1
      intrinsic  dble, nint, max
      data       numbld / 30*0 /
c
c check values supplied
c      
      if (isend.lt.1 .or. isend.gt.4 .or. nfiles .lt.1) return
      if (isend.eq.1) then
c
c isend = 1: retrieve the current values
c =========
c        
         do i = 1, nfiles
            l_step_1(i) = max(l_step(i),0)
            m_step_1(i) = max(m_step(i),0)
         enddo   
      elseif (isend.eq.2) then  
c
c -------------------------------------------------------------------------------------
c isend = 2: retrieve current values, interactive calculations, then return new values
c =========
c      
         icount = 0
         fname = x_sim256('w_nsteps.cfg')  
         inquire (file = fname, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            call x_getnou (nout)
            open (nout, file = fname, iostat = ios)
            do while (ios.eq.0 .and. icount.lt.nsav)
               read (nout,*,iostat=ios) ivalue, jvalue
               if (ios.eq.0) then
                  icount = icount + 1
                  l_temp(icount) = max(ivalue,0)
                  m_temp(icount) = max(jvalue,0)
               endif   
            enddo
            close (unit = nout)
         endif
         
         if (icount.lt.nsav) then
            do i = icount + 1, nsav      
               l_temp(i) = 0
               m_temp(i) = 0
            enddo
         endif      

         repeet = .true.
         numdec = numopt - 1
         do while (repeet)
            write (text,100)
            call x_listbx (numdec, numopt,
     +                     text)
            if (numdec.eq.1) then
c
c numdec = 1: retrieve the current values for lines
c           
               do i = 1, nfiles
                  a(i,1) = dble(l_step(i))
               enddo  
c
c edit then over-write
c            
               title = 'Specify line stepping parameters' 
               call x_editi1 (ksend, numcol, nrmax, nfiles,
     +                        a,            
     +                        title)   
               do i = 1, nfiles
                  l_step(i) = max(nint(a(i,1)),0)
               enddo             
            elseif (numdec.eq.2) then
c
c numdec = 2: retrieve the current values for symbols
c           
               do i = 1, nfiles
                  a(i,1) = dble(m_step(i))
               enddo  
c
c edit then over-write
c            
               title = 'Specify symbol stepping parameters' 
               call x_editi1 (ksend, numcol, nrmax, nfiles, 
     +                        a,            
     +                        title)  
               do i = 1, nfiles
                  m_step(i) = max(nint(a(i,1)),0)
               enddo   
            elseif (numdec.eq.3) then
c
c numdec = 3: view current parameters
c            
                icolor = 15
                call w_table1 (icolor, 'OPEN')
                icolor = 4
                call w_table1 (icolor, 'Lines  Symbols (Current)')
                icolor = 0
                do i = 1, nfiles
                    write (word14,'(i5,i9)') l_step(i), m_step(i)
                    call w_table1 (icolor, word14)
                enddo   
                call w_table1 (icolor, 'CLOSE')
             elseif (numdec.eq.4) then
c
c numdec = 4: view stored parameters
c            
                icolor = 15
                call w_table1 (icolor, 'OPEN')
                icolor = 4
                call w_table1 (icolor, 'Lines  Symbols (Stored)')
                icolor = 0
                do i = 1, nfiles
                    write (word14,'(i5,i9)') l_temp(i), m_temp(i)
                    call w_table1 (icolor, word14)
                enddo   
                call w_table1 (icolor, 'CLOSE')    
             elseif (numdec.eq.5) then
c
c numdec = 5: overwrite stored parameters
c            
                do i = 1, nfiles
                    l_temp(i) = max(l_step(i),0)
                    m_temp(i) = max(m_step(i),0)
                enddo   
                call x_putadv (
     +'Current parameters have overwritten the stored parameters')
             elseif (numdec.eq.6) then
c
c numdec = 6: Install stored parameters
c            
                do i = 1, nfiles
                    l_step(i) = max(l_temp(i),0)
                    m_step(i) = max(m_temp(i),0)
                enddo
                call x_putadv (
     +'Stored parameters have overwritten the current parameters')                
            elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c
               repeet = .true.
               write (text, 200)
               numbld(1) = 1
               numbld(11) = 1
               numbld (22) = 1  
               call x_patch2 (numbld, numtxt,
     +                        text)  
               numbld(1) = 0
               numbld(11) = 0
               numbld (22) = 0           
            else
c
c numdec = numopt: exit
c           
               repeet = .false.
               call x_getnou (nout)
               open (nout, file = fname, iostat = ios)
               icount = 0
               do while (ios.eq.0 .and. icount.lt.nsav)
                  icount = icount + 1
                  write (nout,'(2i6)',iostat=ios) l_temp(icount),
     +                                            m_temp(icount)
               enddo  
               if (ios.eq.0 .and. icount.eq.nsav) 
     +         write (nout,'(a)',iostat = ios) 
     +'Stepping parameters for lines (column 1) and symbols (Column 2)'                  
               close (unit = nout)
               do i = 1, nfiles
                  l_step_1(i) = max(l_step(i),0)
                  m_step_1(i) = max(m_step(i),0)
               enddo     
            endif  
           
         enddo
c -------------------------------------------------------------------------------------
      elseif (isend.eq.3) then
c
c isend = 3: store values supplied
c =========
c      
         do i = 1, nfiles
            l_step(i) = max(l_step_1(i),0)
            m_step(i) = max(m_step_1(i),0)
         enddo   
      else
c
c isend = 4: restore defaults for all values = 0
c =========
c        
         do i = 1, nfiles
            l_step(i) = 0
            m_step(i) = 0
            l_step_1(i) = 0
            m_step_1(i) = 0
         enddo   
      endif        
c
c format statements
c      
  100 format (
     + 'Edit steps for current lines'
     +/'Edit steps for current symbols'
     +/'View current stepping parameters'
     +/'Configuration file: View'
     +/'Configuration file: Over-write'
     +/'Configuration file: Copy from' 
     +/'Help'
     +/'Quit ... Exit editing steps')        
  200 format (
     + 'Stepping over intermediate points'
     +/              
     +/'Sometimes a large data set has been created and it is only'
     +/'necessary to plot a sub-set of the points available.'
     +/'A typical example would be where a scientific intrument has'
     +/'generated a large number of points and plotting all the data'
     +/'would create an over-complicated plot. Another example would'
     +/'be where a large matrix is available but it is only necessary'    
     +/'to plot a sub-set of the rows or columns.'
     +/
     +/'Mode of operation'
     +/
     +/'The plotting routines are intialised with all the step-over'
     +/'parameters set to 0, i.e. NSTEP = 0 to plot all the points.'
     +/'However, from this control it is possible to define values'
     +/'for NSTEP that would cause NSTEP values to be omitted between'
     +/'consecutive points being plotted. For instance, if NSTEP = 2'
     +/'then only points 1, 4, 7, 10, ... would be plotted. This can'
     +/'be done in such a way that a different value can be set for'
     +/'lines and symbols within the same data set.'
     +/  
     +/'The stepping parameter configuration file (w_nsteps.cfg)'  
     +/
     +/'This can be used to store or retrieve stepping configurations.')  
       end
c
c       