c
c
      subroutine x_nudata (nfiles, ntype,
     +                     fsav, fsav1)
c
c action: input data then return new graphics file for simplot
c author: w.g.bardsley, university of manchester, u.k., 02/12/2002 
c         20/04/2007 added intents 
c         11/05/2007 initialised nrows = 0 and increased nrmax from 20 to 100
c         19/09/2011 derived from nudata$
c
c         nfiles = current number of files ... in the calling program
c         ntype = ntype(nfiles + 1)        ... in the calling program
c         fsav = fsav(nfiles + 1)          ... in the calling program
c         fsav1 = fsav1(nfiles + 1)        ... in the calling program
c         if successful then nfiles is incremented and ntype, fsav,
c         and fsav1 are assigned to return the new graphics file
c         if unsuccessful then nfiles, ntype, fsav and fsav1 are unchanged
c
c
      implicit   none 
c
c arguments
c      
      integer,             intent (inout) :: nfiles, ntype 
      character (len = *), intent (inout) :: fsav, fsav1
c
c locals
c      
      integer    i, ierr, ios, nout, nrows
      integer    isend, itype, mode2, ncols, nrmax
      parameter (isend = 3, itype = 1, mode2 = 2, ncols = 2,
     +           nrmax = 100)
      double precision delta, x(nrmax,ncols)
      double precision zero, epsi
      parameter (zero = 0.0d+00, epsi = 1.0d-100)
      character  title*100
      logical    abort, curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .false.,
     +           label = .true., order = .false., weight = .false.)
      external   x_getnou, x_copyfl, w_gettmp, w_editor, x_getjm1
c
c attempt to create data
c
      i = 0 
      nrows = 0
      write (title,100)
      call x_getjm1 (i, nrows, nrmax,
     +               title)
      if (nrows.eq.0) return
      write (title,200)
      call w_editor (isend, itype, ncols, nrmax, nrows,
     +               x,
     +               title,
     +               curve, fixcol, fixrow, label, order, weight)
c
c check that not all data values are the same
c
      delta = zero
      do i = 1, nrows - 1
         delta = delta + (x(i,1) - x(i + 1,1))**2
         delta = delta + (x(i,2) - x(i + 1,2))**2
      enddo
      do i = 1, nrows
         delta =  delta + (x(1,1) - x(1,2))**2
      enddo
      if (delta.le.epsi) return
c
c open a file
c
      call w_gettmp (ierr,
     +               fsav)
      if (ierr.eq.0) then
         call x_getnou (nout)
         open (unit = nout, file = fsav, iostat = ios)
         if (ios.eq.0) then
            write (nout,300,iostat=ios)
            if (ios.eq.0) write (nout,400,iostat=ios) nrows, ncols
            do i = 1, nrows
               if (ios.eq.0) write (nout,500,iostat=ios) x(i,1), x(i,2)
            enddo
            if (ios.eq.0) write (nout,600,iostat=ios)
         endif
         close (unit = nout)
         if (ios.eq.0) then
            call w_gettmp (ierr,
     +                     fsav1)
            if (ierr.eq.0) then
               call x_copyfl (mode2,
     +                        fsav, fsav1,
     +                        abort)
               if (.not.abort) then
                  nfiles = nfiles + 1
                  ntype = 1
               endif
            endif
         endif
      endif               
c
c format statements
c      
  100 format ('Number of points to be plotted (0 = no action)')
  200 format ('Input x,y coordinates for plotting')
  300 format ('Temporary data for plotting')
  400 format (2i6)
  500 format (1p,2e13.5)
  600 format (
     + ' 1'
     +/'Default line')
      end
c
c
