C
C
      SUBROUTINE X_NYYBAR(ISEND, N, 
     +                    X, Y, E)
C
C ACTION : Supply E(N), X(N), Y(N) and calculate no. of distinct points
C          and sample standard deviations at replicates
C          If there are replicates E can be replaced by sample sigmas S
C          or some multiples as the user decides
C          Otherwise the E values are unchanged and a warning is issued
C
C          ISEND = 1, Just replace E by sample standard deviations
C                     N, X, Y unchanged
C                     This option is for weighting a curve-fit type file
C          ISEND = 2, Compress and replace Y by mean and E by S.E. mean
C                     N set to no. of distinct values
C                     X replaced by the distinct values
C                     This option is for making a compressed curve-fit file
C          ISEND = 3, Compress and replace Y by YBAR and E by 95% c.lim.
C                     or some multiple of std.err. or std. dev.
C                     This option is for making an error bar file for plotting
C
C ADVICE : The X-values must be in increasing order
C NAG    : G01CAE -> G01FBF
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 9/11/90
C          23/03/1994 DBOS version
C          19/10/1995 replaced G01CAF by G01FBF for NAG mark 16
C          19/06/1996 reorganised and enlarged options for ISEND = 3
C                     to include plot and choice of error bar parameters
C          22/06/2006 introduced allocatable arrays
C          20/04/2007 added INTENTS and changed array dimensions from (N) to (*)
C          21/09/2011 derived from NYYBAR$ 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND
      INTEGER,          INTENT (INOUT) :: N
      DOUBLE PRECISION, INTENT (INOUT) :: E(*), X(*), Y(*)
C
C Local allocatable arrays
C                                                            
      DOUBLE PRECISION, ALLOCATABLE :: EGRAF(:), XGRAF(:), YGRAF(:),
     +                                 YH1(:), YL1(:)  
C
C Locals
C     
      INTEGER    I, ICOUNT, IERR, IFAIL, J, NDIST, NREPS
      INTEGER    COLOUR
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N15, N23
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N15 = 15, N23 = 23)
      INTEGER    NUMDEC, NUMOPT
      INTEGER    NUMBLD(30), NUMSTA, NUMTXT
      INTEGER    NMAX
      DOUBLE PRECISION XTEMP(N1), YTEMP(N1)
      DOUBLE PRECISION ONE, PNT1, PNT975, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, PNT1 = 0.1D+00, PNT975 = 0.975D+00,
     +           TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION EPSI, ERRMAX, ERRMIN
      DOUBLE PRECISION X_X02AMF
      DOUBLE PRECISION RNREPS, SIGMA, SSQ, TSTAT, YBAR, YSUM
      DOUBLE PRECISION X_G01FBF, X_X02AJF
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    DOSUMS, EXTRA
      EXTERNAL   X_TABLE1, X_GETD01, W_PLOTEB
      EXTERNAL   X_PUTFAT, X_LSTBOX
      EXTERNAL   X_G01FBF, X_X02AJF, X_X02AMF
      INTRINSIC  ABS, SQRT, DBLE, MAX
      DATA       XTEMP, YTEMP /N1*0.0D+00, N1*0.0D+00 /
      DATA       NUMBLD / 30*0 / 
C
C Check that the data is OK then define EPSI and ERRMIN
C
      IF (N.LT.N2) THEN
         CALL X_PUTFAT ('Sample too small for this option (n < 2)')
         RETURN
      ENDIF
      IF (ISEND.LT.N1 .OR. ISEND.GT.N3) THEN
         CALL X_PUTFAT ('ISEND not 1, 2 or 3 in call to X_NYYBAR')
         RETURN
      ENDIF
      DO I = N2, N
         IF (X(I).LT.X(I - N1)) THEN
            WRITE (LINE,100) I
            CALL X_PUTFAT (LINE)
            RETURN
         ENDIF
      ENDDO
      EPSI = X_X02AJF()*(X(N) - X(1))
      ERRMIN = SQRT(X_X02AMF())
      ERRMAX = 10.0D+00
C
C Make sure E > ERRMIN then initialise NREPS and YSUM(1)
C
      IF (ISEND.LT.N3) THEN
         DO I = N1, N
            IF (E(I).LT.ERRMIN) E(I) = ERRMIN
         ENDDO
         NREPS = N1
         YSUM = Y(N1)
      ENDIF                    
C
C Now the options determined by ISEND
C                               

      IF (ISEND.EQ.N1) THEN
C
C ISEND = 1: Replace E by sample standard deviations
C ==========
C
         COLOUR = N1
         CALL X_TABLE1 (COLOUR, 'OPEN')
         COLOUR = N23
         DO I = N2, N
            IF (ABS(X(I) - X(I - N1)).LE.EPSI) THEN
               DOSUMS = .FALSE.
               YSUM = YSUM + Y(I)
               NREPS = NREPS + N1
               IF (I.EQ.N) THEN
                  DOSUMS = .TRUE.
                  ICOUNT = N0
               ENDIF
            ELSE
               IF (NREPS.EQ.N1) THEN
                  DOSUMS = .FALSE.
                  YSUM = Y(I)
                  WRITE (LINE,200) I - N1
                  CALL X_TABLE1 (COLOUR, LINE)
               ELSE
                  DOSUMS = .TRUE.
                  ICOUNT = N1
               ENDIF
               IF (I.EQ.N) THEN
                  WRITE (LINE,200) N
                  CALL X_TABLE1 (COLOUR, LINE)
               ENDIF
            ENDIF
            IF (DOSUMS) THEN
               RNREPS = DBLE(NREPS)
               YBAR = YSUM/RNREPS
               SSQ = ZERO
               DO J = N1, NREPS
                  SSQ = SSQ + (Y(I - NREPS + J - ICOUNT) - YBAR)**2
               ENDDO
               SIGMA = SQRT(SSQ/(RNREPS - ONE))
               IF (SIGMA.LT.ERRMIN) THEN
                  WRITE (LINE,300) ERRMIN, I - NREPS + N1 - ICOUNT,
     +                             I - ICOUNT
                  CALL X_TABLE1 (COLOUR, LINE)
               ELSE
                  DO J = N1, NREPS
                     E(I - NREPS + J - ICOUNT) = SIGMA
                  ENDDO
               ENDIF
               YSUM = Y(I)
               NREPS = N1
            ENDIF
         ENDDO
         CALL X_TABLE1 (COLOUR, 'CLOSE')
      ELSEIF (ISEND.EQ.N2) THEN
C
C ISEND = 2: compress and replace Y by mean and E by stderr. mean
C ==========
C
         COLOUR = N1
         CALL X_TABLE1 (COLOUR, 'OPEN')
         COLOUR = N23
         NDIST = N0
         EXTRA = .FALSE.
         DO I = N2, N
            IF (ABS(X(I) - X(I - N1)).LE.EPSI) THEN
               DOSUMS = .FALSE.
               YSUM = YSUM + Y(I)
               NREPS = NREPS + N1
               IF (I.EQ.N) THEN
                  DOSUMS = .TRUE.
                  ICOUNT = N0
               ENDIF
            ELSE
               IF (NREPS.EQ.N1) THEN
                  NDIST = NDIST + 1
                  X(NDIST) = X(I - N1)
                  Y(NDIST) = Y(I - N1)
                  E(NDIST) = E(I - N1)
                  DOSUMS = .FALSE.
                  YSUM = Y(I)
                  WRITE (LINE,200) I - N1
                  CALL X_TABLE1 (COLOUR, LINE)
               ELSE
                  DOSUMS = .TRUE.
                  ICOUNT = N1
               ENDIF
               IF (I.EQ.N) EXTRA = .TRUE.
            ENDIF
            IF (DOSUMS) THEN
               RNREPS = DBLE(NREPS)
               NDIST = NDIST + N1
               YBAR = YSUM/RNREPS
               SSQ = ZERO
               DO J = N1, NREPS
                  SSQ = SSQ + (Y(I - NREPS + J - ICOUNT) - YBAR)**2
               ENDDO
               SIGMA = SQRT(SSQ/(RNREPS - ONE))
               IF (SIGMA.LT.ERRMIN) THEN
                  SIGMA = PNT1*ABS(YBAR)
                  WRITE (LINE,400) ERRMIN, I - NREPS + N1 - ICOUNT,
     +                             I - ICOUNT
                  CALL X_TABLE1 (COLOUR, LINE)
               ENDIF
               X(NDIST) = X(I - N1)
               Y(NDIST) = YBAR
               E(NDIST) = MAX(ERRMIN, SIGMA/SQRT(RNREPS))
               YSUM = Y(I)
               NREPS = N1
            ENDIF
         ENDDO
         IF (EXTRA) THEN
            NDIST = NDIST + N1
            X(NDIST) = X(N)
            Y(NDIST) = Y(N)
            E(NDIST) = E(N)
            WRITE (LINE,200) N
            CALL X_TABLE1 (COLOUR, LINE)
         ENDIF
         N = NDIST
         CALL X_TABLE1 (COLOUR, 'CLOSE')
      ELSEIF (ISEND.EQ.3) THEN
C
C ISEND = 3: Compress and set up N, X, Y, E for an error-bar type file
C ==========
C        
         NMAX = N 
C
C Allocate workspaces
C                    
         IERR = N0
         IF (ALLOCATED(EGRAF)) DEALLOCATE(EGRAF, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         IF (ALLOCATED(XGRAF)) DEALLOCATE(XGRAF, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         IF (ALLOCATED(YGRAF)) DEALLOCATE(YGRAF, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         IF (ALLOCATED(YH1)) DEALLOCATE(YH1, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         IF (ALLOCATED(YL1)) DEALLOCATE(YL1, STAT = IERR)
         IF (IERR.NE.N0) RETURN
         IF (N.GT.NMAX) THEN
            CALL X_PUTFAT(
     +     'N > NMAX in X_NYYBAR ... Cannot make error bars')
            RETURN
         ENDIF
         ALLOCATE(EGRAF(NMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
         ALLOCATE(XGRAF(NMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
         ALLOCATE(YGRAF(NMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
         ALLOCATE(YH1(NMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
         ALLOCATE(YL1(NMAX), STAT = IERR)
         IF (IERR.NE.N0) RETURN
C
C Branch to statement label 20 to re-set error bar parameters
C
   20    CONTINUE
         WRITE (TEXT,500)
         NUMSTA = N15
         NUMOPT = N7
         NUMTXT = NUMSTA + NUMOPT - N1
         NUMDEC = N1
         NUMBLD(1) = N4
         CALL X_LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                  TEXT)
         NUMBLD(1) = N0
C
C Define TSTAT if NUMDEC > 1
C
         IF (NUMDEC.EQ.N2 .OR. NUMDEC.EQ.N5) THEN
            TSTAT = ONE
         ELSEIF (NUMDEC.EQ.N3 .OR. NUMDEC.EQ.N6) THEN
            TSTAT = TWO
         ELSEIF (NUMDEC.EQ.N4) THEN
            TSTAT = TWO
            CALL X_GETD01 (TSTAT, 
     +     'Number of standard errors of mean-y required')
            IF (TSTAT.LT.ERRMIN) THEN
               TSTAT = ERRMIN
            ELSEIF (TSTAT.GT.ERRMAX) THEN
               TSTAT = ERRMAX
            ENDIF      
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            TSTAT = TWO
            CALL X_GETD01 (TSTAT,
     +     'Number of standard deviations of y-replicates required')
            IF (TSTAT.LT.ERRMIN) THEN
               TSTAT = ERRMIN
            ELSEIF (TSTAT.GT.ERRMAX) THEN
               TSTAT = ERRMAX
            ENDIF      
         ENDIF
         
C
C Initialise TABLE1 and loop parameters
C
         NDIST = N0
         NREPS = N1
         YSUM = Y(N1)
         EXTRA = .FALSE.
         COLOUR = N1
         CALL X_TABLE1 (COLOUR, 'OPEN')
         COLOUR = N23
C
C Main loop ... Create XGRAF, YGRAF, EGRAF
C
         XGRAF(N1) = X(N1)
         YGRAF(N1) = Y(N1)
         EGRAF(N1) = E(N1)
         DO I = N2, N
            IF (ABS(X(I) - X(I - N1)).LE.EPSI) THEN
               DOSUMS = .FALSE.
               YSUM = YSUM + Y(I)
               NREPS = NREPS + N1
               IF (I.EQ.N) THEN
                  DOSUMS = .TRUE.
                  ICOUNT = N0
               ENDIF
            ELSE
               IF (NREPS.EQ.N1) THEN
                  NDIST = NDIST + N1
                  XGRAF(NDIST) = X(I - N1)
                  YGRAF(NDIST) = Y(I - N1)
                  EGRAF(NDIST) = TWO*E(I - N1)
                  DOSUMS = .FALSE.
                  YSUM = Y(I)
                  WRITE (LINE,200) I - N1
                  CALL X_TABLE1 (COLOUR, LINE)
               ELSE
                  DOSUMS = .TRUE.
                  ICOUNT = N1
               ENDIF
               IF (I.EQ.N) EXTRA = .TRUE.
            ENDIF
            IF (DOSUMS) THEN
               RNREPS = DBLE(NREPS)
               NDIST = NDIST + N1
               YBAR = YSUM/RNREPS
               SSQ = ZERO
               DO J = N1, NREPS
                  SSQ = SSQ + (Y(I - NREPS + J - ICOUNT) - YBAR)**2
               ENDDO
               SIGMA = SQRT(SSQ/(RNREPS - ONE))
               IF (SIGMA.LT.ERRMIN) THEN
                  SIGMA = PNT1*ABS(YBAR)
                  WRITE (LINE,400) ERRMIN, I - NREPS + N1 - ICOUNT,
     +                             I - ICOUNT
                  CALL X_TABLE1 (COLOUR, LINE)
               ENDIF
               XGRAF(NDIST) = X(I - N1)
               YGRAF(NDIST) = YBAR
               IF (NUMDEC.EQ.N1) THEN
                  IFAIL = N1
                  J = N2
                  TSTAT = X_G01FBF('Lower-tail', PNT975,
     +                             DBLE(NREPS - N1), IFAIL)
C*****************CALL X_PUTIFA (IFAIL, J, 'G01FBF/NYYBAR')
               ENDIF
               IF (NUMDEC.LE.N4) THEN
                  EGRAF(NDIST) = TSTAT*SIGMA/SQRT(RNREPS)
               ELSE
                  EGRAF(NDIST) = TSTAT*SIGMA
               ENDIF
               YSUM = Y(I)
               NREPS = N1
            ENDIF
         ENDDO
         IF (EXTRA) THEN
            NDIST = NDIST + N1
            XGRAF(NDIST) = X(N)
            YGRAF(NDIST) = Y(N)
            EGRAF(NDIST) = TWO*E(N)
            WRITE (LINE,200) N
            CALL X_TABLE1 (COLOUR, LINE)
         ENDIF
         CALL X_TABLE1 (COLOUR, 'CLOSE')
C
C Branch to statement label 40 to plot/choose-new-parameters/write-file
C

   40    CONTINUE
         WRITE (TEXT,600)
         NUMSTA = N7
         NUMOPT = N3
         NUMTXT = NUMSTA + NUMOPT - N1
         NUMDEC = N1
         NUMBLD(1) = N4
         CALL X_LSTBOX (NUMBLD, NUMDEC, N3, NUMSTA, NUMTXT,
     +                  TEXT)
         NUMBLD(1) = N0
         IF (NUMDEC.EQ.N1) THEN
C
C Plot then return to 40 for more instructions
C
            DO I = N1, NDIST
               YH1(I) = YGRAF(I) + EGRAF(I)
               YL1(I) = YGRAF(I) - EGRAF(I)
            ENDDO
            CALL W_PLOTEB (NDIST,
     +                     XGRAF, YL1, YGRAF, YH1)           
C            CALL GKSCB4 (N0, N0, N0, N0, N5, N0, N0, N0,
C     +                   NDIST, N1, N1, N1,
C     +                   XGRAF, XTEMP, XTEMP, XTEMP,
C     +                   YH1, YTEMP, YL1, YTEMP,
C     +                   YGRAF, YTEMP, YTEMP, YTEMP,
C     +                   PTITLE, XTITLE, YTITLE,
C     +                   SAVEIT, SAVEIT)
            GOTO 40
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Return to 20 to choose new error bar parameters
C
            GOTO 20
         ELSEIF (NUMDEC.EQ.N3) THEN

C
C Re-set X, Y and E then exit subroutine
C
            N = NDIST
            DO I = N1, N
               X(I) = XGRAF(I)
               Y(I) = YGRAF(I)
               E(I) = EGRAF(I)
            ENDDO 
            DEALLOCATE(EGRAF, STAT = IERR)
            DEALLOCATE(XGRAF, STAT = IERR)
            DEALLOCATE(YGRAF, STAT = IERR)
            DEALLOCATE(YH1, STAT = IERR)
            DEALLOCATE(YL1, STAT = IERR)
         ENDIF
      ENDIF              
C
C Format statements
C      
  100 FORMAT ('Data out of order at line',I6)
  200 FORMAT (1X,'No replicates  at  data point',I8,1X,
     +': S is unchanged')
  300 FORMAT (1X,'Estimate <=',1P,E8.1,1X,'from',I5,1X,'to',I5,1X,
     +': S is unchanged')
  400 FORMAT (1X,'Estimate <=',1P,E8.1,1X,'from',I5,1X,'to',I5,1X,
     +': S is 10% mean Y')
  500 FORMAT (
     + 'Selecting the size of error bars'
     +/
     +/'This procedure can be used when there are replicate'
     +/'y-observations at every distinct x-value and it is'
     +/'wished to plot means of replicates with error bars.'
     +/
     +/'Symmetrical error bars assume normally distributed'
     +/'errors, so meaningful error bars are 95% confidence'
     +/'limits, which uses the t distribution.'
     +/'With small sample sizes (e.g. n < 5 ?) this gives'
     +/'wide (but correct) error bars, so you may choose'
     +/'to plot a fixed number of standard errors of mean'
     +/'y, or sample standard deviations of replicates.'
     +/ 
     +/'95% confidence limits of mean y'
     +/'(+/-)1 standard errors of mean y'
     +/'(+/-)2 standard errors of mean y'
     +/'(+/-)n standard errors of mean y'
     +/'(+/-)1 y-replicate standard deviations'
     +/'(+/-)2 y-replicate standard deviations'
     +/'(+/-)n y-replicate standard deviations')
  600 FORMAT (
     + 'Accepting or altering error bar size'
     +/
     +/'You now have the opportunity to view the size of'
     +/'these error bars to decide whether to alter the'
     +/'width before accepting the current selection.'
     +/  
     +/'Plot the current error bars'
     +/'Select new error bar parameter'
     +/'Accept these error bars' )
      END
C
C
