c
c
      subroutine x_okcval (isend,
     +                     ok)
c
c action: check the Simfit configuration file for program cval(isend)
c author: w.g.bardsley, university of manchester, u.k. 23/06/2009
c         28/07/2015 improved the interface and added a Help options
c         07/05/2017 added isend = 2 and new argument ok
c         16/05/2017 added isend = 6 for ghostscript dll local or on the path
c                    so no offer to locate if ghostscript cannot be located
c         12/11/2022 greatly simplified to limit cases needing a search but left
c                    all the searching code in for possible future use 
c
c         calls w_config and returns ok depending on the existence of cval(isend)
c         where isend is the number of the cval to be checked as follows:
c         isend =  1: editor      ... notepad.exe
c         isend =  2: explorer    ... explorer.exe 
c         isend =  6: gsdll??.dll ... gsdll64.dll or gsdll32.dll
c         isend =  8: ghostscript ... gswin32c.exe or gsdll64.dll
c         isend = 10: gsview      ... gsview32.exe
c         isend = 11: reader      ... acrord32.exe
c
      implicit none
      include <windows.ins> 
c
c argument
c      
      integer, intent (in)  :: isend
      logical, intent (out) :: ok
c
c locals
c      
      integer (kind = 7) l
      integer    n6
      parameter (n6 = 6)
      integer    ios, mode, nval(12)
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, lshade = 0, numopt = 4,
     +           numsta = 17)
      integer    numbld(30), numpos(numopt)
      character (len = 1024) cval(12)
      character (len = 100 ) line, text(30)
      character (len = 80  ) pname(2)
      character (len = 11  ) dllname
      logical    usedll, use_gsdll
      logical    info_gsview, isit64, first
      logical    repeet, file_found(12), ok64, switch_off(12), there
      logical    fixed, full, high
      parameter (fixed = .false., full = .true., high = .true.)
      external   w_config, w_lbox01, x_patch2, x_putadv, isit64, pdfrdr,
     +           epsrdr, use_gsdll
      save       first, ok64
      data       first, ok64 / .true., .true. /
      save       file_found, switch_off
      data       file_found, switch_off / 12*.false., 12*.false. /
      data       dllname / 'gsdll64.dll' /
      data       numbld /30*0 /
      data       numpos / numopt*1 /
c
c initialise ok = .false.
c      
      ok = .false.
c
c check cases where searching is not required
c
      if ((isend.ge.4 .and. isend.le.7) .or.
     +    isend.eq.9                    .or.
     +    isend.eq.11) then
          ok = .true. 
          return  
      endif 
c
c check cases depending on ghostscript dll
c               
      usedll = use_gsdll()
      if (isend.eq.8 .or. isend.eq.10 ) then
          if (usedll) ok = .true.
          return
      endif  
c
c check and initialise file_found(6) first time
c
      info_gsview = .false.!provide option to find gsview
      if (first) then
         first = .false.
         ok64 = isit64()
         pname(1) = 'GhostScript DLL'    
         if (ok64) then
            pname(2) = 'gsdll64.dll'
         else
            pname(2) = 'gsdll32.dll'   
         endif  
         dllname = pname(2)(1:11)
         inquire (file = pname(2), iostat = ios, exist = there) 
         if (ios.eq.0 .and. there )then
            file_found(n6) = .true.
            ok = .true.
         else
            ok = .false.
         endif   
         if (.not.ok) then
            l = loadlibrary (pname(2))
            if (l.gt.0) then
               file_found(n6) = .true.
               ok = .true.
            endif   
         endif      
         switch_off(n6) = .true.
      endif 
c
c subsequent entries
c      
      ok = file_found(isend)
      if (switch_off(isend)) return 
      if (isend.eq.1) then
         pname(1) = 'Text editor'
         pname(2) = 'notepad.exe'  
      elseif (isend.eq.2) then
         pname(1) = 'Disk explorer'
         pname(2) = 'explorer.exe'   
      elseif (isend.eq.8) then
         pname(1) = 'Ghostscript'
         if (ok64) then
            pname(2) = 'gswin64c.exe'
         else       
            pname(2) = 'gswin32c.exe'    
         endif   
      elseif (isend.eq.10) then  
         pname(1) = 'PostScript viewer'
         call epsrdr (pname(2))    
         ok = .true.
      elseif (isend.eq.11) then
         pname(1) = 'PDF reader'
         call pdfrdr (pname(2))
         ok = .true.
         return
      else   
         switch_off(isend) = .true.  
         return
      endif  
c
c check the current program
c      
      mode = 0
      call w_config (mode, nval,
     +               cval)
      inquire (file = cval(isend), iostat = ios, exist = there)
      if (ios.eq.0 .and. there) then
c
c ok so return
c 
         ok = .true.
         file_found(isend) =.true.          
         switch_off(isend) = .true.
         return
      else
c
c provide options
c        
         ok =.false.
         file_found(isend) = .false.
         
         if (isend.eq.10 .and. .not.info_gsview) return
           
         repeet = .true.
         do while (repeet)
            numbld(1) = 4
            numbld(5) = 1
            numdec = numopt - 1
            write (text,100) pname(1), pname(2), pname(1)
            if (isend.eq.8) then
               if (file_found(n6)) return 
               text(14) = 
     +'c)`GhostScript does not simply open PostScript files'
               text(15) = 
     +'  `so there is no extension-dependent Windows default'
            endif  
            numtxt = numsta + numopt - 1
            call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt, numpos, numsta, numtxt,
     +                     text,
     +                     fixed, full, high)
            numbld(1) = 0
            numbld(5) = 0
            if (numdec.eq.1) then
c
c attempt to re-configure
c              
               write (line,200) pname(1)
               call x_putadv (line)
               mode = 1
               call w_config (mode, nval,
     +                        cval)
               inquire (file = cval(isend), iostat = ios, exist = there)
               if (ios.eq.0 .and. there) then
c
c ok so return
c 
                  ok = .true.
                  file_found(isend) =.true.
               else          
                  ok = .false.
                  file_found(isend) = .false.
               endif    
               repeet = .false.           
            elseif (numdec.eq.2) then
               switch_off(isend) = .true.
               repeet = .false.
            elseif (numdec.eq.numopt - 1) then 
               if (isend.eq.1) then
                  write (text,101)
                  numtxt = 15
               elseif (isend.eq.2) then
                  write (text,102)
                  numtxt = 14   
               elseif (isend.eq.8) then 
                  write (text,108)
                  numtxt = 20
               elseif (isend.eq.10) then 
                  write (text,110)
                  numtxt = 20   
               elseif (isend.eq.11) then 
                  write (text,111)
                  numtxt = 19      
               endif
               numbld(1) = 1
               call x_patch2 (numbld, numtxt,
     +                        text)                    
            elseif (numdec.eq.numopt) then
               repeet = .false.
            endif 
         enddo            
      endif
      switch_off(isend) = .true.
c
c format statements
c     
  100 format (
     + 'Simfit cannot find your',1x,a
     +/
     +/'A suitable program is:'
     +/
     +/a
     +/      
     +/'The options for specifying a program are:'
     +/
     +/'a)`Edit w_simfit.cfg manually;'
     +/
     +/'b)`Configure now or later, followed by using'
     +/'  `the [Check] then [Apply] buttons; or'
     +/
     +/'c)`Use the default program that you have selected or that'
     +/'  `Windows has chosen for the particular file extension.'
     +/
     +/'Configure Simfit now'
     +/'Switch this check off'
     +/'Help about your ...',1x,a
     +/'Quit ... Exit these utility checking options') 
  101 format (
     + 'Configuring Simfit to use your chosen text editor'
     +/  
     +/'Simfit can function without specifying a text editor'
     +/'but some functions will be disabled as follows:'
     +/
     +/'1.`General interactive editing'  
     +/'2.`Printing some results pages'  
     +/'3.`Copying/Pasting results pages'  
     +/'4.`Rapid creation of small data or graphics files' 
     +/'5.`Creating model equations for simulation/fitting'
     +/
     +/'For most purposes the built-in Windows editor Notepad.exe'
     +/'is perfectly adequate, but for experienced users needing'
     +/'more advanced editing then Notepad++, Emacs, or any other'
     +/'of your favourite text editors can be specified.') 
  102 format (
     + 'Configuring Simfit to use your chosen disk explorer'
     +/  
     +/'Simfit can function without specifying a disk explorer'
     +/'but some functions may be disabled as follows:'
     +/
     +/'1.`Finding files'  
     +/'2.`Opening files'  
     +/'3.`Changing folder options'  
     +/'4.`Running additional software' 
     +/'5.`Creating model equations for simulation/fitting'
     +/
     +/'For most purposes the built-in Windows program explorer.exe'
     +/'is perfectly adequate, but for experienced users needing'
     +/'more advanced editing then other explorers can be specified.')
  108 format (
     + 'Configuring Simfit to use Ghostscript'
     +/  
     +/'Simfit can function without specifying the superb free'
     +/'Ghostscript package or the DLL, and can still create EPS'
     +/'files, but some functions will be compromised, e.g.'
     +/
     +/'1.`Viewing or printing Simfit EPS files interactively' 
     +/'  `(unless you have gsview version 6 onwards)'    
     +/'2.`Using Simfit EPS files iteractively or retrospectively'  
     +/'  `to make other formats such as PNG, PDF, JPG, etc.'
     +/
     +/'If you do not have a functional Ghostscript installation or'
     +/'DLL you will only be able to print Windows quality graphics,'
     +/'and it will prove more difficult to exploit the superior'
     +/'quality and versatility of Simfit EPS files such as:'
     +/
     +/'a)`Tiny compact vector graphics for archiving'
     +/'b)`Retrospective editing using any text editor'
     +/'c)`Creating collages and overlaying plots'
     +/'d)`Stretching white space to overcome label crowding')
  110 format (
     + 'Configuring Simfit to use a PS Viewer'
     +/  
     +/'Simfit can function without specifying a PS viewer, and'
     +/'can still create EPS files, but some functions will be'
     +/'compromised, e.g.'
     +/
     +/'1.`Viewing Simfit EPS files interactively'  
     +/'2.`Printing Simfit EPS files on any printer'  
     +/'3.`Correcting BoundingBoxes after editing Simfit EPS files'  
     +/'4.`Adding preview sections to Simfit EPS files'
     +/
     +/'If you do not have a functional PS viewer like gsview, then'
     +/'Simfit will attempt to divert calls to your PS driver on to'
     +/'your PDF reader. So, in this sense, a PS viewer is not really'
     +/'necessary if you have a PDF reader like Acrobat or SumatraPDF.'
     +/
     +/'The recommended PS viewer is GSview, but there other free'
     +/'PS viewers. Note that some PS viewers pass eps files into'
     +/'Ghostscript to make a bit map for viewing or printing so'
     +/'they still require a Ghoscript installation or DLL.') 
  111 format (
     + 'Configuring Simfit to use a PDF reader'
     +/  
     +/'Simfit can function without specifying a PDF reader, and'
     +/'can still create EPS files, but some functions will be'
     +/'compromised, e.g.'
     +/
     +/'1.`Viewing Simfit EPS files interactively as PDF files'  
     +/'2.`Printing Simfit EPS files as PDF files on any printer'  
     +/'3.`Viewing the Simfit manual and other documents such as'  
     +/'  `the collected tutorials and worked examples.'
     +/
     +/'If Simfit reports that it cannot find your PDF reader it'
     +/'almost certainly means you have not configured Simfit to'
     +/'find your PDF reader. So, if this happens, you must choose'
     +/'to reconfigure this item or accept the default.'
     +/
     +/'Note that most computers will have the Adobe Acrobat reader'
     +/'installed, but there are also numerous free PDF readers such'
     +/'as SumatraPDF that can be downloaded and used by Simfit.')
  200 format (
     +'You can try to reconfigure your',1x,a)     
      end
c
c
