c
c
      subroutine x_openvu (numdec, numtxt,
     +                     text,
     +                     view)
c
c action: create a tabbed vuopen type control
c author: w.g.bardsley, university of manchester, u.k., 27/01/2010
c
c note: letter, stopper, and nbig were adjusted to get top left hand
c       positioning and suppress the horizontal scroll bar. This 
c       version only supports two tabbing columns
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: numtxt
      integer,             intent (inout) :: numdec
      character (len = *), intent (in)    :: text(numtxt) 
      logical,             intent (out)   :: view 
c
c locals
c      
      integer    i, j, jmax, k, kmax, numopt, ntext
      integer    x_len200
      integer    ixl, iyl, nmax, nstart
      parameter (ixl = 4, iyl = 4, nmax = 1000, nstart = 2)
      character  text_copy(nmax)*129
      character  bar*1, blank*1, grave*1, letter*1
      parameter (bar = '|', blank = ' ', grave = '`', letter = 'x')
      logical    titles
      parameter (titles = .false.)
      external   w_vuop02, x_len200
      intrinsic  min, index  
c
c initialise
c      
      numopt = min(nmax - 1, numtxt) 
      jmax = 0
      kmax = 0
      ntext = numopt + 1
      do i = 2, ntext
c
c copy with a bar at the start and where the grave was
c        
         text_copy(i) = bar//text(i - 1)
         j = index(text_copy(i),grave)
         if (j.gt.0) then
            text_copy(i)(j:j) = bar
            if (j.gt.jmax) jmax = j
         endif     
         k = x_len200(text_copy(i))
         if (k.gt.kmax) kmax = k  
      enddo
c
c space out the virtual column headers
c      
      text_copy(1) = blank
      do i = 1, jmax + kmax 
         text_copy(1)(i:i) = letter   
      enddo
      text_copy(1)(1:1) = bar
      text_copy(1)(jmax:jmax) = bar
      call w_vuop02 (ixl, iyl, numdec, numopt, nstart, ntext,
     +               text_copy,
     +               titles,
     +               view)
      end           
c       
c
