c
c
      subroutine x_parse0 (line, 
     +                     abort)
c
c action: pre-process a string, e.g. before calling x_parse5  
c author: w.g.bardsley, university of manchester, 25/10/2014
c
c   line: transformed if it seems like a single number but with ',' instead of '.' 
c         It will not be transformed if any of the following conditions apply:
c         presence of any tabs or decimal points
c         there are either no commas or multiple commas
c         it is longer than 25 characters after left-shifting
c         internal spaces exist within the line
c         non-numeric characters are encountered
c         there are too many +, -, or E-type characters
c 
c  abort: returned as .true.  if further action is required
c         returned as .false. if no further action is required 
c
      implicit none
c
c arguments
c      
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort 
c
c locals
c       
      integer    i, ios, k, l
      integer    n_comma, n_exp, n_minus, n_plus
      integer    nstart, nstop  
      double precision x
      character (len = 25) word25
      character (len = 1 ) blank, comma, letter, minus, plus, point, tab
      parameter (blank = ' ', comma = ',', minus = '-', plus = '+',
     +           point = '.')
      intrinsic  adjustl, ichar, index, char  
c
c initialise abort then check for special cases
c                         
      abort = .true.
      if (line.eq.blank) return
      tab = char(9)
      l = index(line,tab)
      if (l.gt.0) return
      l = index(line,point)
      if (l.gt.0) return
      l = index(line,comma)
      if (l.le.0) return  
c
c adjust left but return if it is too big to be single number
c
      line = adjustl(line)    
      l = len_trim(line)  
      if (l.gt.25) return
c
c define nstart, nstop 
c        
      nstart = 1
      nstop = l
c
c examine the string in detail
c      
      n_comma = 0
      n_exp = 0
      n_minus = 0
      n_plus = 0

      do i = nstart, nstop
         letter = line(i:i)
         if (letter.eq.blank) then
            return
         elseif (letter.eq.comma) then
            n_comma = n_comma + 1
            if (n_comma.gt.1) return
         elseif (letter.eq.'e' .or. letter.eq.'E' .or.
     +           letter.eq.'d' .or. letter.eq.'D') then
            n_exp = n_exp + 1
            if (n_exp.gt.1) return
         elseif (letter.eq.minus) then
            n_minus = n_minus + 1
            if (n_minus.gt.2) return
            if (n_plus + n_minus.gt.2) return    
         elseif (letter.eq.plus) then
            n_plus = n_plus + 1 
            if (n_plus.gt.2) return
            if (n_plus + n_minus.gt.2) return    
         else      
            k = ichar(letter)
            if (k.lt.48 .or. k.gt.57) return
         endif      
      enddo  
c
c the core value of line is a continuous string of digits with a single comma, no blanks and
c at most one exponential and two signs so finally check if it can be read in as a number 
c      
      word25 = blank
      word25(nstart:nstop) = line(nstart:nstop) 
      k = index(word25,comma)
      word25(k:k) = point
      read (word25,*,iostat=ios) x
      if (ios.eq.0) then
c
c it is now a number so replace line by word25
c        
         line(nstart:nstop) = word25(nstart:nstop)
         abort = .false.
      endif
      end   
c
c
      