c
c
      subroutine x_parse1 (isend,
     +                     line,
     +                     abort)
c
c action: elementary string operations prior to parsing clipboard, etc.
c author: w.g.bardsley, university of manchester, u.k., 03,12,2004
c         31/01/2007 derived from parse1 
c         12/04/2008 added parsing at tabs = char(9) and semicolons as well as commas
c         16/04/2008 added preliminary parsing to blank out nonprinting characters
c                    and dealing with quoted cells  
c         20/04/2009 added code to replace commas by blanks if there are tabs or semicolons    
c
c         About the parse? routines
c         =========================
c         Note that maximum string length (nmax) should be the same in all
c         of these routines.
c         The routines are designed to take a string and manipulate it
c         or analyse it as follows.
c
c         parse1: perform elementary string transformations to prepare a
c                 string for further analysis. This can be used as a free
c                 standing string parser and transformer.
c         parse2: calculate the number of numerical and non-numerical values
c                 in a string processed by parse1 with isend = 5, i.e. with
c                 non-printing characters removed, ',,' replaced by ',X,',
c                 commas suppressed, and multiple blanks replaced by single
c                 blanks so that the string only contains space separated tokens.
c                 This will ONLY work on strings pre-processed by parse1 with
c                 isend = 5
c         parse3: break up a string at DOS-type hard returns then write a
c                 temporary file with the data after processing by parse1 with
c                 isend = 5 and suppressing blank lines.
c                 After further use the temporary file must be deleted.
c         parse4: analyse a file created by parse4 to calculate statistics
c                 for the number of words, numerical values, etc. This routine
c                 will only work on files of the type returned by parse3.
c                 After further use the temporary file must be deleted.
c         parse5: This relies on the other parse? routines to take in a
c                 string, parse, display diagnostics, and then Save As ...
c                 A file name must be provided and this is not deleted.
c                 Failure to write a file is signalled by abort = .true. on return.
c         parse6: This checks that if a line has a nonnumeric token it is the
c                 first, so allowing simfit label type files with row labels
c                 in column 1.
c         parse7: This breaks a string into labels at tabs, semicolons, or commas.   
c         parse8: checks if a simfit file can be created
c         parse9: checks if a token is numerical
c
c         isend: (input/unchanged) as follows:-
c                isend = -4: replace commas by dots if there are tabs or semi-colons present
c                isend = -3: replace nonpronting ASCII characters by blanks
c                isend = -2: deal with quoted tokens
c                isend = -1: break into tokens at tabs and underscore potential labels
c                isend = 0: break into tokens at semicolons and underscore potential labels
c                isend = 1: replace all nonprinting characters by blanks
c                isend = 2: break into tokens at commas and underscore potential labels
c                isend = 3: replace all commas by single blanks
c                isend = 4: replace all multiple blanks by single blanks
c                isend = 5: all of the above sequentially
c          line: (input/output) line to be transformed
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort
c
c locals
c
      integer    i, icount, j, jstop, k, l, m, n, num, nquote
      integer    i1, i2, i3
      integer    x_len200
      character  letter*1, tab1*1, tab2*2, token*100
      character  blank1*1, blank2*2, comma1*1, comma2*2, dot1*1, 
     +           quote*1, semi1*1, semi2*2, uscore*1,
     +           bigx*1, bigx2*2
      parameter (blank1 = ' ', blank2 = '  ', comma1 = ',',
     +           comma2 = ',,', dot1 = '.', quote = '"', semi1 = ';',
     +           semi2 = ';;', uscore = '_',
     +           bigx = 'X', bigx2 = 'XX')
      logical    build, done
      external   x_len200, x_triml1
      intrinsic  len, ichar, index, char
c
c check arguments
c
      abort = .true.
      if (isend.lt.-4 .or. isend.gt.5) return
      num = len(line)
      if (num.lt.1) return
c
c define n and num then action depending on isend
c
      abort = .false.
      n = x_len200 (line)
      if (n.lt.1) return
c
c initialise done then token
c      
      done = .false.
      token = blank1
c
c
      if (isend.eq.-4 .or. isend.eq.5) then
c        
c ===============
c isend = -4 or 5: replace commas by dots if there are tabs or semi-colons 
c ===============        
c
         tab1 = char(9) 
         if (index(line,tab1).gt.0 .or. index(line,semi1).gt.0) then
c
c replace commas by dots and sum separators 
c        
            icount = 0
            do i = 1, n
               letter = line(i:i)
               if (letter.eq.blank1 .or.
     +             letter.eq.semi1  .or.
     +             letter.eq.tab1) then
                  icount = icount + 1
               elseif (letter.eq.comma1) then
                  icount = icount + 1
                  line(i:i) = dot1
               endif  
            enddo        
c
c replace by blank string if only spaces, commas, semi-colons, or tabs are present
c         
            if (icount.eq.n) then
              line = blank1
              return
            endif  
         endif     
      endif 
c
c      
      
      if (isend.eq.-3 .or. isend.eq.5) then
c
c ===============
c isend = -3 or 5: replace nonprinting ASCII characters except tabs by blanks 
c ===============
c
         done = .true.
         do i = 1, n
            letter = line(i:i)
            j = ichar(letter)
            if (j.le.31 .and. j.ne.9) line(i:i) = blank1
         enddo
      endif        

      if (isend.eq.-2 .or. isend.eq.5) then
c
c ===============
c isend = -2 or 5: deal with quoted tokens 
c ===============
c
         m = index(line(1:n),quote)
         if (m.gt.0 .and. m.lt.n) then
            nquote = 1
            build = .true.
            j = 1
            token(j:j) = blank1
            do i = m + 1, n
               letter = line(i:i)
               if (letter.eq.quote) then
                  nquote = nquote + 1
                  if (mod(nquote,2).ne.0) then
c
c start of a new cell
c                    
                     build = .true.
                     j = 1
                     token(j:j) = blank1
                  else
c
c end of the current cell
c                    
                     build = .false.
                     j = j + 1
                     if (j.eq.2) then
c
c "" has been detected so replace by XX
c                       
                        line(i - 1:i) = bigx2
                     else
c
c replace " by blank then process token 
c                       
                        token(j:j) = blank1
                        jstop = j - 1
                        call x_triml1 (token(1:jstop))
                        l = index(token(1:jstop),comma1)
                        do while (l.gt.0)
c
c slide left to overwrite all commas
c                          
                           do k = l, jstop
                              token(k:k) = token(k + 1:k + 1) 
                           enddo  
                           if (jstop.gt.1) then
                              jstop = jstop - 1
                              l = index(token(1:jstop),comma1)
                           else
                              l = 0
                           endif      
                        enddo  
                        if (token.eq.blank1) token = bigx
                        i3 = x_len200(token(1:j))
                        if (i3.gt.1) then
                           i3 = i3 - 1
                           l = index(token(1:i3),blank1)
                           do while (l.gt.0)
c
c replace all internal blanks by underscores
c                             
                              k = l
                              token(k:k) = uscore
                              l = index(token(1:i3),blank1)
                           enddo 
                        endif  
c
c overwrite segment of line by the processed token
c                                               
                        line(i - j + 1:i) = token(1:j)
                        token = blank1
                     endif     
                  endif
               elseif (build) then  
c
c build up token
c                
                  j = j + 1
                  token(j:j) = letter
               endif          
            enddo    
         endif
      endif  

      if (isend.eq.-1 .or. isend.eq.5) then
c
c =============== 
c isend = -1 or 5: search for tabs = char(9)
c ===============
c        
         tab1 = char(9)
         m = index(line(1:n),tab1)
         if (m.gt.0) then
            if (m.eq.1) then
c
c shuffle if first character is character(9)
c           
               n = n + 1
               do i = n, 2, -1
                  line(i:i) = line(i - 1:i - 1)
               enddo
               line(1:1) = bigx   
            endif   
            
            if (line(n:n).eq.tab1 .and. n.lt.num) then
c
c append if last character is character(9)
c           
               n = n + 1
               line(n:n) = bigx
            endif
c
c check for empty cells and replace by X
c          
            tab2 = tab1//tab1
            k = index(line,tab2)
            do while (k.gt.0 .and. n.lt.num)
                n = n + 1
                do i = n, k + 1, -1
                   line(i:i) = line(i - 1:i - 1)
                enddo  
                line(k + 1:k + 1) = bigx
                k = index(line,tab2) 
            enddo  
c
c break into tokens and underscore potential labels
c              
            i1 = 1
            i2 = 0
            do i = 1, n
               if (line(i:i).eq.tab1) then
                  i2 = i - 1
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif   
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
                  line(i:i) = blank1
                  i1 = i + 1
               elseif (i.eq.n) then 
                  i2 = n 
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif                     
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
               endif        
            enddo  
         endif   
      endif       

      if (isend.eq.0 .or. isend.eq.5) then
c
c ==============
c isend = 0 or 5: search for semis
c ===============
c        
         m = index(line(1:n),semi1)
         if (m.gt.0) then
            if (m.eq.1 .and. m.lt.n) then
c
c shuffle if first character is a semi
c           
               n = n + 1
               do i = n, 2, -1
                  line(i:i) = line(i - 1:i - 1)
               enddo
               line(1:1) = bigx
           endif
               
         if (line(n:n).eq.semi1 .and. n.lt.num) then
c
c append if last character is a semi
c           
               n = n + 1
               line(n:n) = bigx
            endif
c
c check for empty cells
c          
            k = index(line,semi2)
            do while (k.gt.0 .and. n.lt.num)
                n = n + 1
                do i = n, k + 1, -1
                   line(i:i) = line(i - 1:i - 1)
                enddo  
                line(k + 1:k + 1) = bigx
                k = index(line,semi2) 
            enddo  
c
c break into tokens and underscore potential labels
c              
            i1 = 1
            i2 = 0
            do i = 1, n
               if (line(i:i).eq.semi1) then
                  i2 = i - 1
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif                                       
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
                  line(i:i) = blank1
                  i1 = i + 1
               elseif (i.eq.n) then 
                  i2 = n 
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif                                        
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
               endif        
            enddo  
         endif   
      endif       
      
      if (isend.eq.1 .or. isend.eq.5) then
c
c ===============
c isend = 1 or 5: replace nonprinting ASCII characters by blanks in the whole string
c ===============
c
         if (.not.done) then
            do i = 1, num
               letter = line(i:i)
               j = ichar(letter)
               if (j.le.31) line(i:i) = blank1
            enddo
         endif   
      endif

      if (isend.eq.2 .or. isend.eq.5) then
c
c ===============
c isend = 2 or 5: search for commas
c ===============
c        
         m = index(line(1:n),comma1)
         if (m.gt.0) then
            if (m.eq.1 .and. n.lt.num) then
c
c shuffle if first character is a comma
c           
               n = n + 1
               do i = n, 2, -1
                  line(i:i) = line(i - 1:i - 1)
               enddo
               line(1:1) = bigx   
            endif

           if (line(n:n).eq.comma1 .and. n.lt.num) then
c
c append if last character is a comma
c           
               n = n + 1
               line(n:n) = bigx
            endif
c
c check for empty cells
c          
            k = index(line(1:n),comma2)
            do while (k.gt.0 .and. n.lt.num)
                n = n + 1
                do i = n, k + 1, -1
                   line(i:i) = line(i - 1:i - 1)
                enddo  
                line(k + 1:k + 1) = bigx
                k = index(line(1:n),comma2) 
            enddo  
c
c break into tokens and underscore potential labels
c              
            i1 = 1
            i2 = 0
            do i = 1, n
               if (line(i:i).eq.comma1) then
                  i2 = i - 1
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif                                       
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
                  line(i:i) = blank1
                  i1 = i + 1
               elseif (i.eq.n) then 
                  i2 = n 
                  token = line(i1:i2)
                  if (token.eq.blank1) token = bigx
                  call x_triml1 (token)  
                  i3 = x_len200(token)
                  l = index(token(1:i3),blank1)
                  if (l.gt.0) then   
                     do j = l, i3
                        if (token(j:j).eq.blank1) token(j:j) = uscore
                     enddo
                  endif                                        
                  k = 0
                  do j = i1, i2
                     k = k + 1
                     line(j:j) = token(k:k)
                  enddo   
               endif        
            enddo  
         endif   
      endif       

      if (isend.eq.3 .or. isend.eq.5) then
c
c ===============
c isend = 3 or 5: replace commas by blanks
c ===============
c
         j = index(line(1:n),comma1)
         do while (j.gt.0)
            line(j:j) = blank1
            j = index(line,comma1)
         enddo
      endif
      
      if (isend.eq.4 .or. isend.eq.5) then
c
c ===============
c isend = 4 or 5: replace multiple blanks by single blanks
c ===============
c
         j = index(line(1:n),blank2)
         do while (j.gt.0)
            do i = j + 1, n - 1
               line(i:i) = line(i + 1:i + 1)
            enddo
            line(n:n) = blank1
            n = n - 1
            j = index(line(1:n), blank2)
         enddo
      endif
      end
c
c