c
c
      subroutine x_parse2 (nvals, nwords,
     +                     line,
     +                     abort)
c
c action: returns the number of numerical values and words (i.e. tokens) in a line
c author: w.g.bardsley, university of manchester, u.k., 09/12/2004
c         23/02/2005 corrected for special case of 1-character lines 
c         31/01/2007 derived from parse2
c         28/05/2011 added call to x_parse9
c
c         This routine should only be used on strings that have been
c         pre-processed by parse1 with isend = 5 so that words are
c         separated by single spaces and there are no non-printing
c         characters in the string. However multiple spaces will still work.
c
c         nvals: (output) number of distinct space separated numerical values
c        nwords: (output) number of distinct space separated words
c          line: (input/unchanged) string
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,             intent (out) :: nvals, nwords
      character (len = *), intent (in)  :: line
      logical,             intent (out) :: abort
c
c locals
c
      integer    i, icount, l, num, nstart
      integer    x_len200
      character  letter*1, word*100
      character  blank1*1
      parameter (blank1 = ' ')
      logical    x_parse9
      external   x_len200, x_parse9
      intrinsic  len
c
c initialise, check, then if OK work out the string lengths
c      
      abort = .true.
      nvals = 0
      nwords = 0
      l = len (line)
      if (l.lt.1) return
      abort = .false.
      num = x_len200(line)
c
c special action if only a 1-character line
c
      if (num.eq.1) then
         nwords = 1
         letter = line(1:1)
         if (x_parse9(letter)) nvals = nvals + 1
         return
      endif
c
c break the line into space separated tokens and check each one
c      
      if (line(1:1).eq.blank1) then
c
c first character is a blank
c        
         icount = 0
      else
c
c first character is not a blank
c        
         icount = 1
      endif
      nstart = 1
      do i = 2, num
         letter = line(i:i)
         if (letter.ne.blank1) icount = icount + 1
         if (i.eq.num .or. letter.eq.blank1) then
c
c a blank or end of line has been encountered
c           
            if (icount.gt.0) then
c
c icount > 0 so a token has been identified
c           
               nwords = nwords + 1
               word = line(nstart:i)
               if (x_parse9(word)) nvals = nvals + 1
               nstart = i + 1
               icount = 0
            endif
         endif
      enddo
      end
c
c
