c
c
      subroutine x_parse3 (buffer, filex,
     +                     abort)
c
c action: parse buffer at DOS-type hard returns and copy to a temporary file
c author: w.g.bardsley, university of manchester, u.k., 12/12/2004
c         09/05/2010 trapped blank lines before calling x_parse1
c
c         buffer: (input/output) returned with char(13)//char(10) pairs
c                                replaced by blanks
c          filex: (output) returned as the name of a temporary file with
c                          the table after parsing with x_parse1 but with
c                          no blank lines
c          abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      character (len = *), intent (inout) :: buffer  
      character (len = *), intent (out)   :: filex
      logical,             intent (out)   :: abort
c
c locals
c
      integer    ifail, l, nout, nstart, nstop1, nstop2, numchar
      integer    x_len200
      integer    isend, nmax
      parameter (isend = 5, nmax = 10000)
      character  line*(nmax), line_end*2
      character  blank1*1, blank2*2
      parameter (blank1 = ' ', blank2 = '  ')
      external   w_gettmp, x_getnou, x_parse0, x_parse1, x_len200
      intrinsic  index, char, len
c
c check arguments
c
      abort = .true.
      l = len(filex)
      if (l.lt.12) return
      l = len(buffer)
      if (buffer(l:l).eq.char(0)) buffer(l:l) = blank1
      numchar = x_len200(buffer)
      if (numchar.lt.1) return
      line_end = char(13)//char(10)
      nstart = 1
      nstop1 = index(buffer, line_end)
      nstop2 = nstop1 + 1
      if (nstop2 - nstart + 1.gt.nmax) return
      if (nstop1.le.nstart) return
c
c open filex for output
c
      call w_gettmp (ifail, filex)
      call x_getnou (nout)
      open (unit = nout, file = filex)
c
c peel off substrings at hard returns
c
      do while (nstop1.gt.nstart .and. nstop2.le.numchar)
         buffer(nstop1:nstop2) = blank2
         line = buffer(nstart:nstop2)
         if (line.ne.blank1) then
c
c proceed to further parsing as the current line is not a blank line
c           
            call x_parse0 (line,
     +                     abort)             
            if (abort) call x_parse1 (isend,
     +                                line,
     +                                abort)
            if (abort) then
               close (unit = nout)
               return
            endif
            if (line.ne.blank1) then
               l = x_len200 (line)
               write (nout,'(a)') line(1:l)
            endif
         endif   
         nstart = nstop2 + 1
         nstop1 = index(buffer, line_end)
         nstop2 = nstop1 + 1
      enddo
c
c check remaining characters in case the data did not end with a hard return
c
      if (nstart.lt.numchar) then
         line = buffer(nstart:numchar)
         if (line.ne.blank1) then
c
c proceed to further parsing as the current line is not a blank line
c           
            call x_parse0 (line,
     +                     abort)           
            if (abort) call x_parse1 (isend,
     +                                line,
     +                                abort)
            if (.not.abort .and. line.ne.blank1) then
               l = x_len200 (line)
               write (nout,'(a)') line(1:l)
            endif
         endif   
      endif
      close (unit = nout)
      end
c
c

