c
c
      subroutine x_parse4 (number,
     +                     filex,
     +                     abort, label)
c
c action: calculate number(i) for data table in filex returned from parse3
c author: w.g.bardsley, university of manchester, u.k., 12/12/2004 
c         01/02/2007 derived from parse4 
c         14/04/2008 added label
c         30/05/2011 label is now returned .true. as long as there is as follows:
c                    1) at least 1 non-number in line 1 
c                    2) any subsequent lines can have at most 1 non-number 
c                    3) such non-numbers must be in column 1
c                    4) all lines have the same number of tokens
c                      
c
c        number: (output) as follows:
c                number(1) = number of non-blank lines in filex
c                number(2) = number of lines containing only numerical values
c                number(3) = number of lines containing only non_numerical words
c                number(4) = number of lines containing both numbers and words
c                number(5) = number of lines differing in overall token number
c                            from the previous line
c                number(6) = minimum number of numerical values in any line
c                number(7) = maximum number of numerical values in any line
c                number(8) = minimum number of tokens in any line
c                number(9) = maximum number of tokens in any line
c         filex: (input/unchanged) file with data returned from parse3
c         abort: (output) error indicator
c         label: (output) if suitable for a labels file then label is returned .true.  
c
      implicit  none
c
c arguments
c
      integer,             intent (out) :: number(9)
      character (len = *), intent (in)  :: filex
      logical,             intent (out) :: abort, label
c
c locals
c
      integer    nboth, nlines, nminv, nminw, nmaxv, nmaxw, 
     +           nvonly, nwonly, nwrong
      integer    i, ios, nout, nv, nw, nwsav
      integer    nmax
      parameter (nmax = 10000)
      character  line*(nmax)
      character  blank*1
      parameter (blank = ' ')
      external   w_getnou, x_parse2, x_parse6
c
c initialise then open the file
c
      abort = .true.
      label = .false.
      do i = 1, 9
         number(i) = 0
      enddo
      nboth = 0
      nlines = 0
      nminv = 0
      nminw = 0
      nmaxv = 0
      nmaxw = 0
      nvonly = 0
      nwonly = 0
      nwrong = 0
      call w_getnou (nout)
      open (unit = nout,file = filex, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif
c
c analyse each line
c
      do while (ios.eq.0)
         read (nout,'(a)',iostat = ios) line
         if (ios.eq.0 .and. line.ne.blank) then
            call x_parse2 (nv, nw,
     +                     line,
     +                     abort)
            if (.not.abort) then
               nlines = nlines + 1
               if (nv.eq.0) then
                  nwonly = nwonly + 1
               elseif (nv.eq.nw) then
                  nvonly = nvonly + 1
               else
                  nboth = nboth + 1
               endif
               if (nlines.eq.1) then
                  nminv = nv
                  nmaxv = nv
                  nminw = nw
                  nmaxw = nw
                  if (nw.gt.nv) then
                     label = .true.
                  else
                     label = .false.
                  endif      
               else
                  if (nv.lt.nminv) nminv = nv
                  if (nv.gt.nmaxv) nmaxv = nv
                  if (nw.lt.nminw) nminw = nw
                  if (nw.gt.nmaxw) nmaxw = nw
                  if (nw.ne.nwsav) then
                     nwrong = nwrong + 1
                     label = .false.
                  endif 
                  if (nw - nv.gt.1) label = .false.
                  if (label) then
                     if (nw - nv.eq.1) then
                        call x_parse6 (line,
     +                                 label)                        
                     elseif (nw.lt.2) then
                        label = .false.
                     endif     
                  endif  
               endif
               nwsav = nw
            endif
         endif
      enddo
      close (unit = nout)
c
c assign number(i)
c
      number(1) = nlines
      number(2) = nvonly
      number(3) = nwonly
      number(4) = nboth
      number(5) = nwrong
      number(6) = nminv
      number(7) = nmaxv
      number(8) = nminw
      number(9) = nmaxw
      if (nlines.le.1) label = .false.
      end
c
c
