c
c x_parse5
c x_packer
c x_packit
c
c
      subroutine x_parse5 (method, 
     +                     buffer, filex, title,
     +                     abort)
c
c action: Inform user then return an arbitrary file or a simfit-type file
c author: w.g.bardsley, university of manchester, u.k., 13/12/2004
c         20/01/2007 added calls to x_i1file, x_i2file, x_ymdhms and other editing 
c         01/02/2007 derived from parse5
c         28/04/2008 extensive editing and added method to the argument list
c         04/08/2022 added call to x_packer to "pre-process" and rewrite filey for simfit-type files
c
c         method = 1: all three possible Save As ... options
c                     carry on with non-numeric interior cells
c         method = 2: only one possible Save As .... option
c                     on error offer text files
c         method = 3: save silently without options 
c                     abort with non-numeric interior cells
c
c         buffer: (input/output) string, e.g. from the clipboard
c          filex: (input/unchanged) filename supplied by the user
c          abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: method 
      character (len = *), intent (in)    :: filex 
      character (len = *), intent (inout) :: buffer
      character (len = *), intent (in)    :: title
      logical,             intent (out)   :: abort
c
c allocatable
c      
      character (len = 20), allocatable :: col_lab(:), row_lab(:)
c
c locals
c
      integer    nmax
      parameter (nmax = 10000)
      integer    number(9)
      integer    i, icount, ierr, ios, isend, j, k, l, x_len200, nboth, 
     +           ncol_lab, nin, nlines, nout, nrow_lab, nvmax, nvmin,
     +           nvmp1, nvonly, nwmax, nwmin, nwonly, nwrong
      integer    nrows, ncols
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, nstart = 17)
      integer    numbld(30), numpos(10)
      character  filey*1024, line*100, mssage*100, text(30)*100
      character  strng*(nmax)
      character  cols*4, info*100, rows*8, values(9)*10, word32*32
      character  error(2)*80, word40*40
      character  blank*1, uscore*1
      parameter (blank = ' ', uscore = '_')
      logical    label, reject
      logical    ok, repeet, yesno
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    askif, there
      parameter (askif = .false.)
      external   x_parse3, x_parse4, x_putwar, x_triml1, w_lbox01,
     +           w_viewer, x_putfat, w_patch1, x_getnou, w_deleet,
     +           x_len200, x_i1file, x_i2file, x_ymdhms, x_parse7,
     +           x_yesno2
      external   x_packer
      intrinsic  len
      data       numbld / 30*0 /
      data       numpos / 10*1 /
      data       error /
     +'The data table is not rectangular and fully numerical',
     +'The table is not suitable for a data file with labels' / 
c
c check then create the temporary file filey containing the data
c
      abort = .true.
      reject = .false.
      if (method.lt.1 .or. method.gt.3) return
      if (len(buffer).lt.2) return
      call x_parse3 (buffer, filey, 
     +               abort)
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
      call x_parse4 (number,
     +               filey,
     +               abort, label)
      
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
     
c
c define counters
c
      nlines = number(1)
      nvonly = number(2)
      nwonly = number(3)
      nboth = number(4)
      nwrong = number(5)
      nvmin = number(6)
      nvmax = number(7)
      nwmin = number(8)
      nwmax = number(9)
      do i = 1, 9
         write (values(i),'(i10)') number(i)
         call x_triml1 (values(i))
      enddo
      line = 'Not assigned'
      info = 'Not assigned'
      
c
c check that the table is rectangular
c      
      if (nlines.lt.1 .or. nwrong.gt.0) then
         ok = .false.
         label = .false.
         nrows = 0
         ncols = 0
         info = blank
         write (line,100) 'not ready', 'Simfit data file'
         call x_putwar (line)
         if (method.gt.1) then
            abort = .true.
            reject = .true.
            if (method.eq.3) return
         endif   
      else
         ok = .true.   
      endif
      
c
c check for all numerical
c         
      if (ok) then
         if (nvonly.ne.nlines .or. nboth.gt.0  .or. 
     +       nvmin.ne.nvmax   .or. nwonly.gt.0) ok = .false.
      endif
      
c
c check for labels
c
      
      if (label) then
         if (nlines.lt.2 .or. nvmax.lt.1 .or.
     +       nwonly.gt.1 .or. nwmin.lt.2) label = .false. 
      endif  

      if (ok) then
         label = .false.
         nrows = nlines
         ncols = nvmin
         write (line,100) 'ready', 'Simfit file without labels'
         write (rows,'(i8)') nrows
         write (cols,'(i4)') ncols
         call x_triml1 (rows)
         call x_triml1 (cols)
         write (info,200) rows, cols
      elseif (label) then
         nrows = nlines - 1
         ncols = nvmax 
         write (line,100) 'ready', 'Simfit file with labels'
         write (rows,'(i8)') nrows
         write (cols,'(i4)') ncols
         call x_triml1 (rows)
         call x_triml1 (cols)
         write (info,200) rows, cols      
      endif

      if (method.gt.1) then
        if (.not.ok .and. .not.label) then
           if (.not.reject) then
              write (line,100) 'not ready', 'Simfit data file'
              call x_putwar (line)
           endif   
           abort = .true.
           return
        endif
      endif      
      
c
c main loop
c
      repeet = .true.
      
      if (method.eq.1) then
c
c method = 1: there will be 6 options
c        
         numopt = 6
      elseif (method.eq.2) then
c
c method = 2: there will be 4 
c        
         numopt = 4
      endif
      
      do while (repeet)
        
         write (text,300) (values(i), i = 1, 9), line, info
         
         if (method.eq.1) then
c
c method = 1: all options are available
c           
            if (ok) then
               numdec = 2
            elseif (label) then
               numdec = 3   
            else
               numdec = numopt
            endif
         elseif (method.eq.2) then  
c
c method = 2: two options are now unavailable
c           
            if (ok) then
               numdec = 2
               do i = 19, 20
                 text(i) = text(i + 2)
               enddo
            elseif (label) then
               numdec = 2
               text(18) = text(19)
               do i = 19, 20
                  text(i) = text(i + 2)
               enddo 
            elseif (reject) then
               numdec = numopt
               text(18) = text(20)
               do i = 19, 20
                  text(i) = text(i + 2)
               enddo    
            endif
         endif   
         
         if (method.eq.3) then
c
c method = 3: just save the file
c           
            if (ok) then
               numdec = 2
            else
               numdec = 3
            endif      
         else
c
c method = 1: full menu
c method = 2: truncated menu
c           
            ntext = numopt + nstart - 1
            numbld(1) = 4
            numbld(13) = 1
            numbld(15) = 1
            call w_lbox01 (icolor, ix, iy, lshade, numbld, numdec,
     +                     numopt, numpos, nstart, ntext,
     +                     text,
     +                     border, flash, high)
            numbld(1) = 0
            numbld(13) = 0
            numbld(15) = 0
            if (method.eq.2) then
               if (ok) then
                  if (numdec.gt.2) numdec = numdec + 2
               elseif (label) then
                  if (numdec.eq.2) then
                     numdec = 3
                  elseif (numdec.gt.2) then
                     numdec = numdec + 2
                  endif
               elseif (reject) then
                  if (numdec.eq.2) then
                     numdec = 4
                  elseif (numdec.gt.2) then
                     numdec = numdec + 2
                  endif             
               endif
            endif        
         endif
         
         if (numdec.eq.1) then
c
c numdec = 1: view filey
c
            isend = 1
            call w_viewer (isend,
     +                     filey, ' ', ' ')
         elseif (numdec.eq.2) then
c
c numdec = 2: create a simfit file without labels
c
            if (ok) then
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet (filey,
     +                           askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               if (method.eq.3) then
                  write (nout,'(a)',iostat=ios) title
               else   
                  write (nout,400)
               endif    
               call x_i2file (nout, nlines, nvmin)
               do while (ios.eq.0)
                  read (nin,'(a)',iostat=ios) strng
                  if (ios.eq.0) then
                     l = x_len200 (strng)
                     write (nout,'(a)',iostat=ios) strng(1:l)
                  endif
               enddo 
               i = 1
               call x_i1file (nout, i)  
               call x_ymdhms (word32)
               write (nout,'(a)',iostat=ios) word32
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call x_packer (filex)
               call w_deleet (filey,
     +                        askif, there)
            else
               call x_putfat (error(1))
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: create a simfit file with labels
c
            if (label) then
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet (filey,
     +                           askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               
               ierr = 0
               if (allocated(col_lab)) deallocate(col_lab, stat = ierr) 
               nvmp1 = max(ncols, nvmax, nwmax) + 1  
               allocate(col_lab(nvmp1), stat = ierr)  
               if (allocated(row_lab)) deallocate(row_lab, stat = ierr) 
               nrow_lab = nlines - 1
               ncol_lab = nwmax - 1  
               allocate(row_lab(nrow_lab), stat = ierr)
               
               if (method.eq.3) then
                  write (nout,'(a)',iostat=ios) title
               else   
                  write (nout,400)
               endif    
               call x_i2file (nout, nrow_lab, ncol_lab)
               
               icount = 0
               do while (ios.eq.0)
                  read (nin,'(a)',iostat=ios) strng
                  if (ios.eq.0) then
                     icount = icount + 1
                     l = x_len200 (strng)
                     if (icount.eq.1) then
                        call x_parse7 (i, nvmp1,
     +                                 col_lab, strng)
                     else 
                        call x_triml1 (strng)
                        i = index(strng,blank)
                        if (i.le.2) i = 2
                        row_lab(icount - 1) = strng(1:i - 1)                          
                        write (nout,'(a)',iostat=ios) strng(i + 1:l)
                     endif   
                  endif
               enddo 
               i = 3 + nrow_lab + ncol_lab
               call x_i1file (nout, i)  
               write (nout,'(a)') 'begin{labels}'
               do i = 1, nrow_lab
                  word40 = row_lab(i)
                  k = x_len200(word40)
                  do j = 1, k
                     if (word40(j:j).eq.uscore) word40(j:j) = blank
                  enddo       
                  write (nout,'(a)',iostat=ios) word40
               enddo
               do i = 2, ncol_lab + 1
                  word40 = col_lab(i)
                  k = x_len200(word40)
                  do j = 1, k
                     if (word40(j:j).eq.uscore) word40(j:j) = blank
                  enddo       
                  write (nout,'(a)',iostat=ios) word40
               enddo
               write (nout,'(a)') 'end{labels}'
               deallocate(col_lab, stat = ierr)
               deallocate(row_lab, stat = ierr)      
               call x_ymdhms (word32)
               write (nout,'(a)',iostat=ios) word32
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call x_packer (filex)
               call w_deleet (filey,
     +                        askif, there)
            else
               call x_putfat (error(2))
            endif            
         elseif (numdec.eq.4) then
c
c numdec = 4: create a text file
c
            write (mssage,500)
            yesno = .false.
            j = 1
            call x_yesno2 (j, ix, iy,
     +                     mssage,
     +                     yesno)
            if (yesno) then            
               call x_getnou (nin)
               open (unit = nin, file = filey, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  call w_deleet(filey,
     +                          askif, there)
                  return
               endif
               call x_getnou (nout)
               open (unit = nout, file = filex, iostat = ios)
               if (ios.ne.0) then
                  close (unit = nin)
                  close (unit = nout)
                  return
               endif
               do while (ios.eq.0)
                  read (nin,'(a)',iostat=ios) strng
                  if (ios.eq.0) then
                     l = x_len200 (strng)
                     write (nout,'(a)',iostat=ios) strng(1:l)
                  endif
               enddo
               close (unit = nin)
               close (unit = nout)
               abort = .false.
               repeet = .false.
               call w_deleet (filey,
     +                        askif, there)
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: help
c
            if (method.eq.1 .or. reject) then
               write (text,600)
            else
               write (text,700)
            endif      
            ntext = 22
            numbld(1) = 1
            numbld(9) = 1
            numbld(15) = 1
            numbld(19) = 1
            call w_patch1 (icolor, ix, iy, lshade, numbld, ntext,
     +                     text,
     +                     border)
            numbld(1) = 0
            numbld(9) = 0
            numbld(15) = 0
            numbld(19) = 0
         elseif (numdec.eq.6) then
c
c numdec = 6: cancel
c         
            abort = .true.
            repeet = .false.
            call w_deleet (filey,
     +                     askif, there)
         endif
      enddo      
c
c format statements
c      
  100 format (
     +'Data are',1x,a,' for writing to a',1x,a)
  200 format (
     +'Number of rows =',1x,a,1x,'Number of columns =',1x,a)
  300 format (
     + 'Data table formatting details'
     +/
     +/'Number of rows: in total =',1x,a
     +/'Number of rows: data-only =',1x,a
     +/'Number of rows: words-only =',1x,a
     +/'Number of rows: data/words =',1x,a
     +/'Number of rows: size-clash =',1x,a
     +/'Minimum number of values per row =',1x,a
     +/'Maximum number of values per row =',1x,a
     +/'Minimum number of columns per row =',1x,a
     +/'Maximum number of columns per row =',1x,a
     +/
     +/a
     +/
     +/a
     +/ 
     +/'View'
     +/'Use/Save as a Simfit data file (no labels)'
     +/'Use/Save as a Simfit data file (with labels)'
     +/'Use/Save as a standard text file'
     +/'Help'
     +/'Quit ... Exit clipboard data options')
  400 format ('Temporary Simfit data file')
  500 format ('The file may be edited by program Maksim',
     +', but it will not be a Simfit data file ... Proceed') 
  600 format (
     + 'Pre-processing rectangular data tables for Simfit analysis'
     +/
     +/'The current data have been edited as follows.'
     +/
     +/'1)`Lines have been broken into tokens and compressed'
     +/'2)`Any spaces in tokens have been linked by underscores'
     +/'3)`Any empty cells have been given the letter X'
     +/
     +/'Use as a Simfit data file (no labels)'
     +/'This can be done if the data table only has numerical values'
     +/'and every row has the same number of columns. A header title,'
     +/'row/column counters, and a trailer will be added to the table,' 
     +/'and the data file created will then be used for analysis.' 
     +/
     +/'Use as a Simfit data file (with labels)'
     +/'The data file will have Column 1 appended as case labels, and' 
     +/'Row 1 as variable labels, but cell(1,1) will be discarded.'
     +/
     +/'Use as a standard text file'
     +/'This option is selected for text files which are intended to be'
     +/'used by the Simfit program Maksim, which accepts tables in many'
     +/'formats in order to try to create Simfit data files.')
  700 format (
     + 'Pre-processing rectangular data tables for Simfit analysis'
     +/
     +/'The current data have been edited as follows.'
     +/
     +/'1)`Lines have been broken into tokens and compressed'
     +/'2)`Any spaces in tokens have been linked by underscores'
     +/'3)`Any empty cells have been given the letter X'
     +/
     +/'Use as a Simfit data file (no labels)'
     +/'This can be done if the data table only has numerical values'
     +/'and every row has the same number of columns. A header title,'
     +/'row/column counters, and a trailer will be added to the table,' 
     +/'and the data file created will then be used for analysis.' 
     +/
     +/'Use as a Simfit data file (with labels)'
     +/'The data file will have Column 1 appended as case labels, and' 
     +/'Row 1 as variable labels, but cell(1,1) will be discarded.'
     +/
     +/'Advice'
     +/'The data can be written to temporary files: clipboard_1.tmp,'
     +/'clipboard_2.tmp, ..., clipboard_20.tmp, in cyclical numbering,'
     +/'then analysed by Simfit, and saved for archiving.')     
      end
c
c
c
c
      subroutine x_packer (filex)
c
c action: pack data columns in filex which much be an unconnected simfit type file
c author: w.g.bardsley, university of manchester u.k., 03/08/2022
c 
c  This subroutine takes in a simfit type file and packs the data section so
c  that columns will line up and be right justified and then overwrites the 
c  input file so filex must not be read-only.      
c
      character (len = *), intent (in) :: filex        
      integer    i, ios, ncol, nrow
      integer    nin, nrmax, ntrail
      parameter (nin = 3, nrmax = 2000)
      integer    nfield(nrmax)
      character (len = 1024) strng
      character (len = 1024) matrix(nrmax)
      character (len = 120 ) header(2), line, trailer(100)
      character (len = 12  ) x_form12, word12
      logical    ex, op
      external   x_form12, x_packit, x_putadv
      intrinsic  trim
      inquire (file = filex, exist = ex, opened = op)
      if (op .or. .not.ex) then
          write (line,100) 
          call x_putadv (line)
          return
      endif    
      open (unit = nin, file = filex, iostat = ios)
      if (ios.eq.0) read (nin,'(a)',iostat=ios) header(1)
      if (ios.eq.0) read (nin,'(a)',iostat=ios) header(2)
      if (ios.eq.0) read (header(2),*,iostat=ios) nrow, ncol
      do i = 1, nrow
         if (ios.eq.0) read (nin,'(a)',iostat=ios) matrix(i)
      enddo
      ntrail = 0
      do while (ios.eq.0)
         read (nin,'(a)',iostat=ios) line
         if (ios.eq.0) then
            ntrail = ntrail + 1
            trailer(ntrail) = line
         endif
      enddo      
      call x_packit (ncol, nfield, nrmax, nrow,
     +                    matrix, strng)
      rewind (unit = nin, iostat = ios)
      do i = 1, 2
         if (ios.eq.0) write (nin,'(a)',iostat=ios) header(i)
      enddo
      do i = 1, nrow
         if (ios.eq.0) write (nin,'(a)',iostat=ios) matrix(i)
      enddo
      do i = 1, ntrail
         if (ios.eq.0) write (nin,'(a)',iostat=ios) trailer(i)
      enddo
c
c check iostat
c      
      if (ios.ne.0) then
         word12 = x_form12(ios)
         write (line,200) trim(word12)
        call x_putadv (line)
      endif 
      close (unit = nin, iostat = ios) 
  100 format (
     +'File cannot be opened in subroutine X_PACKER')  
  200 format (
     +'IOSTAT =',1X,A,', read/write error in subroutine X_PACKER')        
      end 
c
c 
C
C Subroutine PACKIT moved from MAKSIM for general use
C
      SUBROUTINE X_PACKIT (NCOLS, NFIELD, NRMAX, NROWS,
     +                     MATRIX, STRNG)
C
C ACTION : Pack the matrix
C          23/11/1997 replaced LEN200, TRIML1, TRIMR1 by LENG, TRIM@, TRIMR@
C                     as there seemed to be a problem calling my own indirect functions
C                     This is almost certainly a ftn95 problem and my own indirect
C                     calls will probably work OK when ftn95 has stabilised
C          15/04/2008 restored my procedures as the problem was LEN200(STRNG) 
C                     being used as a loop counter which was fixed 
C                     This routine is hopelessly overcomplicated and must be
C                     rewritten as soon as possible, then moved to w_menus.dll
C                     as a general purposes packing routine. 
C          28/07/2008 moved to w_menus.dll but not revised because it is still
C                     called with a variety of possible parsing schemes. I should
C                     firm up on just one scheme eventually which would greatly
C                     simplify and speed up the code.
C          03/08/2022 repaired a long-standing error (line 118) and checked  
C
C Note: this routine is over complicated because it has to be able to work with
C       a variety of possible schemes for parsing between different delimiters 
C       The input matrix must have exactly NCOLS rows and NROWS rows and all
C       labels must be free from internal blanks and have quotes stripped off. 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCOLS, NRMAX, NROWS
      INTEGER,             INTENT (INOUT) :: NFIELD(NCOLS)
      CHARACTER (LEN = *), INTENT (INOUT) :: MATRIX(NRMAX), STRNG
C
C Locals
C      
      INTEGER    I, J, K, L, L200, M, N
      INTEGER    X_LEN200
      INTEGER    KMAX
      PARAMETER (KMAX = 20)
      CHARACTER  LETTER*1
      CHARACTER  BLANK*1, COMMA*1, COMMA2*2
      PARAMETER (BLANK = ' ', COMMA = ',', COMMA2 = ',,')
      EXTERNAL   X_TRIML1, X_LEN200, X_TRIMR1
      INTRINSIC  INDEX
C
C============================================================================================
C LOOP 1: Remove commas, replace by spaces, replace, strip multiple commas, trucate if > NMAX
C============================================================================================
C
      DO I = 1, NROWS
C
C Copy MATRIX(i) into STRNG then set MATRIX(I) = BLANK
C        
         STRNG = MATRIX(I)
         MATRIX(I) = BLANK
C
C Now remove all trailing multiple commas a,b,c,,, to a,b,c
C
         L200 = X_LEN200(STRNG) 
         DO J = L200, 1, - 1
            IF (STRNG(J:J).EQ.COMMA) THEN
               STRNG(J:J) = BLANK
            ELSE
               EXIT
            ENDIF
         ENDDO
C
C Replace all leading multiple commas ,,,a,b,c to a,b,c
C
          DO J = 1, L200
            IF (STRNG(J:J).EQ.COMMA) THEN
               STRNG(J:J) = BLANK
            ELSE
               EXIT
            ENDIF
         ENDDO
         CALL X_TRIML1 (STRNG)
C
C Go through the string and replace all internal blanks by commas
C
         L200 = X_LEN200(STRNG)
         DO J = 1, L200
            IF (STRNG(J:J).EQ.BLANK) STRNG(J:J) = COMMA
         ENDDO
C
C Strip out multiple commas 
C
         L = INDEX(STRNG,COMMA2)
         DO WHILE (L.GT.0)
            DO J = L, L200 - 1
               STRNG(J:J) = STRNG(J + 1:J + 1)
            ENDDO   
            STRNG(L200:L200) = BLANK
            L200 = L200 - 1
            L = INDEX(STRNG,COMMA2)!03/08/2022 ERROR repaired: replaced COMMA by COMMA2 
         ENDDO
         
C
C Re-write MATRIX(I) but truncating labels if > KMAX
C 

         K = 0
         L  = 0
         DO J = 1, L200
            LETTER = STRNG(J:J)
            IF (LETTER.EQ.COMMA) THEN
               K = 0
               L = L + 1
               MATRIX(I)(L:L) = LETTER
            ELSEIF (LETTER.NE.BLANK) THEN
               K = K + 1
               IF (K.LE.KMAX) THEN
                  L = L + 1
                  MATRIX(I)(L:L) = LETTER
               ENDIF
            ENDIF         
         ENDDO
         L = L + 1
         MATRIX(I)(L:L) = COMMA
      ENDDO   
C
C============================================================================================
C LOOP 2: define NFIELD
C         At this stage the items are separated by commas with no blanks
C         but an extra COMMA has been added to the end
C============================================================================================
C
      DO I = 1, NCOLS
         NFIELD(I) = 0
      ENDDO
      DO I = 1, NROWS
         K = 0
         L = 0
         L200 = X_LEN200(MATRIX(I))
         DO J = 1, L200
            IF (MATRIX(I)(J:J).NE.COMMA) THEN
               K = K + 1
            ELSE
               L = L + 1
               IF (K.GT.NFIELD(L)) NFIELD(L) = K    
               K = 0
            ENDIF
         ENDDO
         MATRIX(I)(L200:L200) = BLANK
      ENDDO
C
C============================================================================================
C LOOP 3:  Now NFIELD are the maximum field widths and the final COMMAS are removed
C          so the string must be packed out to constant field width
C============================================================================================
C
      DO I = 1, NROWS
         STRNG = MATRIX(I)
         MATRIX(I) = BLANK
         K = 0
         L = 0
         M = 0
         L200 = X_LEN200(STRNG) 
         DO J = 1, L200
            IF (STRNG(J:J).NE.COMMA) THEN
               K = K + 1
               L = L + 1
               MATRIX(I)(K:K) = STRNG(J:J)
            ELSE
               M = M + 1
               IF (L.LT.NFIELD(M)) THEN
                  DO N = 1, NFIELD(M) - L
                     K = K + 1
                     MATRIX(I)(K:K) = BLANK
                  ENDDO
               ENDIF
               K = K + 1
               MATRIX(I)(K:K) = BLANK
               L = 0
            ENDIF
         ENDDO
      ENDDO
C
C============================================================================================
C LOOP 4: Code added 22/11/97 to right justify
C============================================================================================
C
      DO I = 1, NROWS
         K = 1
         L = NFIELD(1)
         IF (L.GT.1) CALL X_TRIMR1 (MATRIX(I)(K:L))
         DO J = 2, NCOLS
            K = L + 2
            L = K + NFIELD(J) - 1
            IF (L.GT.K) CALL X_TRIMR1 (MATRIX(I)(K:L))
         ENDDO
      ENDDO
C
C Now all columns are right justified
C
      END
C
C
   

