c
c
      subroutine x_parse8 (buffer, 
     +                     abort)
c
c action: check that buffer can generate a simfit data file in x_parse5
c author: w.g.bardsley, university of manchester, u.k.
c         29/04/2008 derived from x_parse5
c
c         buffer: (input/output) string, e.g. from the clipboard
c          abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      character (len = *), intent (inout) :: buffer
      logical,             intent (out)   :: abort
c
c locals
c
      integer    nlines, nvonly, nwonly, nboth, nwrong, nvmin, nvmax,
     +           nwmin, number(9)
      character  filey*1024
      logical    ok, label
      logical    askif, there
      parameter (askif = .false.)
      external   x_parse3, x_parse4, w_deleet
      intrinsic  len
c
c check then create the temporary file filey containing the data
c
      abort = .true.
      if (len(buffer).lt.2) return
      call x_parse3 (buffer, filey, 
     +               abort)
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
      call x_parse4 (number,
     +               filey,
     +               abort, label)
      
      if (abort) then
         call w_deleet (filey,
     +                  askif, there)
         return
      endif
c
c define counters
c
      nlines = number(1)
      nvonly = number(2)
      nwonly = number(3)
      nboth = number(4)
      nwrong = number(5)
      nvmin = number(6)
      nvmax = number(7)
      nwmin = number(8)
      
c
c check that the table is rectangular
c      
      if (nlines.lt.1 .or. nwrong.gt.0) then
        call w_deleet (filey,
     +                  askif, there)        
         abort = .true.
         return
      else
         ok = .true.   
      endif
      
c
c check for all numerical
c         
      if (ok) then
         if (nvonly.ne.nlines .or. nboth.gt.0  .or. 
     +       nvmin.ne.nvmax   .or. nwonly.gt.0) ok = .false.
      endif
      
c
c check for labels
c
      
      if (label) then
         if (nlines.lt.2 .or. nvmax.lt.1 .or.
     +       nwonly.gt.1 .or. nwmin.lt.2) label = .false. 
      endif  

      if (ok .or. label) then
         abort = .false.
      else
         abort = .true.
      endif
      call w_deleet (filey,
     +               askif, there)
      end
c
c