C
C
      SUBROUTINE X_PLOTYN (ISEND, L, M, N,
     +                     FILES,
     +                     BARCAP, LOWER, UPPER)
C
C ACTION: Plot-yes-no, edit plot/suppress status for files
C AUTHOR: w.g.bardsley, university of manchester, u.k., 09/05/2004 
C         22/04/2007 added INTENTS
C         19/09/2011 derived from PLOTYN$
C
C         ISEND: (input/unchanged) 1 = initialise, 2 = change
C             L: (input/output) line type
C             M: (input/output) marker type
C             N: (input/unchanged) number of files >= 1
C         FILES: (input/unchanged) graph coordinate files
c        BARCAP: (input/output) plot error bars yes/no
c         LOWER: (input/output) plot lower barcaps yes/no
c         UPPER: (input/output) plot upper barcaps yes/no
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ISEND, N
      INTEGER,             INTENT (INOUT) :: L(N), M(N)
      CHARACTER (LEN = *), INTENT (IN)    :: FILES(N)
      LOGICAL,             INTENT (INOUT) :: BARCAP(N), LOWER(N),
     +                                       UPPER(N)
C
C Locals
C
      INTEGER    NMAX, N0, N1, N2
      PARAMETER (NMAX = 300, N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, K, L_1(NMAX), M_1(NMAX)
      CHARACTER  TEXT(NMAX)*(80), TITLE*80, X_TRIM60*60
      CHARACTER  LINE*100
      CHARACTER  DOT*1
      PARAMETER (DOT = '.')
      LOGICAL    BARCAP_1(NMAX), LOWER_1(NMAX), UPPER_1(NMAX),
     +           USEIT(NMAX)
      LOGICAL    BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART, STORE,
     +           TWO_PLOTS, VECTOR_FIELD
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   X_TRIM60, W_CHKBOX, X_PUTADV, SAVE11$
      SAVE       L_1, M_1, BARCAP_1, LOWER_1, UPPER_1, USEIT
      DATA       L_1, M_1 / NMAX*1, NMAX*1 /
      DATA       BARCAP_1, LOWER_1, UPPER_1, USEIT / NMAX*.TRUE. ,
     +           NMAX*.TRUE., NMAX*.TRUE., NMAX*.TRUE. /
C
C Check ISEND and N
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2 .OR. N.LT.N1) RETURN
      IF (ISEND.EQ.N1) THEN
C
C Initialise saved parameters
C
         DO I = N1, NMAX
            L_1(I) = N1
            M_1(I) = N1
            BARCAP_1(I) = .TRUE.
            LOWER_1(I) = .TRUE.
            UPPER_1(I) = .TRUE.
            USEIT(I) = .TRUE.
         ENDDO
C
C Make sure we do not have any non plotted data i.e. L(i) = M(i) = 0
C With bar charts we must re-set L(1) = M(1) = 0 after this call
C
         DO I = N1, N
            IF (L(I).EQ.N0 .AND. M(I).EQ.N0) M(I) = N1
         ENDDO
      ELSEIF (ISEND.EQ.N2) THEN
C
C Check if more than 1 file
C
         IF (N.EQ.N1) THEN
            USEIT(1) = .TRUE.
            WRITE (LINE,200)
            CALL X_PUTADV (LINE)
         ELSE
C
C Edit saved parameters: 1. Store but only if in use
C
            DO I = N1, N
               IF (USEIT(I)) THEN
                  L_1(I) = L(I)
                  M_1(I) = M(I)
                  BARCAP_1(I) = BARCAP(I)
                  LOWER_1(I) = LOWER(I)
                  UPPER_1(I) = UPPER(I)
               ENDIF
            ENDDO
C
C Edit saved parameters: 2. Call CHKBOX
C
            WRITE (TITLE,100)
            DO I = N1, N
               WRITE (TEXT(I),300) I, DOT, X_TRIM60(FILES(I))
            ENDDO
            CALL W_CHKBOX (N,
     +                     TEXT, TITLE,
     +                     USEIT)
C
C Edit saved parameters: 3. Special action if USEIT(1) = .FALSE.
C
            IF (.NOT.USEIT(1)) THEN
               CALL SAVE11$(BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART,
     +                      STORE, TWO_PLOTS, VECTOR_FIELD)
               IF (BAR_CHART .OR. BI_PLOT .OR. DENDRO_GRAM .OR.
     +             PIE_CHART .OR. VECTOR_FIELD) THEN
                  USEIT(1) = .TRUE.
                  WRITE (LINE,400)
                  CALL X_PUTADV (LINE)
               ENDIF
            ENDIF
C
C Edit saved parameters: 4. Restore active files or suppress
C
            DO I = N1, N
               IF (USEIT(I)) THEN
                  L(I) = L_1(I)
                  M(I) = M_1(I)
                  BARCAP(I) = BARCAP_1(I)
                  LOWER(I) = LOWER_1(I)
                  UPPER(I) = UPPER_1(I)
                  IF (L(I).EQ.N0 .AND. M(I).EQ.N0) THEN
                     L(I) = N1
                     M(I) = N1
                  ENDIF
               ELSE
                  L(I) = N0
                  M(I) = N0
                  BARCAP(I) = .FALSE.
                  LOWER(I) = .FALSE.
                  UPPER(I) = .FALSE.
               ENDIF
            ENDDO
C
C Edit saved parameters: 5 Make sure at least one file is active
C
            K = N0
            DO I = N1, N
               IF (USEIT(I)) K = K + N1
            ENDDO
            IF (K.EQ.N0) THEN
               USEIT(1) = .TRUE.
               L(1) = L_1(1)
               M(1) = M_1(1)
               BARCAP(1) = BARCAP_1(1)
               LOWER(1) = LOWER_1(1)
               UPPER(1) = UPPER_1(1)
               IF (L(1).EQ.N0 .AND. M(1).EQ.N0) THEN
                  L(1) = N1
                  M(1) = N1
               ENDIF
               WRITE (LINE,500)
               CALL X_PUTADV (LINE)
            ENDIF
         ENDIF
      ENDIF
C
C Format statements
C      
  100 FORMAT ('Tick to plot the file or un-tick to suppress the file')
  200 FORMAT ('Cannot suppress/restore if there is only 1 data file')
  300 FORMAT (I4,A1,1X,A)
  400 FORMAT ('File 1 must be plotted for this type of graph')
  500 FORMAT ('Must plot from at least 1 file: data set 1 is restored')
      END
C
C
