c
c
      subroutine x_repair (isend,
     +                     cval3,
     +                     abort)  
c
c action: universal version of x_repair (32-bit and/or 64-bit)  
c author: w.g.bardsley, university of manchester, u.k, 25/02/2017 
c     
      implicit none
c
c arguments
c             
      integer,             intent (in)    :: isend  
      character (len = *), intent (inout) :: cval3
      logical,             intent (out)   :: abort 
c
c locals
c 
      logical isit64, os64
      external x64_repair, x32_repair, isit64
      os64 = isit64()
      if (os64) then
        call x64_repair (isend,
     +                   cval3,
     +                   abort)
      else
         call x32_repair (isend,
     +                    cval3,
     +                    abort)
      endif
      end
c
c-----------------------------------------------------------------------
c
      subroutine x64_repair (isend,
     +                       cval3,
     +                       abort)
c
c action: check/repair the configuration option cval(3)
c author: w.g.bardsley, university of manchester, u.k., 04/09/2012
c         15/12/2012 added checks for x64_simfit and x64_simdem
c         20/12/2012 deleted checks for x64_simfit and x64_simdem 
c         01/02/2013 added ncfg to limit the text read from w_simfit.cfg
c         13/04/2013 increased system_path to (len = 8192)
c
c isend: isend = 0: check cval3 supplied 
c        isend = 1: check the existing w_simfit.cfg file if any
c        isend = 2: search the %PROGRAMFILES% files trees
c        isend = 3: search the system paths
c        isend = 4: write cval3 supplied to the config file
c cval3: isend = 0: cval3   is (input/unchanged) for checking
c        isend = 1: cval(3) returned from w_simfit.cfg
c        isend = 2: cval(3) returned from %PROGRAMFILES% tree
c        isend = 3: cval(3) returned from system PATH
c        isend = 4: cval3   is (input/unchanged) for writing to file
c abort: abort = .false. action succeeded
c        abort = .true.  action failed
c
c Typical use would be checking for a possible repair as follows:
c                            call with isend = 1
c         if abort = .false. no further action required
c         if abort = .true.  call with isend = 2
c         if abort = .true.  call with isend = 3
c         if abort = .false. call with isend = 4
c                         
c                     
c      
      implicit none
c
c arguments
c    
      integer,             intent (in)    :: isend  
      character (len = *), intent (inout) :: cval3
      logical,             intent (out)   :: abort 
c
c locals
c      
      integer    i, ios, j, k, nout
      integer    ncfg
      parameter (ncfg = 49)
      character (len = 1024) cfgfile, path, full_path, temp
      character (len = 1024) text(ncfg)
      character (len = 8192) system_path, w_getenv
      character (len = 12  ) word12
      character (len = 11  ) word11
      character (len = 5   ) word5
      character (len = 4   ) word4
      character (len = 1   ) bslash
      parameter (bslash = '\')
      logical    op, there
      external   w_v7path, w_getnou, x_lcase1, w_getenv
      intrinsic  index
      
c
c initialise abort = .true.
c      
      abort = .true.

      if (isend.eq.0) then
c
c isend = 0: check that cval3 supplied is of the form 
c ---------- ...\simfit\bin  
c            ...\simfit\bin\
c            ...\simdem\bin or
c            ...\simdem\bin\ and points to a valid executable such as
c            ...\simfit\bin\x64_simfit.exe or
c            ...\simdem\bin\x64_simdem.exe 
c            If so return abort = .false. but do not change cval3  
c      
         path = cval3
         k = len_trim(path)
         if (k.lt.11) return
         call x_lcase1(path)
         word4 = path(k - 3:k)
         word5 = path(k - 4:k) 
         
         if (word4.ne.'\bin' .and.
     +       word5.ne.'\bin\') return
     
         word11 = path(k - 10:k)
         if (word11.ne.'\simfit\bin'  .and.
     +       word11.ne.'\simdem\bin') then
            if (k.lt.12) return 
            word12 = path(k - 11:k)
            if (word12.ne.'\simfit\bin\' .and.
     +          word12.ne.'\simdem\bin\') return
         endif
         
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         
         full_path = path(1:k)//'x64_simfit.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. there) then
            abort = .false.
            return
         endif
         
         full_path = path(1:k)//'x64_simdem.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. there) then
            abort = .false.
            return
         endif
         
      elseif (isend.eq.1) then
c
c isend = 1: examine and check cval(3) in any existing configuration file
c ----------
c      
         call w_v7path (k,
     +                  'cfg', path)
         if (k.lt.1) return
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         cfgfile = path(1:k)//'w_simfit.cfg'
         inquire (file = cfgfile, exist = there, opened = op, 
     +            iostat = ios) 
         if (ios.ne.0   .or. 
     +       .not.there .or.
     +      (there.and.op)) return
c
c the cfgfile has been located so get cval(3)
c        
         call w_getnou (nout)
         open (unit = nout, file = cfgfile, iostat = ios)
         if (ios.ne.0) then
            close (unit = nout)
            return
         else   
            do i = 1, 15 
               if (ios.eq.0) read (nout,'(a)',iostat=ios) temp
            enddo
            close (unit = nout)
            if (ios.ne.0) return
         endif   
c
c check that cval(3) ends in '\simfit\bin' or '\simdem\bin'
c      
         k = len_trim(temp)
         if (k.lt.11) return
         word11 = temp(k - 10:k)
         call x_lcase1 (word11)
         
         if (word11.eq.'\simfit\bin') then
            full_path = temp(1:k)//'\x64_simfit.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
                cval3 = temp(1:k)
                abort = .false.
                return
            endif    
         endif
         
         if (word11.eq.'\simdem\bin') then
            full_path = temp(1:k)//'\x64_simdem.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif
         endif
         
         if (k.lt.12) return
           
         word12 = temp(k - 11:k)
         call x_lcase1 (word12)
         if (word12.eq.'\simfit\bin\') then
            full_path = temp(1:k)//'x64_simfit.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif
         endif
         
         if (word12.eq.'\simdem\bin\') then
            full_path = temp(1:k)//'x64_simdem.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif   
         endif   
         
      elseif (isend.eq.2) then
c
c isend = 2: try searching the standard program files
c ----------
c
         call w_v7path (k,
     +                  'p64', path)
     
         full_path = path(1:k)//'\simfit\bin\x64_simfit.exe' 
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 11)
            abort = .false.
            return
         endif
         
         full_path = path(1:k)//'\simdem\bin\x64_simdem.exe' 
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 11)
            abort = .false.
            return
         endif

          call w_v7path (k,
     +                  'p32', path)
         
         full_path = path(1:k)//'\silverfrost\simdem\bin\simdem.exe'
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 23)
            abort = .false.
            return
         endif
        
      elseif (isend.eq.3) then
c
c isend = 3: try searching the system path
c ----------
c
         system_path = w_getenv('PATH')
         call x_lcase1 (system_path)
         k = index(system_path,'\silverfrost')
         if (k.gt.2) then
            j = k
            do i = 1, k
               j = j - 1
               if (system_path(j:j).eq.';') exit
            enddo
            full_path = system_path(j+1:k+11)//'\simdem\bin\simdem.exe'  
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               k = len_trim(full_path)
               cval3 = full_path(1:k - 11)
               abort = .false.
               return
            endif   
         endif   
       
         k = index(system_path,'\nagfor')
         if (k.gt.2) then
            j = k
            do i = 1, k
               j = j - 1
               if (system_path(j:j).eq.';') exit
            enddo
            full_path = system_path(j+1:k-1)//'\simdem\bin\simdem.exe'  
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               k = len_trim(full_path)
               cval3 = full_path(1:k - 11)
               abort = .false.
              return
            endif
         endif         

c
c isend = 4: write to file if acceptable
c ----------
c    
      elseif (isend.eq.4) then
         call w_v7path (k,
     +                  'cfg', path)
         if (k.lt.1) return
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif     
         cfgfile = path(1:k)//'w_simfit.cfg'
         inquire (file = cfgfile, exist = there, opened = op, 
     +            iostat = ios) 
         if (ios.ne.0   .or. 
     +       .not.there .or.
     +      (there.and.op)) return
         path = cval3
         k = len_trim(path)
         if (k.lt.11) return
         call x_lcase1(path)
         word4 = path(k - 3:k)
         word5 = path(k - 4:k)
         
         if (word4.ne.'\bin' .and.
     +       word5.ne.'\bin\') return
     
         word11 = path(k - 10:k)
         if (word11.ne.'\simfit\bin' .and.
     +       word11.ne.'\simdem\bin') then
             if (k.lt.12) return
             word12 = path(k - 11:k)
             if (word12.ne.'\simfit\bin\' .and.
     +           word12.ne.'\simdem\bin\') return
         endif
         
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         
         full_path = path(1:k)//'x64_simfit.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. .not.there) then
            full_path = path(1:k)//'x64_simdem.exe'
            inquire (file = full_path, iostat = ios, exist = there)
         endif
                          
         if (ios.eq.0 .and. .not.there) return
c
c write to file
c        
         call w_getnou (nout)
         open (unit = nout, file = cfgfile, iostat = ios)
         if (ios.eq.0) then
            j = 0 
            do while (ios.eq.0 .and. j.lt.ncfg)
               read (nout,'(a)',iostat=ios) temp
               if (ios.eq.0) then
                 j = j + 1
                 text(j) = temp
               endif  
            enddo
            close (unit = nout)
            if (j.eq.ncfg .or. j.eq.ncfg - 1) then
               text(15) = cval3
               call w_getnou (nout)
               open (unit = nout, file = cfgfile, iostat = ios)
               ios = 0
               do i = 1, j
                  if (ios.eq.0) write (nout,'(a)',iostat=ios) text(i)
               enddo
               close (unit = nout)
               abort = .false.
            endif   
         endif
      endif     
      end
c 
c----------------------------------------------------------------------
c
      subroutine x32_repair (isend,
     +                       cval3,
     +                       abort)
c
c action: check/repair the configuration option cval(3)
c author: w.g.bardsley, university of manchester, u.k., 04/09/2012
c         15/12/2012 added checks for x64_simfit and x64_simdem
c         20/12/2012 deleted checks for x64_simfit and x64_simdem 
c         01/02/2013 added ncfg to limit the text read from w_simfit.cfg
c         13/04/2013 increased system_path to (len = 8192)
c
c isend: isend = 0: check cval3 supplied 
c        isend = 1: check the existing w_simfit.cfg file if any
c        isend = 2: search the %PROGRAMFILES% files trees
c        isend = 3: search the system paths
c        isend = 4: write cval3 supplied to the config file
c cval3: isend = 0: cval3   is (input/unchanged) for checking
c        isend = 1: cval(3) returned from w_simfit.cfg
c        isend = 2: cval(3) returned from %PROGRAMFILES% tree
c        isend = 3: cval(3) returned from system PATH
c        isend = 4: cval3   is (input/unchanged) for writing to file
c abort: abort = .false. action succeeded
c        abort = .true.  action failed
c
c Typical use would be checking for a possible repair as follows:
c                            call with isend = 1
c         if abort = .false. no further action required
c         if abort = .true.  call with isend = 2
c         if abort = .true.  call with isend = 3
c         if abort = .false. call with isend = 4
c                         
c                     
c      
      implicit none
c
c arguments
c    
      integer,             intent (in)    :: isend  
      character (len = *), intent (inout) :: cval3
      logical,             intent (out)   :: abort 
c
c locals
c      
      integer    i, ios, j, k, nout
      integer    ncfg
      parameter (ncfg = 49)
      character (len = 1024) cfgfile, path, full_path, temp
      character (len = 1024) text(ncfg)
      character (len = 8192) system_path, w_getenv
      character (len = 12  ) word12
      character (len = 11  ) word11
      character (len = 5   ) word5
      character (len = 4   ) word4
      character (len = 1   ) bslash
      parameter (bslash = '\')
      logical    op, there
      external   w_v7path, w_getnou, x_lcase1, w_getenv
      intrinsic  index
      
c
c initialise abort = .true.
c      
      abort = .true.

      if (isend.eq.0) then
c
c isend = 0: check that cval3 supplied is of the form 
c ---------- ...\simfit\bin  
c            ...\simfit\bin\
c            ...\simdem\bin or
c            ...\simdem\bin\ and points to a valid executable such as
c            ...\simfit\bin\w_simfit.exe or
c            ...\simdem\bin\simdem.exe 
c            If so return abort = .false. but do not change cval3  
c      
         path = cval3
         k = len_trim(path)
         if (k.lt.11) return
         call x_lcase1(path)
         word4 = path(k - 3:k)
         word5 = path(k - 4:k) 
         
         if (word4.ne.'\bin' .and.
     +       word5.ne.'\bin\') return
     
         word11 = path(k - 10:k)
         if (word11.ne.'\simfit\bin'  .and.
     +       word11.ne.'\simdem\bin') then
            if (k.lt.12) return 
            word12 = path(k - 11:k)
            if (word12.ne.'\simfit\bin\' .and.
     +          word12.ne.'\simdem\bin\') return
         endif
         
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         
         full_path = path(1:k)//'w_simfit.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. there) then
            abort = .false.
            return
         endif
         
         full_path = path(1:k)//'simdem.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. there) then
            abort = .false.
            return
         endif
         
      elseif (isend.eq.1) then
c
c isend = 1: examine and check cval(3) in any existing configuration file
c ----------
c      
         call w_v7path (k,
     +                  'cfg', path)
         if (k.lt.1) return
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         cfgfile = path(1:k)//'w_simfit.cfg'
         inquire (file = cfgfile, exist = there, opened = op, 
     +            iostat = ios) 
         if (ios.ne.0   .or. 
     +       .not.there .or.
     +      (there.and.op)) return
c
c the cfgfile has been located so get cval(3)
c        
         call w_getnou (nout)
         open (unit = nout, file = cfgfile, iostat = ios)
         if (ios.ne.0) then
            close (unit = nout)
            return
         else   
            do i = 1, 15 
               if (ios.eq.0) read (nout,'(a)',iostat=ios) temp
            enddo
            close (unit = nout)
            if (ios.ne.0) return
         endif   
c
c check that cval(3) ends in '\simfit\bin' or '\simdem\bin'
c      
         k = len_trim(temp)
         if (k.lt.11) return
         word11 = temp(k - 10:k)
         call x_lcase1 (word11)
         
         if (word11.eq.'\simfit\bin') then
            full_path = temp(1:k)//'\w_simfit.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
                cval3 = temp(1:k)
                abort = .false.
                return
            endif    
         endif
         
         if (word11.eq.'\simdem\bin') then
            full_path = temp(1:k)//'\simdem.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif
         endif
         
         if (k.lt.12) return
           
         word12 = temp(k - 11:k)
         call x_lcase1 (word12)
         if (word12.eq.'\simfit\bin\') then
            full_path = temp(1:k)//'w_simfit.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif
         endif
         
         if (word12.eq.'\simdem\bin\') then
            full_path = temp(1:k)//'simdem.exe'
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               cval3 = temp(1:k)
               abort = .false.
               return
            endif   
         endif   
         
      elseif (isend.eq.2) then
c
c isend = 2: try seaching the standard program files
c ----------
c
         call w_v7path (k,
     +                  'p32', path)
     
         full_path = path(1:k)//'\simfit\bin\w_simfit.exe' 
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 11)
            abort = .false.
            return
         endif
         
         full_path = path(1:k)//'\simdem\bin\simdem.exe' 
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 11)
            abort = .false.
            return
         endif
         
         full_path = path(1:k)//'\silverfrost\simdem\bin\simdem.exe'
         inquire (file = full_path, exist = there, iostat = ios)
         if (ios.eq.0 .and. there) then
            cval3 = full_path(1:k + 23)
            abort = .false.
            return
         endif
        
      elseif (isend.eq.3) then
c
c isend = 3: try searching the system path
c ----------
c
         system_path = w_getenv('PATH')
         call x_lcase1 (system_path)
         k = index(system_path,'\silverfrost')
         if (k.gt.2) then
            j = k
            do i = 1, k
               j = j - 1
               if (system_path(j:j).eq.';') exit
            enddo
            full_path = system_path(j+1:k+11)//'\simdem\bin\simdem.exe'  
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               k = len_trim(full_path)
               cval3 = full_path(1:k - 11)
               abort = .false.
               return
            endif   
         endif   
       
         k = index(system_path,'\nagfor')
         if (k.gt.2) then
            j = k
            do i = 1, k
               j = j - 1
               if (system_path(j:j).eq.';') exit
            enddo
            full_path = system_path(j+1:k-1)//'\simdem\bin\simdem.exe'  
            inquire (file = full_path, exist = there, iostat = ios)
            if (ios.eq.0 .and. there) then
               k = len_trim(full_path)
               cval3 = full_path(1:k - 11)
               abort = .false.
              return
            endif
         endif         

c
c isend = 4: write to file if acceptable
c ----------
c    
      elseif (isend.eq.4) then
         call w_v7path (k,
     +                  'cfg', path)
         if (k.lt.1) return
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif     
         cfgfile = path(1:k)//'w_simfit.cfg'
         inquire (file = cfgfile, exist = there, opened = op, 
     +            iostat = ios) 
         if (ios.ne.0   .or. 
     +       .not.there .or.
     +      (there.and.op)) return
         path = cval3
         k = len_trim(path)
         if (k.lt.11) return
         call x_lcase1(path)
         word4 = path(k - 3:k)
         word5 = path(k - 4:k)
         
         if (word4.ne.'\bin' .and.
     +       word5.ne.'\bin\') return
     
         word11 = path(k - 10:k)
         if (word11.ne.'\simfit\bin' .and.
     +       word11.ne.'\simdem\bin') then
             if (k.lt.12) return
             word12 = path(k - 11:k)
             if (word12.ne.'\simfit\bin\' .and.
     +           word12.ne.'\simdem\bin\') return
         endif
         
         if (path(k:k).ne.bslash) then
            k = k + 1
            path(k:k) = bslash
         endif
         
         full_path = path(1:k)//'w_simfit.exe'
         inquire (file = full_path, iostat = ios, exist = there)
         if (ios.eq.0 .and. .not.there) then
            full_path = path(1:k)//'simdem.exe'
            inquire (file = full_path, iostat = ios, exist = there)
         endif
                          
         if (ios.eq.0 .and. .not.there) return
c
c write to file
c        
         call w_getnou (nout)
         open (unit = nout, file = cfgfile, iostat = ios)
         if (ios.eq.0) then
            j = 0 
            do while (ios.eq.0 .and. j.lt.ncfg)
               read (nout,'(a)',iostat=ios) temp
               if (ios.eq.0) then
                 j = j + 1
                 text(j) = temp
               endif  
            enddo
            close (unit = nout)
            if (j.eq.ncfg .or. j.eq.ncfg - 1) then
               text(15) = cval3
               call w_getnou (nout)
               open (unit = nout, file = cfgfile, iostat = ios)
               ios = 0
               do i = 1, j
                  if (ios.eq.0) write (nout,'(a)',iostat=ios) text(i)
               enddo
               close (unit = nout)
               abort = .false.
            endif   
         endif
      endif     
      end
c
c           