c
c
      subroutine x_resdef (itype)
c
c action: restore plotting defaults
c author: w.g.bardsley, university of manchester, u.k., 30/07/2009
c         31/12/2010 added calls to w_symbol, w_labels, and defkey
c                    and allowed itype to be 0 to 4
c         14/02/2011 now installs simfit defaults
c         23/04/2011 increased dimension to 20 in call to w_labels
c         06/09/2011 corrected error caused by setting second title to word80
c         05/11/2011 added restoring of nsteps (nsteps_max must agree with x_savall)
c         20/01/2013 called x_nsteps and x_fsizes to restore defaults
c
c This version makes sure all the plotting parameters are intialised
c and also restores plot style parameters to those set by gstyle$ and
c stored in w_graphs.cfg.
c
c itype = 0: menu
c itype = 1: restore simple graphics
c itype = 2: restore advanced graphics
c itype = 3: restore labels, panels, keys
c itype = 4: restore lines and symbols
c itype = 5: restore all the above
c
      implicit   none
c
c argument
c      
      integer, intent (in) :: itype
c
c locals
c      
      integer    i, j, mtrans, n, nxfig, nxsig, nxtic, nyfig,
     +           nysig, nytic, nzfig, nzsig, nztic
      integer    icount, itemp, jtemp, menu, numtxt 
      integer    n4, nsteps_max, numsta
      parameter (n4 = 4, nsteps_max = 300, numsta = 3)
      integer    isend, jsend, ksend, njmax, nkmax, nlgl, nmax
      parameter (isend = 1, jsend = 3, ksend = 0, njmax = 8, nkmax = 12,
     +           nlgl = 15, nmax = 20)
      integer    l_steps(nsteps_max), m_steps(nsteps_max)
      integer    max_itype, min_itype, numopt
      parameter (max_itype = 5, min_itype = 0, numopt = 7)
      integer    jcol(njmax), kcol(nkmax), numbld(30)
      integer    jcolor(nmax), jfill(nmax), kcolor(nmax), l(nmax),
     +           m(nmax)
      double precision fsize, sizes(nmax), thick(nmax)
      character (len = 100 ) text(30) 
      character (len = 40  ) label_1(nmax), panel_1(nmax), word40,
     +                       wordx_1(nmax), vectors_1(3*nmax)
      parameter (word40 = '0000000000000000000000000000000000000000')
      character (len = 80  ) word80
      parameter (word80 = '000000000000000000000000000000000000000000000
     +00000000000000000000000000000000000') 
      character (len = 1) blank
      parameter (blank = ' ') 
      logical    abort, lglvar_a(nlgl), lglvar_s(nlgl), repeet
      logical    restore_all, store_1, store_2, store_3 
      parameter (store_1 = .false., store_2 = .true.)
      external   x_gkssig, x_gkstic, x_gkslgl
      external   x_grfsig, x_grftic, x_grflgl
      external   x_gkscol
      external   w_labels, w_symbol, x_graphs, x_fsizes
      external   x_lstbox, x_nsteps, x_patch2
      external   savchr$, x_putfat
      data       numbld / 30*0 /
c
c initialise restore_all and check itype on entry
c     
      restore_all = .false.
      if (itype.lt.min_itype .or. itype.gt.max_itype) then
         call x_putfat ('ITYPE out of range (0,5) in call to X_RESDEF')
         return
      elseif (itype.eq.0) then
         repeet = .true.
         do while (repeet)
            write (text,100)
            numbld(1) = 4
            menu = numopt
            numtxt = numsta + numopt - 1
            call x_lstbox (numbld, menu, numopt, numsta, numtxt,
     +                     text)
            numbld(1) = 0
            repeet = .false.
            if (menu.eq.numopt - 2) then
               restore_all = .true.
            elseif (menu.eq.numopt - 1) then 
               repeet = .true.  
               write (text,200)
               numtxt = 24
               numbld(1) = 1
               numbld(17) = 1
               call x_patch2 (numbld, numtxt,
     +                        text)  
               numbld(1) = 0
               numbld(17) = 0
            elseif (menu.eq.numopt) then   
               return
            endif
         enddo   
      else
         if (itype.eq.5) then
            restore_all = .true.
         else   
            menu = itype   
         endif   
      endif     

      if (menu.eq.1 .or. menu.eq.2 .or. restore_all) then
c
c get current lglvar defaults
c        
          call x_graphs (icount, nlgl, 
     +                   abort, lglvar_a, lglvar_s, store_1)          
      endif  
      
      if (menu.eq.1 .or. restore_all) then
c
c menu = 1: simple graphics
c precision of axes labels (will be overwritten by most programs)
c      
         nxfig = 3
         nxsig = 2
         nyfig = 3
         nysig = 2
         call x_gkssig (isend, nxfig, nxsig, nyfig, nysig)
c
c number of segments marked of by tick marks (will be overwritten by most programs)
c     
         nxtic = 4
         nytic = 4
         call x_gkstic (isend, nxtic, nytic)

         lglvar_s(1) = .true.   !BOXIT
         lglvar_s(2) = .false.  !FRAME
         lglvar_s(3) = .false.  !OFFSET
         lglvar_s(4) = .false.  !XGRID
         lglvar_s(5) = .false.  !YGRID
         lglvar_s(6) = .false.  !CROSSHAIRS
         lglvar_s(7) = .true.   !TICK MARKS IN
         n = 7
         call x_gkslgl(isend, n,
     +                 lglvar_s)

c
c colours for simple graphics
c     
         do i = 1, njmax
            if (i.eq.5) then
               jcol(i) = 15
            else
               jcol(i) = 0
            endif
         enddo
         do i = 1, nkmax
            kcol(i) = 0
         enddo
         call x_gkscol (isend, jcol, kcol, njmax, nkmax)                   
      endif   
      
      if (menu.eq.2 .or. restore_all) then
c
c menu = 2: advanced graphics
c      
         nxfig = 3
         nyfig = 3
         nzfig = 3
         nxsig = 2
         nysig = 2
         nzsig = 2
         do i = 0, 23
            mtrans = i
            call x_grfsig(isend, mtrans, nxfig, nxsig,
     +                    'X') 
            call x_grfsig(isend, mtrans, nyfig, nysig,
     +                    'Y')
            call x_grfsig(isend, mtrans, nzfig, nzsig,
     +                    'Z')
            call x_grfsig(ksend, mtrans, nxfig, nxsig,
     +                    'X') 
            call x_grfsig(ksend, mtrans, nyfig, nysig,
     +                    'Y')
            call x_grfsig(ksend, mtrans, nzfig, nzsig,
     +                    'Z')
         enddo
         nxtic = 4
         nytic = 4
         nztic = 4
         call x_grftic (isend, nxtic,
     +                 'X') 
         call x_grftic (isend, nytic,
     +                 'Y')
         call x_grftic (isend, nztic,
     +                 'Z')
         lglvar_a(1) = .true.   !BOXIT
         lglvar_a(2) = .false.  !FRAME
         lglvar_a(3) = .true.   !OFFSET
         lglvar_a(4) = .false.  !XGRID
         lglvar_a(5) = .false.  !YGRID
         lglvar_a(6) = .false.  !CROSSHAIRS
         lglvar_a(7) = .true.   !TICK MARKS IN     
         lglvar_a(8) = .false.  !PANEL     
         lglvar_a(9) = .false.  !SIDE     
         lglvar_a(10) = .true.  !LINES IN PANEL     
         lglvar_a(11) = .true.  !SYMBOLS IN PANEL     
         lglvar_a(12) = .false. !BORDER 
         n = 12    
         call x_grflgl(isend, n,
     +                 lglvar_a)
      endif
      
      if (menu.eq.1 .or. menu.eq.2 .or. restore_all) then
c
c restore lglvar defaults
c        
          call x_graphs (icount, nlgl, 
     +                   abort, lglvar_a, lglvar_s, store_2)          
      endif  
      
      if (menu.eq.3 .or. restore_all) then
c
c menu = 3: labels
c        
         call w_labels (jsend, jcolor, jfill,
     +                  label_1, panel_1, wordx_1, vectors_1)
         do i = 1, 3
            itemp = i
            if (itemp.eq.1) then
               do j = 1, 5
                  jtemp = j
                  call savchr$ (itemp, jtemp,
     +                          word80,
     +                          store_2)
               enddo 
               jtemp = 6
               call savchr$ (itemp, jtemp,
     +                       blank,
     +                       store_2)                                 
            else  
               do j = 1, 20
                  jtemp = j
                  call savchr$ (itemp, jtemp,
     +                          word40,
     +                          store_2)
               enddo        
            endif     
         enddo     
      endif 

      if (menu.eq.4 .or. restore_all) then
c
c menu = 4: symbols
c        
         call w_symbol (jsend, jcolor, kcolor, l, m,
     +                  sizes, thick)
      endif
    
      if (restore_all) then
c
c extra items: nsteps and fsizes
c        
         call x_nsteps (n4, l_steps, m_steps, nsteps_max)
         call x_fsizes (ksend, 
     +                  fsize,
     +                  store_3)       
      endif          
c
c format statement
c      
  100 format (
     + 'Simfit default configuration' 
     +/
     +/'Restore simple graphics defaults'
     +/'Restore advanced graphics defaults'
     +/'Restore label and panel defaults'
     +/'Restore line and symbol defaults'
     +/'Restore all Simfit graphics defaults'
     +/'Help'
     +/'Cancel ... No changes required') 
 200  format (
     + 'Simfit configuration files and default parameters'
     +/
     +/'All configuration parameters used by Simfit are stored in'
     +/'...ProgramData\Simfit\user\cfg in files with extension cfg.'
     +/'For instance w_simfit.cfg is the main file, while w_ps.cfg'
     +/'stores PostScript and related parameters. Simfit does not use'
     +/'the registry, and will replace missing files by making sensible'
     +/'defaults. However, w_simfit.cfg must be updated using [Config]'
     +/'from a Simfit driver (w_simfit.exe or x64_simfit.exe) within a'
     +/'a Simfit installation, or a Simdem driver (simdem.exe or'
     +/'x64_simdem.exe) from within a Simdem installation. That way'      
     +/'important paths to auxiliaries such as Ghostscript, your PS'
     +/'driver (GSview), or pdf driver (Adobe Acrobat reader) can be'
     +/'corrected. To restore any defaults you can delete the *.cfg'
     +/'file, but for graphics there are better options.'
     +/
     +/'Restoring graphics defaults'
     +/
     +/'Once the main configuration defaults have been set they are not'
     +/'then usually changed. However there are many ways to configure'
     +/'the graphics options and often it is best to restore the Simfit'
     +/'graphics parameters to default values. From this control you'
     +/'can restore selected defaults, or all defaults, which also'
     +/'re-initialises font sizes.')
     
      end
c
c      