c
c*************************************************************
c 11/12/2004 edited so each calls a separate version of startp
c 22/11/2006 added simdir to prepend the simfit directory for
c            simfit executables stored in the simfit folder
c 31/12/2006 added calls to linux2 
c 19/01/2007 checked Simfit prefix and introduced infofl
c 11/05/2020 added call to X_EPSPDF  to display EPS as PDF 
c 11/11/2020 added text_viewer so run_gsview now shows the code
c*************************************************************
c
c Simfit codes to run external programs
c =====================================          
c run_acrobat
c run_calculator
c run_clipboard
c run_editor
c run_explorer
c run_gsview
c run_help ... now calls w_help.dll directly
c run_manual ... now calls run_acrobat or run_gsview
c run_program
c run_simfit
c run_simstat
c run_tutorial
c run_win32
c
c Note: The calls to run_program now use startp which uses
c       k = start_process_and_wait@(program, command_line, iwait)
c       where iwait = nval(12) milliseconds
c       It seems that iwait must not be 0 for gsview       
c
c-----------------------------------------------------------------------
c
      subroutine run_acrobat (command_line)
c
c action : run acrobat
c          17/11/2003 revised to use kval(5) and check the command_line
c          30/04/2004 replaced run_program by winxec
c          15/05/2004 replaced winxec by startp
c          11/12/2004 replaced startp by startp_acrobat
c          25/11/2006 introduced simdir to add path to filename if not present
c          31/12/2006 added call to linux2 
c          19/01/2007 added call to infofl
c          23/06/2009 added call to x_okcval
c          06/11/2022 added pdfrdr
c                  
      implicit   none
c
c argument
c             
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    isend
      parameter (isend = 1)
      character (len = 1024) acrobat
      character (len = 1   ) blank
      parameter (blank = ' ')  
      logical    there
      external   x_infofl, pdfrdr
      external   startp_acrobat, w_shellx 
      intrinsic  index

c
c does the *.pdf file exist
c           
      if (command_line.ne.blank) then   
         inquire (file = command_line, exist = there)
         if (.not.there) then 
            call x_infofl (isend,
     +                     command_line)            
            return
         endif
      endif
c      
c call pdfrdr
c      
      call pdfrdr (acrobat)                    
      if (acrobat.eq.'default') then
         call w_shellx (command_line)
         return
      endif   
      call startp_acrobat (acrobat, command_line)
      end
c
c---------------------------------------------------------------------
c
      subroutine run_calculator (command_line)
c
c action : run calculator
c          30/04/2004 replaced run_program by winxec
c          15/05/2004 replaced winxec by startp
c          11/12/2004 replaced startp by startp_calculator
c                     
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    mode
      parameter (mode = 0)
      integer    nval(12)
      character  cval(12)*1024, calculator*1024
      external   startp_calculator, w_config
      call w_config (mode, nval,
     +               cval)
      calculator = cval(12)
      call startp_calculator (calculator, command_line)
      end
c       
c----------------------------------------------------------------------
c
      subroutine run_clipboard (command_line)
c
c action : run clipboard
c          30/04/2004 replaced run_program by winxec
c          15/05/2004 replaced winxec by startp
c          11/12/2004 replaced startp by startp_clipboard
c                
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    mode
      parameter (mode = 0)
      integer    nval(12)
      character  cval(12)*1024, clipboard*1024
      external   startp_clipboard, w_config
      call w_config (mode, nval,
     +               cval)
      clipboard = cval(7)
      call startp_clipboard (clipboard, command_line)
      end
c 
c-------------------------------------------------------------------
c
      subroutine run_editor (command_line)
c
c action : run editor
c          17/11/2003 revised to use kval(1) and check the command_line
c          30/04/2004 replaced run_program by winxec
c          15/05/2004 replaced winxec by startp
c          11/12/2004 replaced startp by startp_editor       
c          25/11/2006 introduced simdir to add path to filename if not present
c          31/12/2006 added call to linux2
c          23/06/2009 added call to x_okcval
c                     
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    isend, jsend, mode
      parameter (isend = 1, jsend = 1, mode = -1)
      integer    kval(12), l1, l2, x_len200
      character  cval(12)*1024, editor*1024, fname*1024
      character  blank*1, quote*1
      parameter (blank = ' ', quote = '"')
      logical    ok, there
      external   w_config, x_len200, x_triml1, x_linux2, x_infofl,
     +           x_okcval     
      external   startp_editor, w_shellx   
      intrinsic  index
c
c does the text file exist
c
      fname = command_line
      if (fname.ne.blank) then  
         inquire (file = fname, exist = there)
         if (.not.there) then  
            call x_infofl (isend,
     +                     fname)             
            return
         endif
      endif
c
c call x_okcval
c      
      call x_okcval (jsend,
     +               ok)
      if (.not.ok) then
         call w_shellx (fname)
         return
      endif   
c
c get the path to the editor and the key for quotes
c
      call w_config (mode, kval,
     +               cval)
      editor = cval(1)   
      if (fname.ne.blank) call x_linux2 (editor, fname)
      if (kval(1).eq.1 .and. fname.ne.blank) then
         call x_triml1 (fname)
         l1 = 1
         l2 = x_len200(fname)
         fname = quote//fname(l1:l2)//quote
      endif
      call startp_editor (editor, fname)
      end
c
c---------------------------------------------------------------
c
      subroutine run_explorer (command_line)
c
c action : run explorer
c          15/05/2004 replaced winxec by startp
c          11/12/2004 replaced startp by startp_explorer
c                    
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    isend, mode
      parameter (isend = 2, mode = -1)
      integer    kval(12)
      character  cval(12)*1024, explorer*1024
      logical    ok
      external   startp_explorer, w_config, x_okcval, w_shellx
      call x_okcval (isend, 
     +               ok) 
      if (.not.ok) then
         call w_shellx ('\')
         return
      endif     
c
c get the path to the explorer
c
      call w_config (mode, kval,
     +               cval)
      explorer = cval(2)
      call startp_explorer (explorer, command_line)
      end
c
c------------------------------------------------------------------
c
      subroutine run_gsview (command_line)
c
c action : run gsview
c          30/04/2004 replaced run_program by startp
c          11/12/2004 replaced startp by startp_gsview  
c          25/11/2006 introduced simdir to add path to filename if not present
c          31/12/2006 added call to linux2
c          19/01/2007 added call to infofl
c          23/06/2009 added call to x_okcval
c          11/11/2020 added call to text_viewer to display the code
c               
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
      integer    isend, jsend, mode
      parameter (isend = 1, jsend = 10, mode = -1)
      integer    l1, l2, x_len200, kval(12)
      character  cval(12)*1024, gsview*1024
      character  fname*1024
      character  blank*1, quote*1
      parameter (blank = ' ', quote = '"')
      logical    view_as_text, view_as_text1
      parameter (view_as_text = .true.)! use text_reader or gsview
      logical    ok, there
      logical    proceed
      parameter (proceed = .true.)
      external   w_config, x_len200, x_triml1, x_linux2, x_infofl,
     +           x_okcval, x_epspdf       
      external   startp_gsview, text_viewer
      intrinsic  index
c
c use text_viewer if view_as_text = .true.
c      
      view_as_text1 = view_as_text
c
c does the .ps file exist
c
      fname = command_line
      if (fname.ne.blank) then  
         inquire (file = fname, exist = there)
         if (.not.there) then
            call x_infofl (isend,
     +                     fname)             
            return
         endif
      endif
c
c call text viewer then return
c      
      if (view_as_text1) then
         call text_viewer (fname,
     +                     proceed)
         return
      endif 
c
c o/w call x_okcval etc.
c         
      call x_okcval (jsend,
     +               ok)
      
c
c get the path to GSview and the key for quotes
c
      if (ok) then
         call w_config (mode, kval, 
     +                  cval)
         gsview = cval(10)    
         if (fname.ne.blank) call x_linux2 (gsview, fname)
         if (kval(2).eq.1 .and. fname.ne.blank) then
            call x_triml1 (fname)
            l1 = 1
            l2 = x_len200(fname)
            fname = quote//fname(l1:l2)//quote
         endif
      endif
      if (.not.ok) then
         call x_epspdf (fname)
      else   
         call startp_gsview (gsview, fname)
      endif   
      end
c 
c-----------------------------------------------------------------------
c
      subroutine run_help (command_line)
c
c action : run the help program
c          17/02/2004 revised to run help from w_help.dll
c          03/04/2005 revised to call w_help.exe  
c          19/01/2007 added call to infofl
c                                
      implicit   none
c
c argument
c                    
      character (len = *), intent (in) :: command_line
c
c locals
c      
c*****external   help_main
c*****call help_main (command_line)
      integer    isend
      parameter (isend = 1)
      character  fname*1024, x_sim256*1024
      character  pname*10, pname1*12
      parameter (pname = 'w_help.exe',
     +           pname1 = 'x64_help.exe')
      logical    there
      external   startp_program, x_sim256, x_infofl  
      fname = x_sim256(pname)
      inquire (file = fname, exist = there)
      if (.not.there) then
         fname = x_sim256(pname1)
         inquire (file = fname, exist = there)
      endif     
      if (.not.there) then
         call x_infofl (isend,
     +                  fname)         
      else
         call startp_program (fname, command_line)
      endif
      end
c
c-----------------------------------------------------------------
c
      subroutine run_manual (isend)
c
c action : run the manual/acrobat/gsview   
c          25/11/2006 introduced simdir to add path to filename 
c          19/01/2007 added call to infofl
c          16/09/2013 added calls to speedup
c          20/11/2013 added calls to tutorials
c          26/11/2014 added calls to w_examples
c          30/03/2016 added calls to license 
c          15/02/2024 added call to sv_manual.pdf  
c
c          1: w_manual.ps
c          2: w_manual.pdf
c          3: promote.ps
c          4: promote.pdf
c          5: ms_office.ps
c          6: ms_office.pdf
c          7: pscodes.ps
c          8: pscodes.pdf
c          9: speedup.ps
c         10: speedup.pdf
c         11: tutorials.ps 
c         12: tutorials.pdf 
c         13: configure.ps 
c         14: configure.pdf 
c         15: install.ps 
c         16: install.pdf 
c         17: w_examples.ps
c         18: w_examples.pdf 
c         19: license.ps
c         20: license.pdf 
c         21: sv_manual.pdf
c
      implicit   none   
c
c argument
c      
      integer, intent (in) :: isend
c
c locals
c                 
      integer    jsend
      parameter (jsend = 1) 
      character (len = 1024) command_line, x_sim256
      character (len = 18  ) fname
      logical    there
      external   run_acrobat, run_gsview, x_sim256, x_infofl
      if (isend.eq.1) then
         fname = 'w_manual.ps'
      elseif (isend.eq.2) then
         fname = 'w_manual.pdf'
      elseif (isend.eq.3) then
         fname = 'simfit_summary.ps'
      elseif (isend.eq.4) then
         fname = 'simfit_summary.pdf'
      elseif (isend.eq.5) then
         fname = 'ms_office.ps'
      elseif (isend.eq.6) then
         fname = 'ms_office.pdf'
      elseif (isend.eq.7) then
         fname = 'pscodes.ps'
      elseif (isend.eq.8) then
         fname = 'pscodes.pdf'
      elseif (isend.eq.9) then
         fname = 'speedup.ps'
      elseif (isend.eq.10) then
         fname = 'speedup.pdf'   
      elseif (isend.eq.11) then
         fname = 'tutorials.ps'
      elseif (isend.eq.12) then
         fname = 'tutorials.pdf'      
      elseif (isend.eq.13) then
         fname = 'configure.ps'
      elseif (isend.eq.14) then
         fname = 'configure.pdf'
      elseif (isend.eq.15) then
         fname = 'install.ps'
      elseif (isend.eq.16) then
         fname = 'install.pdf'  
      elseif (isend.eq.17) then
         fname = 'w_examples.ps'
      elseif (isend.eq.18) then
         fname = 'w_examples.pdf' 
      elseif (isend.eq.19) then
         fname = 'license.ps'
      elseif (isend.eq.20) then
         fname = 'license.pdf' 
      elseif (isend.eq.21) then
         fname = 'sv_manual.pdf'                  
      else
         return
      endif 
      command_line = x_sim256(fname)
      inquire (file = command_line, exist = there)
      if (there) then
c
c call the external executable
c
         if (isend.eq.1  .or. isend.eq.3  .or. isend.eq.5  .or.
     +       isend.eq.7  .or. isend.eq.9  .or. isend.eq.11 .or.
     +       isend.eq.13 .or. isend.eq.15 .or. isend.eq.17 .or.
     +       isend.eq.19) then
             call run_gsview (command_line)
          else
             call run_acrobat (command_line)
          endif
      else 
         call x_infofl (jsend,
     +                  command_line)         
      endif
      end
c
c-----------------------------------------------------------------------
c
      subroutine run_program (ifail,
     +                        fname, command_line)
c
c action : run a win32 executable
c
c          ifail = 0 on entry: issue error messages, o/w silent
c          ifail = 0 on exit : ok
c          ifail = 1 on exit : file does not exist
c          ifail = 2 on exit : blank filename, no action
c
c author : w.g.bardsley, university of manchester, u.k, 19/12/98
c          derived from run_win32
c          11/12/2004 replaced startp by startp_program
c          19/01/2007 added call to infofl
c
      implicit   none   
c
c arguments
c      
      integer,             intent (inout) :: ifail
      character (len = *), intent (in)    :: fname, command_line
c
c locals
c             
      integer    isend
      parameter (isend = 1)   
      character  fcopy*1024
      character  blank*1
      parameter (blank = ' ')
      logical    there
      external   startp_program, x_infofl 
      if (fname.eq.blank) then
         ifail = 2
      else                                   
         inquire (file = fname, exist = there)
         if (there) then
            fcopy = fname
            call startp_program (fcopy, command_line)
            ifail = 0
         else
            if (ifail.eq.0) then 
               call x_infofl (isend,
     +                        fname)                
            endif
            ifail = 1
         endif
      endif
      end
c    
c------------------------------------------------------------------
c
      subroutine run_simfit (fname)
c
c action : run a simfit program     
c          25/11/2006 introduced simdir to add path to filename 
c          19/11/2007 checked Simfit prefix and added call to infofl
c                                
      implicit   none 
c
c argument
c      
      character (len = *), intent (in) :: fname
c
c locals
c                       
      integer    isend
      parameter (isend = 1)
      integer    ifail
      character  command_line*1
      parameter (command_line = ' ')
      character  progrm*1024, x_sim256*1024     
      logical    there
      external   run_program, x_sim256, x_infofl 
      progrm = x_sim256(fname)
      inquire (file = progrm, exist = there) 
      if (there) then     
         ifail = 0
         call run_program (ifail,
     +                     progrm, command_line)
      else 
         call x_infofl (isend,
     +                  progrm)          
      endif  
      end
c     
c-----------------------------------------------------------
c
      subroutine run_simstat (command_line)
c
c action : run simstat
c          19/01/2007 added call to infofl
c          03/05/2012 added x64_simstat
c          26/02/2016 added os64 and call to isit64
c                         
      implicit   none
c
c argument
c             
      character (len = *), intent (in) :: command_line
c
c locals
c                   
      integer    isend
      parameter (isend = 1)
      integer    ios
      character  progrm*1024, x_sim256*1024
      character  pname*13, pname1*15
      parameter (pname = 'w_simstat.exe', pname1 = 'x64_simstat.exe')
      logical    there
      logical    isit64, os64
      external   startp_program, x_sim256, x_infofl, isit64
      ios = -1
      there = .false.
      os64 = isit64()
      if (os64) then
         progrm = x_sim256(pname1)
         inquire (file = progrm, exist = there, iostat = ios)
      else
         progrm = x_sim256(pname)
         inquire (file = progrm, exist = there, iostat = ios)
      endif   
      if (ios.eq.0 .and. .not.there) then 
         call x_infofl (isend,
     +                  progrm)         
      else
         call startp_program (progrm, command_line)
      endif
      end
c
c------------------------------------------------------------------
c
      subroutine run_tutorial (fname) 
c
c action: find then display a simfit tutorial
c author: w.g.bardsley, university of manchester, u.k., 21/12/2021
c
c argument
c
      character (len = *) , intent (in) :: fname   
c
c locals
c      
      integer    isend, l
      parameter (isend = 1)  
      character (len = 1024) x_sim256, pdf_file
      character (len = 4   ) word4
      logical    there
      intrinsic  len_trim
      external   x_sim256, run_acrobat, x_infofl, x_putadv, x_lcase1
      l = len_trim(fname)
      if (l.lt.5) then
         call x_putadv ('This is not a Simfit tutorial file')
         return
      endif  
      word4 = fname(l - 3:l)
      call x_lcase1 (word4) 
      if (word4.ne.'.pdf') then
         call x_putadv (
     +'Simfit tutorial files must have the extension .pdf')
         return
      endif   
      pdf_file = x_sim256(fname)
      inquire (file = pdf_file, exist = there)
      if (.not.there) then 
         call x_infofl (isend,
     +                  fname)            
         return
      endif
      call run_acrobat (pdf_file)
      end     
c 
c--------------------------------------------------------------------------
c
      subroutine run_win32 (ifail,
     +                      fname)
c
c action : run a win32 executable
c
c          ifail = 0 on entry: issue error messages, o/w silent
c          ifail = 0 on exit : ok
c          ifail = 1 on exit : file does not exist
c          ifail = 2 on exit : blank filename, no action
c
c author : w.g.bardsley, university of manchester, u.k, 20/6/97
c          11/12/2004 replaced startp by startp_win32  
c          19/01/2007 added call to infofl
c
      implicit   none   
c
c arguments
c      
      integer,             intent (inout) :: ifail
      character (len = *), intent (in)    :: fname
c
c locals
c                                         
      integer    isend
      parameter (isend = 1)
      character  blank*1
      parameter (blank = ' ')
      logical    there
      external   startp_win32, x_infofl
      if (fname.eq.blank) then
         ifail = 2
      else                             
         inquire (file = fname, exist = there)
         if (there) then
            call startp_win32 (fname, blank)
            ifail = 0
         else
            if (ifail.eq.0) then    
               call x_infofl (isend,
     +                        fname)                
            endif
            ifail = 1
         endif
      endif
      end
c
c

