c
c x_savall: routines to save parameters for graphics calls
c =========
c
c saveit$
c savedn$
c savelc$
c savemn$
c saveob$
c savetr$
c savexy$
c savenx$ 
c savres$
c savswi$
c--------
c savell$
c--------
c savbck$
c--------
c savint$
c savlgl$ 
c savchr$
c savpnl$
c savque$
c txtkey$
c query_graph_exit
c query_files_required
c eb_settings
c simplot_tf
c
c***********************************************************************
c
      subroutine saveit$(i, store)
c
c store integer or retrieve depending on store
c
      implicit   none
      integer    i
      integer    i1
      logical    store
      save       i1
      data       i1 / 0 /
      if (store) then
         i1 = i
      else
         i = i1
      endif
      end
c  
c***********************************************************************
c
      subroutine savedn$(rn,
     +                   dn, store)
c
c store/retrieve radius and dn = flag for a doughnut type piechart
c     
      implicit none
      double precision rn
      double precision rn1
      logical  dn, store
      logical  dn1
      save     dn1, rn1
      data     rn1 / 0.6d+00 /
      data     dn1 / .false. /
      if (store) then
         rn1 = rn
         dn1 = dn
      else
         rn = rn1
         dn = dn1
      endif
      end       
c
c***********************************************************************
c
      subroutine savelc$(i, store)
c
c store integer or retrieve depending on store ... background colour
c
      implicit   none
      integer    i
      integer    i1
      logical    store
      save       i1
      data       i1 / 15 /
      if (store) then
         i1 = i
      else
         i = i1
      endif
      end
c
c***********************************************************************
c
      subroutine savemn$(m, n, store)
c
c store m and n or retrieve depending on store
c
      implicit   none
      integer    m, n
      integer    m1, n1
      logical    store
      save       m1, n1
      data       m1, n1 / 0, 0 /
      if (store) then
         m1 = m
         n1 = n
      else
         m = m1
         n = n1
       endif
       end
c
c***********************************************************************
c
      subroutine saveob$(i, store)
c
c store integer or retrieve depending on store
c
      implicit   none
      integer    i
      integer    i1
      logical    store
      save       i1
      data       i1 / 0 /
      if (store) then
         i1 = i
      else
         i = i1
      endif
      end
c  
c***********************************************************************
c
      subroutine savetr$(i, store)
c
c store integer corresponding to MTRANS or retrieve depending on store
c
      implicit   none
      integer    i
      integer    i1
      logical    store
      save       i1
      data       i1 / 0 /
      if (store) then
         i1 = i
      else
         i = i1
      endif
      end
c
c***********************************************************************
c
      subroutine savexy$(x, y, store)
c
c store x and y or retrieve depending on store
c
      implicit   none
      double precision x, y
      double precision x1, y1
      logical    store
      save       x1, y1
      data       x1, y1 / 0.0d+00, 0.0d+00 /
      if (store) then
         x1 = x
         y1 = y
      else
         x = x1
         y = y1
      endif
      end  
c
c***********************************************************************
c
      subroutine savres$(xres, yres, store)
c
c store graph size passed to %gr
c
      implicit   none
      integer    xres, yres
      integer    xres1, yres1
      logical    store
      save xres1, yres1
      data xres1, yres1 / 639, 479 /
      if (store) then
         xres1 = xres
         yres1 = yres
      else
         xres = xres1
         yres = yres1
      endif
      end  
c
c***********************************************************************
c
      subroutine savswi$(on, store)
c
c store switch_on for pltobj$ and objplt$
c
      implicit   none
      logical    on, store
      logical    on1
      save on1
      data on1 / .true. /
      if (store) then
         on1 = on
      else
         on = on1
      endif
      end            
c
c
c---------------------------------------------------------------------
C
C
      SUBROUTINE SAVE11$(BAR_CHART, BI_PLOT, DENDRO_GRAM, PIE_CHART,
     +                   STORE, TWO_PLOTS, VECTOR_FIELD)
C
C ACTION: store logicals for SIMPLOT/MENU11$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 24/11/2000
C         20/07/2001 added DENDRO_GRAM 
C         19/09/2006 added BI_PLOT
C         20/04/2007 added INTENTS
C                      
C         STORE: (input/unchanged) as follows:
C                STORE = .TRUE.  then store the logicals 
C                                i.e. other variables are (input/unchanged)
C                STORE = .FALSE. then retrieve the stored values  
C                                i.e. other variables are (output)
C
      IMPLICIT NONE
C
C Arguments
C          
      LOGICAL, INTENT (IN)    :: STORE
      LOGICAL, INTENT (INOUT) :: BAR_CHART, BI_PLOT, DENDRO_GRAM,
     +                           PIE_CHART, TWO_PLOTS, VECTOR_FIELD     
C
C Locals
C     
      LOGICAL  BAR,     BI,      DEND,    PIE,     TWO,     VECTOR
      SAVE     BAR,     BI,      DEND,    PIE,     TWO,     VECTOR
      DATA     BAR,     BI,      DEND,    PIE,     TWO,     VECTOR
     +      / .FALSE., .FALSE., .FALSE., .FALSE., .FALSE., .FALSE. /
      IF (STORE) THEN
         BAR = BAR_CHART    
         BI = BI_PLOT
         DEND = DENDRO_GRAM
         PIE = PIE_CHART
         TWO = TWO_PLOTS
         VECTOR = VECTOR_FIELD
      ELSE
         BAR_CHART = BAR
         BI_PLOT = BI
         DENDRO_GRAM = DEND
         PIE_CHART = PIE
         TWO_PLOTS = TWO
         VECTOR_FIELD = VECTOR
      ENDIF
      END
C
C
c
c---------------------------------------------------------------------     
c
      subroutine savbck$(ifill, ihue, n,
     +                   store)
c
c action: save/retrieve barchart panel key parameters   
c author: w.g.bardsley, university of manchester, u.k., 19/09/2011
c  
      implicit none
c
c arguments
c      
      integer, intent (in)    :: n
      integer, intent (inout) :: ifill(n), ihue(n)
      logical, intent (in)    :: store 
c
c locals
c      
      integer    i, ntemp
      integer    nmax
      parameter (nmax = 20)
      integer    ifill_1(nmax), ihue_1(nmax)
      save       ifill_1, ihue_1
      data       ifill_1, ihue_1 / nmax*1, nmax*0 /
      intrinsic  min
      ntemp = min(n,nmax)
      if (store) then
         do i = 1, ntemp
            ifill_1(i) = ifill(i)
            ihue_1(i) = ihue(i)
         enddo   
      else 
         do i = 1, ntemp
            ifill(i) = ifill_1(i)
            ihue(i) = ihue_1(i)
         enddo 
      endif
      end
c
c


c
c--------------------------------------------------------------------
c       
      subroutine savint$ (isend, jsend, nsav,
     +                    store)
     
      use module_clearwin, only : nbar_1, ngroup_1, npts_1, 
     +                            l_step, m_step, ngraf1
      
c
c action: store/retrieve integer variables from module_savegks
c author: w.g.bardsley, university of manchester, 30/01/2011
c         16/06/2011 added nbar_1, ngroup_1, npts_1, nmax_1
c         01/11/2011 added calls to w_nsteps.cfg if file number =< max_steps
c         20/01/2013 removed calls to w_nsteps.cfg which are now from x_nsteps
c
c isend = 1: edit l_step as follows ... jsend = index in l_step, nsav = l_step(jsend)
c isend = 2: edit m_step as follows ... jsend = index in m_step, nsav = m_step(jsend)
c isend = 3: nbar_1
c isend = 4: ngroup_1 
c isend = 5: nmax1 (should have same initial value as module_savegks)
c isend = 6: npts_1 
c       
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend, jsend
      integer, intent (inout) :: nsav
      logical, intent (in)    :: store
c
c local
c      
      integer    nmax1
      save       nmax1
      data       nmax1 / 500 /
c
c check isend and jsend 
c      
      if (isend.lt.1 .or. isend.gt.6)  return 
      if (isend.eq.1 .or. isend.eq.2) then  
         if (jsend.lt.1 .or. jsend.gt.ngraf1) return
      endif     
     
      if (store) then
c
c store nval supplied
c        
         if (isend.eq.1) then 
            if (nsav.lt.0) then
               return
            else   
               l_step(jsend) = nsav
            endif   
         elseif (isend.eq.2) then
            if (nsav.lt.0) then
               return
            else   
               m_step(jsend) = nsav
            endif 
         elseif (isend.eq.3) then
            nbar_1 = nsav   
         elseif (isend.eq.4) then
            ngroup_1 = nsav
         elseif (isend.eq.5 .and. nsav.gt.nmax1) then
            nmax1 = nsav
         elseif (isend.eq.6) then
            npts_1 = nsav      
         endif
         
      else
c
c return stored value for nsav
c        
         if (isend.eq.1) then
            nsav = l_step(jsend)
         elseif (isend.eq.2) then
            nsav = m_step(jsend)
         elseif (isend.eq.3) then
            nsav = nbar_1
         elseif (isend.eq.4) then
            nsav = ngroup_1
         elseif (isend.eq.5) then
            nsav = nmax1
         elseif (isend.eq.6) then
            nsav = npts_1
         endif       
      endif
      end                
c
c--------------------------------------------------------------------
c       
      subroutine savlgl$ (isend,
     +                    lglval, store)
     
      use module_clearwin, only : extend_1, xlabel_1, pie_1, bar_1,
     +                            panel_lines, panel_symbols,  
     +                            wide_panel, rotate_z, side_1, dfolt_1,
     +                            panel_1 
c
c action: store/retrieve scalar logical variables from module_savegks
c author: w.g.bardsley, university of manchester, u.k., 30/11/2010
c 
c isend =  1: extend_1, i.e. extend_lines 
c isend =  2: xlabel_1, i.e. xlabel
c isend =  3: pie_1, i.e. pie_chart
c isend =  4: bar_1, i.e. bar_chart
c isend =  5: wide_panel
c isend =  6: panel_lines
c isend =  7: panel_symbols
c isend =  8: rotate_z
c isend =  9: side_1
c isend = 10: dfolt_1
c isend = 11: panel_1
c     
      implicit none
c
c arguments
c      
      integer, intent (in)    :: isend
      logical, intent (in)    :: store
      logical, intent (inout) :: lglval
      if (isend.eq.1) then
c
c isend = 1: extend_lines
c            
         if (store) then
            extend_1 = lglval
         else
            lglval = extend_1
         endif
      elseif (isend.eq.2) then
c
c isend = 2: xlabel
c            
         if (store) then
            xlabel_1 = lglval
         else
            lglval = xlabel_1
         endif   
      elseif (isend.eq.3) then
c
c isend = 3: pie_chart
c            
         if (store) then
            pie_1 = lglval
         else
            lglval = pie_1
         endif
      elseif (isend.eq.4) then
c
c isend = 4: bar_chart
c            
         if (store) then
            bar_1 = lglval
         else
            lglval = bar_1
         endif
      elseif (isend.eq.5) then
c
c isend = 5: wide_panel
c            
         if (store) then
            wide_panel = lglval
         else
            lglval = wide_panel
         endif
      elseif (isend.eq.6) then
c
c isend = 6: panel_lines
c            
         if (store) then
            panel_lines = lglval
         else
            lglval = panel_lines
         endif
      elseif (isend.eq.7) then
c
c isend = 7: panel_symbols
c            
         if (store) then
            panel_symbols = lglval
         else
            lglval = panel_symbols
         endif  
      elseif (isend.eq.8) then
c
c isend = 8: rotate_z
c            
         if (store) then
            rotate_z = lglval
         else
            lglval = rotate_z
         endif
      elseif (isend.eq.9) then
c
c isend = 9: side_1
c            
         if (store) then
            side_1 = lglval
         else
            lglval = side_1
         endif
      elseif (isend.eq.10) then
c
c isend = 10: dfolt_1
c            
         if (store) then
            dfolt_1 = lglval
         else
            lglval = dfolt_1
         endif 
      elseif (isend.eq.11) then
c
c isend = 11: panel_1
c            
         if (store) then
            panel_1 = lglval
         else
            lglval = panel_1
         endif                
      endif    
      end
c
c----------------------------------------------------------------------------------------------
c       
      subroutine savchr$ (isend, jsend,
     +                    chrval,
     +                    store)
     
      use module_clearwin, only : ngraf1, nword1, 
     +                            arrayt_1, arrayx_1, arrayy_1,
     +                            arrayz_1,
     +                            arrayq_1, labvec_1, psymb_1, qtitle_1,
     +                            wordy_1,
     +                            labvec_1_new, psymb_1_new, wordy_1_new  
c
c
c action: store/retrieve scalar character variables from module_savegks
c author: w.g.bardsley, university of manchester, u.k., 30/11/2010
c         06/07/2011 added code for isend = 4
c         12/07/2011 added logical variables *_1_new and x_pskeys
c 
c isend = 1 plot title vectors and strings
c           jsend = 1: main title font-key  
c           jsend = 2: x-legend font-key 
c           jsend = 3: y_legend font-key 
c           jsend = 4: z-legend font-key 
c           jsend = 5: subsidary title font-key  
c           jsend = 6: subsidary title string  
c isend = 2 panel character vectors
c           jsend = array index    
c isend = 3 label character vectors
c           jsend = array index
c isend = 4 x_tic character vectors
c           jsend = array index
c     
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, jsend
      logical,             intent (in)    :: store
      character (len = *), intent (inout) :: chrval
c
c locals
c      
      character (len = 40) x_pskeys
      external   x_pskeys
      if (isend.eq.1) then
c
c isend = 1: plot title and legend character vector
c            
         if (store) then
            if (jsend.eq.1) then
               arrayt_1(0) = x_pskeys(chrval)
            elseif (jsend.eq.2) then   
               arrayx_1(0) = x_pskeys(chrval)
            elseif (jsend.eq.3) then   
               arrayy_1(0) = x_pskeys(chrval)
            elseif (jsend.eq.4) then   
               arrayz_1(0) = x_pskeys(chrval)
            elseif (jsend.eq.5) then   
               arrayq_1 = x_pskeys(chrval)
            elseif (jsend.eq.6) then   
               qtitle_1 = chrval
            endif   
         else
            if (jsend.eq.1) then
               chrval = arrayt_1(0)
            elseif (jsend.eq.2) then   
               chrval = arrayx_1(0)
            elseif (jsend.eq.3) then   
               chrval = arrayy_1(0)
            elseif (jsend.eq.4) then   
               chrval = arrayz_1(0)
            elseif (jsend.eq.5) then   
               chrval = arrayq_1
            elseif (jsend.eq.6) then   
               chrval = qtitle_1
            endif   
         endif 
      elseif (isend.eq.2) then 
c
c isend = 2: panel array character vector 
c      
         if (jsend.ge.1 .and. jsend.le.ngraf1) then
            if (store) then
               psymb_1(jsend) = x_pskeys(chrval)
               if (jsend.le.20) psymb_1_new(jsend) = .true.
            else
               chrval = psymb_1(jsend)
            endif 
         endif
      elseif (isend.eq.3) then 
c
c isend = 3: label array character vector 
c      
         if (jsend.ge.1 .and. jsend.le.nword1) then  
            if (store) then
               labvec_1(jsend) = x_pskeys(chrval)
               if (jsend.le.20) labvec_1_new(jsend) = .true.
            else
               chrval = labvec_1(jsend)
            endif                                      
         endif 
      elseif (isend.eq.4) then 
c
c isend = 4: x_tic array character vector 
c      
         if (jsend.ge.1 .and. jsend.le.nword1) then  
            if (store) then
               wordy_1(jsend) = x_pskeys(chrval)
               if (jsend.le.20) wordy_1_new(jsend) = .true.
            else
               chrval = wordy_1(jsend)
            endif                                      
         endif        
      endif 
      end
c
c------------------------------------------------------------------------
c
      subroutine savpnl$(isend, jsend,
     +                   chrval,
     +                   lglvar, store)
      use module_clearwin, only : labvec_1, psymb_1, wordy_1, 
     +                            labvec_1_new, psymb_1_new, wordy_1_new
c
c action: store/retrieve labels and *_new variables for subroutine deflab
c author: w.g.bardsley, university of manchester, u.k., 16/09/2011      
c
c isend = 1: labvec
c isend = 2: psymb
c isend = 3: wordy
c
      implicit none
c
c arguments
c 
      integer,             intent (in)    :: isend, jsend
      character (len = *), intent (inout) :: chrval
      logical,             intent (inout) :: lglvar           
      logical,             intent (in)    :: store
c
c check
c      
      if (isend.lt.1 .or. isend.gt.3 .or.
     +    jsend.lt.1 .or. jsend.gt.20) return
           
      if (store) then
c
c store *_new variables
c        
         if (isend.eq.1) then
            labvec_1(jsend) = chrval
            labvec_1_new(jsend) = lglvar
         elseif (isend.eq.2) then
            psymb_1(jsend) = chrval
            psymb_1_new(jsend) = lglvar
         elseif (isend.eq.3) then
            wordy_1(jsend) = chrval
            wordy_1_new(jsend) = lglvar
         endif
      else
c
c retrieve *_new variables
c         
         if (isend.eq.1) then
            chrval = labvec_1(jsend)
            lglvar = labvec_1_new(jsend) 
         elseif (isend.eq.2) then
            chrval = psymb_1(jsend)
            lglvar = psymb_1_new(jsend) 
         elseif (isend.eq.3) then
            chrval = wordy_1(jsend)
            lglvar = wordy_1_new(jsend) 
         endif      
      endif
      end
c
c-------------------------------------------------------------------------
c      
      subroutine savque$ (query, store)

      use module_clearwin, only : query_exit

      implicit none
      logical, intent (in)    :: store
      logical, intent (inout) :: query
      if (store) then
         query_exit = query
      else
         query = query_exit
      endif
      end      
      
c
c------------------------------------------------------------------------
c               
      subroutine txtkey$ (label_keys, panel_keys, wordy_keys, 
     +                    store)                 
      
      use module_clearwin, only : labvec_1, psymb_1, wordy_1,
     +                            labvec_1_new, psymb_1_new, wordy_1_new            
c
c action: store/retrieve main character keys for subroutine labels
c author: w.g.bardsley, university of manchester, u.k., 28/12/2010
c         23/04/2011 increased dimension to 20 
c         06/06/2011 added initialisation
c         12/07/2011 deleted initialisation, added *_1_new variables, and extra argument
c
c Advice about keys in subroutines deflab, deflbl, defkey, and txtkey 
c -------------------------------------------------------------------
c deflab ... Re-initialises changes made to the keys by
c            any previous calls to defkey for n =< 20 then
c            passes the new values on to deflbl.
c            Note that deflab cancels any existing changes made by defkey
c deflbl ... Passively writes the arguments supplied to the configuration
c            file w_labels.cfg. 
c defkey ... Overwrites current keys but has lower priority than deflab.
c            Note that in normal use then defkey will override default keys
c            but calls to deflab take priority and will re-initialise keys.
c            So calls to defkey made after calls to deflab will change the
c            current keys but not the defaults.
c txtkey ... This uses keys altered by defkey after calls to deflab to 
c            temporarily override the defaults.  
c
      implicit none
c
c arguments
c 
      character (len = *), intent (inout) :: label_keys(20),
     +                                       panel_keys(20),
     +                                       wordy_keys(20) 
      logical,             intent (in)    :: store
c
c locals
c      
      integer    i
      character (len = 40) x_pskeys
      external   x_pskeys
      
      if (store) then
c
c save keys for labels, panels, and X_tic
c        
         do i = 1, 20
            labvec_1(i) = x_pskeys(label_keys(i))
            psymb_1(i) = x_pskeys(panel_keys(i))
            wordy_1(i) = x_pskeys(wordy_keys(i))
            labvec_1_new(i) = .true.
            psymb_1_new(i) = .true.
            wordy_1_new(i) = .true.
         enddo
      else
c
c supply keys for labels, panels, and X_tic if defaults have been altered
c        
         do i = 1, 20
            if (labvec_1_new(i)) label_keys(i) = labvec_1(i)
            if (psymb_1_new(i)) panel_keys(i) = psymb_1(i) 
            if (wordy_1_new(i)) wordy_keys(i) = wordy_1(i)
         enddo
      endif
      end
c
c--------------------------------------------------------------------------              
c
      subroutine query_graph_exit (abort)
      use module_clearwin, only : query_exit
c
c action: warn users about quitting advanced graphics
c author: w.g.bardsley, university of manchester, u.k., 27/04/2011
c         14/01/2014 added option to disable temporarily
c         31/08/2015 deleted action and made temporary exit permanent
c
      implicit none
c
c argument
c      
      logical, intent (out) :: abort
c
c locals
c
      integer    numdec
      integer    n36
      parameter (n36 = 36)
      integer    icolor, ix, iy, lshade, numopt, numsta, numtxt
      parameter (icolor = 7, ix = 0, iy = 0, lshade = 0, numopt = 3,
     +           numsta = 13, numtxt = numsta + numopt - 1)
      integer    numbld(numtxt), numpos(numopt)
      character (len = 80) header_in(numtxt)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   w_hbox01, x_switch
      data       numbld / numtxt*0 /
      data       numpos / numopt*1 /
      abort = .true.   
      if (query_exit) then
c
c provide query if editing has taken place
c      
         write (header_in,100)
         numbld(1) = 4
         numbld(11) = 1
         numdec = 1
         call w_hbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                  numpos, numsta, numtxt,
     +                  header_in,
     +                  border, flash, high)
         if (numdec.eq.1) then
            abort = .false.
         elseif (numdec.eq.2) then
            query_exit = .false.
            abort = .true.
         else
            abort = .true.
            call x_switch (n36)
         endif
      endif
c
c format statement
c      
  100 format (
     + 'Reminder about leaving advanced graphics after editing' 
     +/
     +/'To disable/restore this advice, open the Simfit configuration'  
     +/'control, select [Advanced], then use the speedup options as'
     +/'listed in speedup.pdf, or select the [Suppress] option below.' 
     +/
     +/'You can resume to continue editing then printing or saving a'
     +/'a graphics file. Also, if available, consider saving a graphics'
     +/'configuration file or metafile for retrospective editing.' 
     +/
     +/'Note that quitting now will lose the editing you have done.'
     +/
     +/'Resume'
     +/'Quit'
     +/'Suppress') 
      end
c
c
      subroutine query_files_required (mask, nmask,
     +                                 store) 
c
c action: define values to switch on/off for variables "required" in module_clearwin
c author: w.g.bardsley, university of manchester, u.k., 27/06/2020
c
c store = .true. then use mask(i) = 0 to set required(i) = .false. o/w required(i) = .true.
c store = .true. then re-set all required(i) = .true.
c
      use module_clearwin, only : required 
      implicit none 
      integer, intent (in)  :: mask(nmask), nmask 
      logical, intent (in)  :: store 
      integer i 
      if (store) then
c
c decide which logical variables are to be switched on (mask(i).ne.0) or off (mask(i) = 0)
c      
         do i = 1, nmask
            if (mask(i).eq.0) then
               required(i) = .false.
            else
               required(i) = .true. 
            endif     
         enddo
      else
c
c re-set all required(i) = .true.
c        
         do i = 1, 100
            required(i) = .true.
         enddo  
      endif
      end
c
c
      subroutine eb_settings (isend, 
     +                        refresh) 
c
c action: define values for %eb routines
c author: w.g.bardsley, university of manchester, u.k., 08/07/2020
c         13/07/2020 added call to to temporary_yield@                                 
c
c isend = 1 signal editor is in use, viewer is silent, and set refresh_eb to .false. (i.e. call from w_editor on start_up) 
c isend = 2 signal editor is silent, viewer is in_use, and set refresh_eb to .false. (i.e. call from w_viewer on start_up
c o/w just return refresh = refresh_eb
c
      use module_clearwin, only : eb_editor, eb_viewer, refresh_eb 
      implicit none 
      include <windows.ins>
      integer, intent (in)  :: isend 
      logical, intent (out) :: refresh
      call temporary_yield@()
      if (isend.eq.1) then
         eb_editor = .true.
         eb_viewer = .false.
         refresh_eb = .false. 
      elseif (isend.eq.2) then
         eb_editor = .false.
         eb_viewer = .true.
         refresh_eb = .false.
      endif
      refresh = refresh_eb
      call temporary_yield@()
      end
c
c---------------------------------------        
c
      subroutine simplot_tf (fname,
     +                       store)
c     
c action: define test files for simplot
c author: w.g.bardsley, university of manchester, u.k., 16/08/2020
c
      implicit none     
      character (len = *), intent (inout) :: fname
      logical,             intent (in)    :: store  
      character (len = 1024) fname_sav
      character (len = 1   ) blank
      parameter (blank = ' ')
      save       fname_sav
      data       fname_sav / blank /   
      if (store) then
         fname_sav = fname
      else
         fname = fname_sav 
      endif
      end               
c
c-----------------------------------------------------
c      
 