c
c
      subroutine x_savcfg (isend,
     +                     fname_in)
c      
c action: save a file name to the input/output configuration files
c author: w.g.bardsley, university of manchester, u.k, 01/01/2016
c
c Extended and developed from code originally in subroutine OFILES
c
c isend = 1: Save As ... file has been created: add name to w_output.cfg and w_out.tmp
c isend = 2: Open    ... file has been opened : add name to to w_input.cfg and w_in.tmp
c 
c This subroutine does not connect a unit to fname but it does inquire if fname exists
c before attempting to upgrade the cfg files. It does not change fname but writes the
c full path to the cfg files. It is not predictable what happens if the file is actually
c connected but it could fail with ftn95 and also fails if the full path cannot be
c determined by ftn95. Filenames are saved with full path and as lower case. 
c

c
c arguments
c      
      integer,             intent (in) :: isend
      character (len = *), intent (in) :: fname_in
c
c locals
c     
      integer    i, ios, l, nout, nstop
      integer    nfsav
      parameter (nfsav = 200)
      character (len = 1024) fname, fsav1(nfsav), full_name, full_path,
     +                       temp, temp1, temp2, w_fpath2,
     +                       x_sim256
      character (len = 1   ) blank
      parameter (blank = ' ')
      
      CHARACTER (LEN = 12) INPUT_CFG, OUTPUT_CFG, WORD12
      PARAMETER (INPUT_CFG = 'w_input.cfg', OUTPUT_CFG = 'w_output.cfg')
      CHARACTER (LEN = 9 ) W_IN_TMP, W_OUT_TMP
      PARAMETER (W_IN_TMP = 'w_in.tmp', W_OUT_TMP = 'w_out.tmp')
      
      logical    there
      external   x_putfat, x_sim256, w_fpath2, x_getnou, x_addstr,
     +           x_lcase1
      intrinsic  index
      save       temp1, temp2
      data       temp1, temp2 / blank, blank /
c
c check isend and that the file name makes sense and is not a f$123456.tmp type temporary file
c   
      if (isend.lt.1 .or. isend.gt.2) then
         call x_putfat ('ISEND out of range in call to X_SAVCFG')
         return
      endif
      fname = fname_in
      l = len_trim(fname)
      if (l.ge.12) then
         word12 = fname(l - 11:l)
         call x_lcase1 (fname)
         if (word12(1:2).eq.'f$' .and. word12(9:12).eq.'.tmp') return
         if (index(fname,'temporary').gt.0) return  
      endif     
         
      inquire (file = fname, exist = there, iostat = ios)
     
      IF (IOS.EQ.0 .AND. THERE) THEN
C
C get the full path-name for fname and return if this cannot be
C determined or it was saved to the appropriate cfg file last time 
C
         FULL_NAME = W_FPATH2(FNAME)
         IF (FULL_NAME.EQ.BLANK) THEN
            RETURN
         ELSE   
            CALL X_LCASE1 (FULL_NAME)  
         ENDIF   
         IF (ISEND.EQ.1) THEN
            IF (FULL_NAME.EQ.TEMP1) THEN
               RETURN
            ELSE
               TEMP1 = FULL_NAME
            ENDIF 
         ELSE
            IF (FULL_NAME.EQ.TEMP2) THEN
               RETURN
            ELSE
               TEMP2 = FULL_NAME
            ENDIF           
         ENDIF
C
C load the stored values but only if the files exist
C         
         IF (ISEND.EQ.1) THEN                                     
            FULL_PATH = X_SIM256(OUTPUT_CFG)
         ELSE   
            FULL_PATH = X_SIM256(INPUT_CFG)
         ENDIF 
         
         CALL X_GETNOU (NOUT) 
         OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NOUT)
            RETURN 
         ENDIF   
         NSTOP = 1
         FSAV1(NSTOP) = FULL_NAME
         DO WHILE (IOS.EQ.0 .AND. NSTOP.LT.NFSAV - 1)
            READ (NOUT,'(A)',IOSTAT=IOS) TEMP
            IF (IOS.EQ.0 .AND. TEMP.NE.BLANK) THEN
               INQUIRE (FILE = TEMP, EXIST = THERE, IOSTAT = IOS)    
               IF (IOS.EQ.0 .AND. THERE .AND. TEMP.NE.FULL_NAME) THEN
                  NSTOP = NSTOP + 1
                  FSAV1(NSTOP) = TEMP
               ENDIF  
            ENDIF 
         ENDDO 
         CLOSE (UNIT = NOUT)  
         
         OPEN (UNIT = NOUT, FILE = FULL_PATH, IOSTAT = IOS)
         DO I = 1, NSTOP
            WRITE (NOUT,'(A)',IOSTAT=IOS) FSAV1(I)
         ENDDO
         CLOSE (UNIT = NOUT)
C
C Also add filename to w_in.tmp or w_out.tmp
C        
         IF (ISEND.EQ.1) THEN                         
            FULL_PATH = X_SIM256(W_OUT_TMP)            
         ELSE   
            FULL_PATH = X_SIM256(W_IN_TMP) 
         ENDIF              
         CALL X_ADDSTR (FULL_PATH, FULL_NAME)
      ENDIF

      end
c
c         

