c
c
      subroutine x_savgrd (i_colr, i_line, i_wide,
     +                     store)
c
c action: save/restore grid details
c author: w.g.bardsley, university of manchester, u.k., 04/11/2008
c         15/09/2011 derived from savgrd$
c
c i_colr: colour for grid lines     ... -1 =< i_colr =< 71
c i_line: line type for grid lines  ...  1 =< i_line =< 4
c i_wide: width of grid lines       ...  1 =< i_wide =< 5
c
      implicit none
c
c arguments
c      
      integer, intent (inout) :: i_colr, i_line, i_wide
      logical, intent (in)    :: store
c
c locals
c
      integer    numdec, numopt, numsta, numtxt      
      parameter (numdec = 1, numopt = 11, numsta = 3,
     +           numtxt = numsta + numopt - 1)
      integer    icolor, ix, iy, lshade, mode
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 1, mode = 0)
      integer    numbld(numtxt), numpos(numopt)
      integer    i, j_colr, j_line, j_wide
      character  text(numtxt)*100
      logical    first
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   w_rbox01, w_palett
      save       first 
      save       j_colr, j_line, j_wide
      data       first / .true. /
      data       j_colr, j_line, j_wide / -1, 2, 2 / 
c
c First time called then initialise
c      
      if (first) then
         first = .false.
         i_colr = j_colr
         i_line = j_line
         i_wide = j_wide
      endif   
      
      if (store) then
c
c store = .true. so calculate then store parameters
c        
         numbld(1) = 4
         numbld(2) = 0
c
c first 4 options form a ganging group for line type
c
         
         do i = 3, 6
            numbld(i) = 100
         enddo
c
c next 5 options form a ganging group for line width
c         
         do i = 7, 11
            numbld(i) = 200
         enddo
c
c next 2 options forma ganging group for colour
c         
         do i = 12, 13
            numbld(i) = 300
         enddo
c
c check
c      
         if (i_line.lt.1 .or. i_line.gt.4) i_line = 2
         if (i_wide.lt.1 .or. i_wide.gt.5) i_wide = 2
         if (i_colr.lt.0 .or. i_colr.gt.71) i_colr = -1         
c
c initialise the check list
c         
         do i = 1, numopt
            numpos(i) = 0
         enddo
         numpos(i_line) = 1
         numpos(4 + i_wide) = 1
         if (i_colr.lt.0) then
            numpos(numopt - 1) = 1
         else
            numpos(numopt) = 1
         endif 
         write (text,100)
c
c call the check list
c         
         call w_rbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                  numpos, numsta, numtxt,
     +                  text,
     +                  border, flash, high)
c
c register the selections
c     
         do i = 1, 4
            if (numpos(i).gt.0) i_line = i
         enddo
         do i = 5, 9
            if (numpos(i).gt.0) i_wide = i - 4
         enddo
         if (numpos(numopt - 1).gt.0) then
            i_colr = -1
         else
            call w_palett (i_colr, mode)   
         endif
c
c check
c      
         if (i_line.lt.1 .or. i_line.gt.4) i_line = 2
         if (i_wide.lt.1 .or. i_wide.gt.5) i_wide = 2
         if (i_colr.lt.0 .or. i_colr.gt.71) i_colr = -1
c
c store
c                  
         j_colr = i_colr
         j_line = i_line
         j_wide = i_wide                                          
      else
c
c store = .false. so retrieve current parameters
c        
         i_colr = j_colr
         i_line = j_line
         i_wide = j_wide
      endif
c
c format statement
c      
  100 format (
     + 'Set details for grid lines'
     +/'...'
     +/'Line type: normal' 
     +/'Line type: dashed'
     +/'Line type: dotted'
     +/'Line type: dash-dotted'
     +/'Line width: scale by 1/4'
     +/'Line width: scale by 1/2'
     +/'Line width: default'                          
     +/'Line width: scale by 3/2'
     +/'Line width: scale by 2'
     +/'Line colour: default (as axes)'
     +/'Line colour: selected (from palette)')
      end
c
c      