C
C
      SUBROUTINE X_SELSTR (NUMDEC, NUMHLP, NUMSTR,
     +                     HELP, STRNG)
C
C ACTION: Select a string
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 20/10/2000
C         01/12/2000 replaced TBOX02 by LBOX02
C         11/07/2005 increased NMAX from 500 to 2000
C         28/02/2007 added INTENTS and ALLOCATABLES
C         26/05/2011 improved the menu and replaced LBOX02 by LISTBX and PATCH1 by PATCH2
C         28/08/2011 eedited for move into w_clearwin.dll
C
C         NUMDEC: (output) decision returned in range 0 to NUMSTR
C         NUMHLP: (input/unchanged) number of help lines (can be zero)
C         NUMSTR: (input/unchanged) number of text strings (must be > 1, maximum set by NMAX)
C           HELP: (input/unchanged) help text
C          STRNG: (input/unchanged) strings for selection
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NUMHLP, NUMSTR 
      INTEGER,             INTENT (OUT) :: NUMDEC
      CHARACTER (LEN = *), INTENT (IN)  :: HELP(NUMHLP), STRNG(NUMSTR)
C
C Local allocatable arrays
C                         
      INTEGER,               ALLOCATABLE :: NUMBLD(:)
      CHARACTER (LEN = 100), ALLOCATABLE :: TEXT(:)
C
C Locals
C
      INTEGER    I, ICOUNT, IERR, KMAX, NMAX
      CHARACTER  TEMP*95, WORD5*5
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN, ADVISE
      EXTERNAL   X_TRIML1, X_PATCH2, X_LISTBX
      INTRINSIC  MIN, MAX
C
C Check
C
      NUMDEC = 0
      IF (NUMSTR.LT.1) RETURN
C
C Allocate
C         
      IERR = 0
      IF (ALLOCATED(NUMBLD)) DEALLOCATE(NUMBLD, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TEXT)) DEALLOCATE(TEXT, STAT = IERR)
      IF (IERR.NE.0) RETURN  
      NMAX = MAX(1, NUMHLP + 1)
      ALLOCATE (NUMBLD(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = NUMSTR + 3
      ALLOCATE (TEXT(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      DO I = 1, NMAX
         TEXT(I) = BLANK
      ENDDO
      ICOUNT = 0
      IF (NUMHLP.GT.0) THEN
         ADVISE = .TRUE.
         ICOUNT = ICOUNT + 1
         WRITE (TEXT(ICOUNT),100)
         NUMBLD(1) = 1
         DO I = 2, NUMHLP
            NUMBLD(I) = 0
         ENDDO
      ELSE
         ADVISE = .FALSE.
      ENDIF
      ICOUNT = ICOUNT + 1
      WRITE (TEXT(ICOUNT),200) 
      KMAX = MIN(NUMSTR, NMAX - ICOUNT)
      DO I = 1, KMAX
         ICOUNT = ICOUNT + 1
         TEMP = STRNG(I)
         CALL X_TRIML1 (TEMP)
         WRITE (WORD5,300) I
         TEXT(ICOUNT) = WORD5//TEMP
      ENDDO
C
C Menu
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         NUMDEC = 1
         CALL X_LISTBX (NUMDEC, ICOUNT, 
     +                  TEXT)
         IF (ADVISE .AND. NUMDEC.EQ.1) THEN
            AGAIN = .TRUE.
            CALL X_PATCH2 (NUMBLD, NUMHLP,
     +                     HELP)
         ELSE
            AGAIN = .FALSE.
            IF (ADVISE) THEN
               NUMDEC = NUMDEC - 2
            ELSE
               NUMDEC = NUMDEC - 1
            ENDIF
         ENDIF
      ENDDO
C
C Deallocate
C       
      DEALLOCATE(NUMBLD, STAT = IERR)
      DEALLOCATE(TEXT, STAT = IERR)
C
C Format statements
C      
  100 FORMAT ('Help` ')     
  200 FORMAT ('Exit`Accept the items indicated')    
  300 FORMAT (I4,'`')
      END
C
C
