
c
c*********************************************************************************************************
c This routine returns a character variable (len = 12) with up to 11 significant figures
c Note that this is not related to form12 which accepts an integer argument.
c It should be OK as both showlj and showrj call x_ftable which does require a double precision argument.
c*********************************************************************************************************
c
c
      character (len = 12) function x_show12 (x)
c
c action: write a double precision number to x_show12
c author: w.g.bardsley, university of manchester, u.k.
c         28/03/2018 developed from x_form15
c         23/11/2019 used index and dot to find the decimal point  
c         20/04/2021 developed from x_fill12  
c         02/05/2021 stripped off extraneous zeros and changed swap over point to xvbig = ten9
c 
c  nwide = field width 12
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
      integer    i, ios, j, nstart, nstop
      integer    n0, nlast, nwide
      parameter (n0 = 0, nwide = 12, nlast = nwide - 4) 
      double precision absx
      double precision zero, one, ten1, ten2, ten3, ten4, ten5, ten6, 
     +                 ten7, ten8, ten9
      parameter (zero = 0.0d+00,
     +            one = 1.0d+00,
     +           ten1 = 1.0d+01,
     +           ten2 = 1.0d+02,
     +           ten3 = 1.0d+03,
     +           ten4 = 1.0d+04,
     +           ten5 = 1.0d+05,
     +           ten6 = 1.0d+06,
     +           ten7 = 1.0d+07,
     +           ten8 = 1.0d+08,
     +           ten9 = 1.0d+09)
      double precision xsmall, xvbig, xvsmall
      parameter ( xsmall = 0.0001d+00, 
     +             xvbig = ten9, 
     +           xvsmall = 1.0d-300)
      character (len = 12) dfolt, word12
      parameter (dfolt = '************')
      character (len = 1 ) blank, dot, nought
      parameter (blank = ' ', dot = '.', nought = '0')
      intrinsic  abs, adjustr, index
c
c initialise  
c      
      x_show12 = dfolt
      absx = abs(x)

      if (absx.le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         write (word12,'(i10,a2)',iostat=ios) n0, '.0'
         if (ios.eq.0) then
            x_show12 = adjustr(word12)
            return
         endif   
      endif            
      if (absx.ge.xsmall .and. absx.lt.xvbig) then
c
c Case 2: x is suitable for F formatting
c =======
c        
         if (x.gt.zero) then
            if (x.lt.one) then
               write (word12,'(f12.10)',iostat=ios) x
            elseif (x.lt.ten1) then
               write (word12,'(f12.10)',iostat=ios) x
            elseif (x.lt.ten2) then   
               write (word12,'(f12.9)',iostat=ios) x
             elseif (x.lt.ten3) then   
               write (word12,'(f12.8)',iostat=ios) x
            elseif (x.lt.ten4) then   
               write (word12,'(f12.7)',iostat=ios) x
            elseif (x.lt.ten5) then   
               write (word12,'(f12.6)',iostat=ios) x
            elseif (x.lt.ten6) then   
               write (word12,'(f12.5)',iostat=ios) x
             elseif (x.lt.ten7) then   
               write (word12,'(f12.4)',iostat=ios) x
            elseif (x.lt.ten8) then   
               write (word12,'(f12.3)',iostat=ios) x
            elseif (x.lt.ten9) then   
               write (word12,'(f12.2)',iostat=ios) x
            endif      
         else
           if (absx.lt.one) then
               write (word12,'(f12.9)',iostat=ios) x
            elseif (absx.lt.ten1) then
               write (word12,'(f12.9)',iostat=ios) x
            elseif (absx.lt.ten2) then   
               write (word12,'(f12.8)',iostat=ios) x
             elseif (absx.lt.ten3) then   
               write (word12,'(f12.7)',iostat=ios) x
            elseif (absx.lt.ten4) then   
               write (word12,'(f12.6)',iostat=ios) x
            elseif (absx.lt.ten5) then   
               write (word12,'(f12.5)',iostat=ios) x
            elseif (absx.lt.ten6) then   
               write (word12,'(f12.4)',iostat=ios) x
            elseif (absx.lt.ten7) then   
               write (word12,'(f12.3)',iostat=ios) x
            elseif (absx.lt.ten8) then   
               write (word12,'(f12.2)',iostat=ios) x
            elseif (absx.lt.ten9) then  
               write (word12,'(f12.1)',iostat=ios) x
            endif   
         endif  
         if (ios.eq.0) then
c
c strip trailng zeros from F format then right justify
c           
            nstop = index(word12,dot) + 2  
            do i = nwide, nstop, -1
               if (word12(i:i).eq.nought) then
                  word12(i:i) = blank 
               else   
                  exit
               endif
            enddo
            x_show12 = adjustr(word12) 
            return
         endif   
      endif
         
         
c
c Case 3: use 1p,e12.6 or 1p,e12.5
c =======      
c
      if (x.gt.zero) then
         write (word12,'(1p,e12.6)',iostat=ios) x
      else   
         write (word12,'(1p,e12.5)',iostat=ios) x
      endif   
      if (ios.eq.0) then
c
c strip zeros from before E
c        
         nstart = index(word12,dot) + 2
         nstop = nwide
         do i = nlast, nstart, -1
            if (word12(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word12(j:j) = word12(j + 1:j + 1)
               enddo
               word12(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         x_show12 = adjustr(word12)
       endif
      end
c
c   
 






