c
c
      character (len = 21) function x_show21 (x)
c
c Note: x_show21 calculates right-justified character strings for double precision numbers (use in results tables)
c       x_form21 calculates left-justified character strings for double precision numbers (use in numeric control headers)
c action: write a double precision number to x_form21
c author: w.g.bardsley, university of manchester, u.k.
c         18/11/2019 derived from x_form15
c         13/04/2021 now calls x_form21 
c         
c 
c  nwide = field width (21 in form21)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c     
      character (len = 21) x_form21, word21
      external x_form21 
      intrinsic adjustr
      word21 = x_form21(x)
      x_show21 = adjustr(word21)
      end
c
c      