c      
c
      character (len = *) function x_sim256 (pname)
c
c action: returns the full path to simfit file pname or return as a simple copy
c author: w.g.bardsley, university of manchester, u.k.
c         28/01/2007 derived from sim256  
c         12/07/2007 revised for version 6 
c         21/04/2009 added call to x_aux256  
c         02/02/2010 added f$orbits.*  
c         11/01/2011 added temp folder
c         14/01/2011 added call to w_v7path
c         06/04/2011 edited to get tempfile.eps and nagifail.txt right and
c                    now only changes pname if a file is actually found
c         10/05/2011 returns expected path for the ProgramData folder otherwise
c                    searches the simdem and simfit folders
c         06/11/2015 search is performed in possible installations of simfit and
c                    simdem from Part 4 onwards and the function is then only returned
c                    as a full path if fname exists
c         25/11/2015 added w_usemod.err and iterate.dat and restored to previous usage, i.e.
c                    a) up to part 3 the modified name is returned without checking
c                    b) from part 4 onwards checking for esistence is carried out  
c         29/09/2020 added *.html and *.pdf for arbitrary files supposed to be in the doc folder to accomodate the individual tutorials section
c         15/08/2022 if *.html and *.pdf not in the doc folder now tries the dem folder 
c
c Note: pname must be a simple file name and the
c       following simfit installation tree is assumed
c
c       ... simfit\bin
c       ... simfit\dem
c       ... simfit\doc
c       ... ProgramData\Simfit\user\res
c       ... ProgramData\Simfit\user\usr
c       ... ProgramData\Simfit\user\cfg
c
      implicit none 
c
c argument
c         
      character (len = *), intent (in) :: pname
c
c locals
c       
      integer    x_len200
      integer    l1, l2, l3, l4, nmax
      parameter (l1 = 1, nmax = 50)
      character (len = nmax) pcopy
      character (len = 1024) fname, simfit, temp, x_aux256
      character (len = 10  ) word10
      character (len = 9   ) word9
      character (len = 8   ) word8
      character (len = 7   ) word7
      character (len = 5   ) word5
      character (len = 4   ) word4
      character (len = 2   ) word2
      character (len = 1   ) blank, bslash, colon
      parameter (blank = ' ', bslash = '\', colon = ':') 
      logical    there
      external   x_simdir, x_len200, x_lcase1, x_aux256, x_triml1
      external   w_v7path
      intrinsic  index
      
c
c Part 1: initialise x_sim256 = pname then return if pname = blank or is not a simple file name
c =======
c      

      x_sim256 = pname
      if (index(pname,bslash).ne.0 .or.
     +    index(pname,colon) .ne.0 .or.
     +    pname.eq.blank) return  
      l3 = x_len200(pname)  
      if (l3.le.5 .or. l3.gt.nmax) return

c
c define word4 = the file extension 
c        

      pcopy = pname
      call x_triml1 (pcopy)
      l3 = x_len200 (pcopy)
      call x_lcase1 (pcopy)
      word4 = pcopy(l3 - 3:l3)
      
c
c Part 2: try the temp, cfg, and res folders
c =======
c

      call w_v7path (l4,
     +               'tmp', temp) 
      l4 = l4 + 1
      temp(l4:l4) = bslash
      
      if (l3.eq.12) then
         word2 = pcopy(1:2)
         if (word2.eq.'f$' .and. word4.eq.'.tmp') then 
c
c try f$123456.tmp in the temp folder
c           
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_sim256 = fname
         endif
         if (pcopy.eq.'tempfile.txt') then
c
c try tempfile.txt in the temp folder
c     
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_sim256 = fname
            return
         endif      
      endif
       
      if (pcopy.eq.'w_in.tmp' .or.
     +    pcopy.eq.'w_out.tmp') then
c
c try w_in.tmp and w_out.tmp in the temp folder
c     
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_sim256 = fname
         return
      endif   
c
c try .cfg in the cfg folder but not w_simfig*.cfg which are data files in \dem
c
      word7 = pcopy(1:7)
      word8 = pcopy(1:8)
      if (word4.eq.'.cfg'    .and.
     +    word7.ne.'logodds' .and.   
     +    word8.ne.'w_simfig') then
         call w_v7path (l4,
     +                  'cfg', temp)
         l4 = l4 + 1
         temp(l4:l4) = bslash
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_sim256 = fname
         return
      endif 
                
c
c try results  
c     

      call w_v7path (l4,
     +              'res', temp)
      l4 = l4 + 1
      temp(l4:l4) = bslash
      if (l3.ge.11 .and. l3.le.13) then
         word9 = pcopy(1:9)
         if (word9.eq.'f$result.'     .or.
     +       word9.eq.'f$orbits.'     .or.              
     +       pcopy.eq.'w_deqsol.txt'  .or.
     +       pcopy.eq.'w_qnfit.txt'   .or.
     +       pcopy.eq.'w_makdat.txt'  .or.
     +       pcopy.eq.'iterate.dat'   .or.
     +       pcopy.eq.'iterate.txt'   .or.
     +       pcopy.eq.'w_usermod.err' .or.
     +       pcopy.eq.'nagifail.txt') then
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_sim256 = fname
            return
         endif   
      endif
      
      if (word4.eq.'.tmp') then 
         word7 = pcopy(1:7)
         if (word7.eq.'matrix_' .or.
     +       word7.eq.'vector_' .or.
     +       word7.eq.'curfit_') then  
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_sim256 = fname
            return
         endif 
         word10 = pcopy(1:10)
         if (word10.eq.'clipboard_') then 
            fname = temp(l1:l4)//pcopy(l1:l3)
            x_sim256 = fname
            return
         endif   
      endif
      
c
c try user  
c     

      if (pcopy.eq.'tempfile.eps') then
         call w_v7path (l4,
     +              'usr', temp)
         l4 = l4 + 1
         temp(l4:l4) = bslash
         fname = temp(l1:l4)//pcopy(l1:l3)
         x_sim256 = fname
         return
      endif
      
c
c part 4: Not a standard file so try the simfit or simdem folders 
c =======
c
        
      call x_simdir (l2,
     +               simfit)
      if (l2.le.2) then
c
c try to get the file from the simdem folder
c        
         fname = x_aux256 (pname)
         inquire (file = fname, exist = there)
         if (there) then
            x_sim256 = fname
            return  
         endif   
      endif   


c check number 1:  check for simfit executables in the bin folder
c ===============    
c
      
      if (word4.eq.'.exe') then 
c
c try .exe in the simfit folder 
c        
         fname = simfit(l1:l2)//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_sim256 = fname
            return
         endif   
      endif

c
c check number 2: check for simfit documentation in the doc folder
c ===============
c
      
      if (l3.ge.9 .and. l3.le.18) then
         if (pcopy.eq.'install.txt'        .or.
     +       pcopy.eq.'configure.txt'      .or.
     +       pcopy.eq.'linux.txt'          .or.
     +       pcopy.eq.'errors.txt'         .or.
     +       pcopy.eq.'readme.txt'         .or.
     +       pcopy.eq.'commands.txt'       .or.
     +       pcopy.eq.'w_manual.pdf'       .or.
     +       pcopy.eq.'w_manual.ps'        .or.
     +       pcopy.eq.'pscodes.pdf'        .or.
     +       pcopy.eq.'pscodes.ps'         .or.
     +       pcopy.eq.'ms_office.pdf'      .or.
     +       pcopy.eq.'simfit_summary.pdf' .or.
     +       pcopy.eq.'speedup.pdf'        .or.
     +       pcopy.eq.'tutorials.pdf'      .or.
     +       pcopy.eq.'configure.pdf'      .or.
     +       pcopy.eq.'install.pdf'        .or.
     +       pcopy.eq.'w_examples.pdf') then
            fname = simfit(l1:l2 - 4)//'doc\'//pcopy(l1:l3)
            inquire (file = fname, exist = there)
            if (there) then
               x_sim256 = fname
               return
            endif   
         endif
      endif   

      word5 = pcopy(l3 - 4:l3)
      if (word4.eq.'.pdf' .or. word5.eq.'.html') then
         fname = simfit(l1:l2 - 4)//'doc\'//pcopy(l1:l3)
         inquire (file = fname, exist = there)
         if (there) then
            x_sim256 = fname
            return
         else  
            fname = simfit(l1:l2 - 4)//'dem\'//pcopy(l1:l3) 
            inquire (file = fname, exist = there)
            if (there) then
               x_sim256 = fname
               return
            endif   
         endif   
      endif

      if (l3.ge.8) then
         if (word8.eq.'w_readme') then
            fname = simfit(l1:l2 - 4)//'doc\'//pcopy(l1:l3)
            inquire (file = fname, exist = there)
            if (there) then
               x_sim256 = fname
               return
            endif   
         endif   
      endif
      
c
c check number 3: the dem folder
c ===============
c                            
     
      fname = simfit(l1:l2 - 4)//'dem\'//pcopy(l1:l3)
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif
c
c check number 4: search for possible installations
c ===============
c      
      call w_v7path (l4,
     +               'p64', temp)
      l4 = l4 + 1
      temp(l4:l4) = bslash
      
      fname = temp(l1:l4)//'simfit\bin\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simfit\dem\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simfit\doc\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simdem\bin\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simdem\dem\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simdem\doc\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      call w_v7path (l4,
     +               'p32', temp)
      l4 = l4 + 1
      temp(l4:l4) = bslash
      
      fname = temp(l1:l4)//'simfit\bin\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simfit\dem\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simfit\doc\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif
      fname = temp(l1:l4)//'simdem\bin\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simdem\dem\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif

      fname = temp(l1:l4)//'simdem\doc\'//pcopy(l1:l3) 
      inquire (file = fname, exist = there)
      if (there) then
         x_sim256 = fname
         return
      endif
      end
c
c  