C
C
      SUBROUTINE X_STRCHK (STRNG)
C
C ACTION : Check that parentheses balance, etc. in a PostScript string
C AUTHOR : W.G.Bardsley, University of Manchester, U.K. 7/12/95
C          17/11/2003 improved warning system and default exit after
C                     NMAX tries to repair 
C          22/04/2007 added INTENTS
C          28/08/2011 moved into w_clearwin.dll
C
      IMPLICIT   NONE  
C
C Argument
C              
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG
C
C Locals
C      
      INTEGER    IDIM1, NMAX
      PARAMETER (IDIM1 = 80, NMAX = 2)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 22)
      INTEGER    NUMBLD(30)
      INTEGER    N0, N1, N2, N3, N5, N7
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5, N7 = 7)
      INTEGER    ISTORE(IDIM1), JSTORE(IDIM1), KSTORE(IDIM1), NSTORE(N3)
      INTEGER    I, ICOUNT, IOS, J, K, L, LENSTR, X_LEN200, N, NLEFT,
     +           NRIGHT, NWRONG
      CHARACTER  LETTER*1, LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  X(N5)*2
      CHARACTER  BL*1, BR*1, BS*1, DBK*2, DBS*2
      PARAMETER (BL = '(', BR = ')', BS = '\', DBK = '  ', DBS = '\\')
      CHARACTER  BSL*2, BSR*2, FS*1, SL*1, SR*1
      PARAMETER (BSL = '\(', BSR = '\)', FS = '/', SL = '[', SR = ']')
      LOGICAL    BORDER, FIRST
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   X_GETSTR, X_STRSUB
      EXTERNAL   X_LEN200, W_PATCH1
      SAVE       FIRST
      INTRINSIC  INDEX
      DATA       X / '\n', '\r', '\t', '\b', '\f' /
      DATA       NUMBLD / 30*0 /
      DATA       FIRST / .TRUE. /
C
C Check for empty string then initialise ICOUNT
C
      IF (STRNG.EQ.BLANK) RETURN
      LENSTR = X_LEN200(STRNG)
      ICOUNT = N0
C
C LABEL 20: Start of loop for repeat editing
C ========
C
   20 CONTINUE
C
C Set NSTORE = 0 then check for single faulty character
C
      DO I = N1, N3
         NSTORE(I) = N0
      ENDDO
      IF (STRNG.EQ.BL .OR. STRNG.EQ.BR) THEN
         WRITE (LINE,100)
         GOTO 40
      ENDIF
      IF (STRNG.EQ.BS) THEN
         WRITE (LINE,200)
         GOTO 40
      ENDIF
C
C First of all remove all double backslashes \\
C
      IF (INDEX(STRNG, DBS).GT.N0) THEN
         CALL X_STRSUB (IDIM1, ISTORE, NSTORE(N1),
     +                  DBS, STRNG)
         DO I = 1, NSTORE(N1)
            J = ISTORE(I)
            STRNG(J:J + N1) = DBK
         ENDDO
      ENDIF
C
C Now remove all backslash left parentheses \(
C
      IF (INDEX(STRNG, BSL).GT.N0) THEN
         CALL X_STRSUB (IDIM1, JSTORE, NSTORE(N2),
     +                  BSL, STRNG)
         DO I = 1, NSTORE(N2)
            J = JSTORE(I)
            STRNG(J:J + N1) = DBK
         ENDDO
      ENDIF
C
C Now remove all backslash right parentheses \)
C
      IF (INDEX(STRNG, BSR).GT.N0) THEN
         CALL X_STRSUB (IDIM1, KSTORE, NSTORE(N3),
     +                  BSR, STRNG)
         DO I = 1, NSTORE(N3)
            J = KSTORE(I)
            STRNG(J:J + N1) = DBK
         ENDDO
      ENDIF
C
C Check for forbidden strings
C
      DO I = N1, N5
         IF (INDEX(STRNG, X(I)).GT. N0) THEN
            WRITE (LINE,200)
            GOTO 40
         ENDIF
      ENDDO
C
C Check for unbalanced parentheses
C
      NLEFT = N0
      NRIGHT = N0
      NWRONG = N0
      DO I = N1, LENSTR
         LETTER = STRNG(I:I)
         IF (LETTER.EQ.BL) THEN
            NLEFT = NLEFT + N1
         ELSEIF (LETTER.EQ.BR) THEN
            NRIGHT = NRIGHT + N1
            IF (NRIGHT.GT.NLEFT) NWRONG = NWRONG + N1
         ENDIF
      ENDDO
      IF (NLEFT.NE.NRIGHT .OR. NWRONG.NE.N0) THEN
         WRITE (LINE,100)
         GOTO 40
      ENDIF
C
C Check for isolated backslashes not as part of octal codes
C
      IF (INDEX(STRNG, BS).GT.N0) THEN
         K = LENSTR - N3
         DO I = N1, LENSTR
            IF (STRNG(I:I).EQ.BS) THEN
               IF (I.GT.K) THEN
                  WRITE (LINE,200)
                  GOTO 40
               ENDIF
               DO N = N1, N3
                  LETTER = STRNG(I + N:I + N)
                  READ (LETTER,'(I1)',IOSTAT=IOS) L
                  IF (IOS.NE.N0) THEN
                     WRITE (LINE,200)
                     GOTO 40
                  ENDIF
                  IF (L.LT.N0 .OR. L.GT.N7) THEN
                     WRITE (LINE,200)
                     GOTO 40
                  ENDIF
               ENDDO
            ENDIF
         ENDDO
      ENDIF
C
C OK so restore \\ that were stripped out then return
C
      IF (NSTORE(N1).GT.N0) THEN
         DO I = 1, NSTORE(N1)
            J = ISTORE(I)
            STRNG(J:J + N1) = DBS
         ENDDO
      ENDIF
C
C OK so restore \( that were stripped out then return
C
      IF (NSTORE(N2).GT.N0) THEN
         DO I = 1, NSTORE(N2)
            J = JSTORE(I)
            STRNG(J:J + N1) = BSL
         ENDDO
      ENDIF
C
C OK so restore \) that were stripped out then return
C
      IF (NSTORE(N3).GT.N0) THEN
         DO I = 1, NSTORE(N3)
            J = KSTORE(I)
            STRNG(J:J + N1) = BSR
         ENDDO
      ENDIF
      RETURN
C
C LABEL 40: Crash so restore \\ that were stripped out then try again
C =========
C
   40 CONTINUE
      IF (FIRST) THEN
         FIRST = .FALSE.
         WRITE (TEXT,300)
         NUMBLD(N1) = N1
         CALL W_PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                  TEXT,
     +                  BORDER)
      ENDIF
      ICOUNT = ICOUNT + N1
      IF (ICOUNT.GT.NMAX) THEN
         DO I = N1, LENSTR
            LETTER = STRNG(I:I)
            IF (LETTER.EQ.BL) THEN
               STRNG(I:I) = SL
            ELSEIF (LETTER.EQ.BR) THEN
               STRNG(I:I) = SR
            ELSEIF (LETTER.EQ.BS) THEN
               STRNG(I:I) = FS
            ENDIF
         ENDDO
      ENDIF
C
C Restore \\ that were stripped out
C
      IF (NSTORE(N1).GT.N0) THEN
         DO I = 1, NSTORE(N1)
            J = ISTORE(I)
            STRNG(J:J + N1) = DBS
         ENDDO
      ENDIF
C
C Restore \( that were stripped out
C
      IF (NSTORE(N2).GT.N0) THEN
         DO I = 1, NSTORE(N2)
            J = JSTORE(I)
            STRNG(J:J + N1) = BSL
         ENDDO
      ENDIF
C
C Restore \) that were stripped out
C
      IF (NSTORE(N3).GT.N0) THEN
         DO I = 1, NSTORE(N3)
            J = KSTORE(I)
            STRNG(J:J + N1) = BSR
         ENDDO
      ENDIF
      IF (ICOUNT.GT.NMAX) THEN
         RETURN
      ELSE
         CALL X_GETSTR (LINE, STRNG)
         GOTO 20
      ENDIF 
C
C Format statements
C      
  100 FORMAT (
     +'Parentheses ( and/or ) until balanced ... or else use \( and \)')
  200 FORMAT (
     +'\\, \\n, \\r, \\t, \\b, \\f...to replace \, \n, \r, \t, \b, \f')
  300 FORMAT (
     + 'Concerning ambiguities in PostScript character strings'
     +/
     +/'Character strings passed to PostScript interpreters should not'
     +/'contain ambiguities that could result from unintentional use of'
     +/'PS-reserved escape sequences. So for that reason substitutions'
     +/'such as \\ instead of \ should be used, for example:'
     +/'for \n use \\n'
     +/'for \r use \\r'
     +/'for \t use \\t'
     +/'for \b use \\b'
     +/'for \f use \\f, i.e. in general, for \ use \\ (but see next).'
     +/'Single backslashes can only be used as octal codes, e.g. \277'
     +/'for upside down question mark, \326 for square root in Symbol'
     +/'font, or \361 for n tilde in ISOLatin1 encoding, etc.'
     +/'Parentheses should be balanced as in f(x,y) = x(x + y) but, for'
     +/'isolated parentheses, the following substitutions can be used:'
     +/'for ( use \('
     +/'for ) use \), e.g. Figure 1) is wrong but Figure 1\) is OK.'
     +/'If Simfit detects an ambiguity you will be given two attempts'
     +/'at correction then a repair will be attempted, but note that'
     +/'editing at this stage is temporary, so for a permanent change'
     +/'you must edit the original character string.')
      END
C
C