C 
C
      SUBROUTINE X_STREDI (ARRAY, STRNG)
C
C ACTION : Edit a STRING/ARRAY PostScript pair
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 18/12/95 
C          08/10/1996 increased number of options
C          07/11/1996 added code for A, B, C keys
C          16/10/1998 added EDISTR$ but kept the original code to
C                     make the program flow more transparent
C          22/11/1999 added key = K for Symbol font
C          17/11/2000 added key = L for bold Symbol font and indicated
C                     the Windows use for keys 7 and 9
C          15/12/2003 added error messages
C          17/12/2003 extensive revision
C          18/12/2003 introduced copies for ASAV2 and SSAV2 in COMMON
C          24/12/2003 changed insertion from LHS to RHS
C          21/03/2007 added INTENTS 
C          12/06/2007 removed COMMON block for ASAV2_COPY and SSAV2_COPY
C          28/08/2011 moved into w_clearwin.dll
C
C          ARRAY: (input/output) string of index-keys to control plotting
C          STRNG: (input/output) string of characters for plotting
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAY, STRNG 
C
C Locals
C      
      INTEGER    I, ISEND, J, K,
     +           KA, KS, LA, LB, NFIX1, NFIX2, NTEMP1, NTEMP2
      INTEGER    X_LEN200
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N20, N22, N127
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N20 = 20, N22 = 22, N127 = 127)
      INTEGER    ICOLOR, IXL, IYL, NUMDEC, NUMOPT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4)
      INTEGER    NUMPOS(30)
      INTEGER    NUMCHAR
      CHARACTER  ASAV1*1, ASAV2*80, ASAV3*5,
     +           SSAV1*1, SSAV2*80, SSAV3*20
      CHARACTER  TEXT(30)*100
      CHARACTER  ERROR*100
      CHARACTER  BLANK*1, QUEST*1
      PARAMETER (BLANK = ' ', QUEST = '?')
      CHARACTER  LETTER(0:21)*1
      LOGICAL    FOUND, REPEET
      EXTERNAL   X_TRIML1, X_LEN200, X_LBOX02
      EXTERNAL   X_PUTADV, X_GETSTR, X_PUTFAT, X_STRCHK, W_EDISTR,
     +           W_ACCENT
      INTRINSIC  LEN, ICHAR, CHAR 
      DATA       NUMPOS / 30*1 /
      DATA       LETTER / '0', '1', '2', '3', '4', '5', '6', '7', '8',
     +                    '9',
     +                    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
     +                    'J', 'K', 'L' /
C
C Find the string lengths
C
      LA = LEN(ARRAY)
      IF (LA.LT.N3) THEN
         ERROR = 'ERROR 1: Index is too short'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      LB = LEN(STRNG)
      IF (LB.LT.N3) THEN
         ERROR = 'ERROR 2: String is too short'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
C
C Check that the ARRAY makes sense
C
      CALL X_TRIML1 (ARRAY)
      ASAV1 = ARRAY(N1:N1)
      IF (ASAV1.NE.'(') THEN
         ERROR = 'ERROR 3: Index does not start with ('
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      NTEMP2 = X_LEN200(ARRAY)
      IF (ARRAY(NTEMP2 - N2:NTEMP2).EQ.')fx') THEN
         NTEMP2 = X_LEN200(ARRAY) - N3
         ASAV3 = ')fx'
      ELSEIF (ARRAY(NTEMP2 - N3:NTEMP2).EQ.') fx') THEN
         NTEMP2 = X_LEN200(ARRAY) - N4
         ASAV3 = ') fx'
      ELSEIF (ARRAY(NTEMP2 - N4:NTEMP2).EQ.')  fx') THEN
         NTEMP2 = X_LEN200(ARRAY) - N5
         ASAV3 = ')  fx'
      ELSE
         ERROR = 'ERROR 4: Index does not end in )fx, ) fx, or )  fx'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      NTEMP1 = N2
      IF (NTEMP2.LT.NTEMP1) THEN
         ERROR = 'ERROR 5: Index is too short'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      ASAV2 = ARRAY(NTEMP1:NTEMP2)
      KA = X_LEN200(ASAV2)
C
C Check that STRING makes sense
C
      CALL X_TRIML1 (STRNG)
      SSAV1 = STRNG(N1:N1)
      IF (SSAV1.NE.'(') THEN
         ERROR = 'ERROR 6: String does not start with ('
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      NFIX2 = X_LEN200(STRNG)
      NFIX1 = NFIX2 + N1
      FOUND = .FALSE.
      DO I = N1, NFIX2
         IF (.NOT.FOUND) THEN
            NFIX1 = NFIX1 - N1
            IF (STRNG(NFIX1:NFIX1).EQ.')') FOUND = .TRUE.
         ENDIF
      ENDDO
      IF (.NOT.FOUND) THEN
         ERROR = 'ERROR 7: String does not end with )'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      NTEMP1 = N2
      NTEMP2 = NFIX1 - N1
      IF (NTEMP2.LT.NTEMP1) THEN
         ERROR = 'ERROR 8: String is too short'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      SSAV2 = STRNG(NTEMP1:NTEMP2)
      SSAV3 = STRNG(NFIX1:NFIX2)
      IF (SSAV3(N1:N1).NE.')') THEN
         ERROR = 'ERROR 9: String does not end with )'
         CALL X_PUTADV (ERROR)
         RETURN
      ENDIF
      KS = X_LEN200(SSAV2)
      LA = LA - X_LEN200(ASAV1) - X_LEN200(ASAV3)
      LB = LB - X_LEN200(SSAV1) - X_LEN200(SSAV3)
      NUMDEC = N9
C
C Main branch point for repeated editing
C ======================================
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Call the advanced editing control
C
         CALL W_EDISTR (NUMCHAR, NUMDEC,
     +                  SSAV2, ASAV2)
         IF (NUMDEC.EQ.N1) THEN
C
C Edit a character (and associated index-key automatically)
C
            J = NUMCHAR
            IF (J.GE.N0) THEN
               WRITE (TEXT,100)
               ISEND = N1
               NUMOPT = N6
               CALL X_LBOX02 (ICOLOR, IXL, IYL, ISEND, NUMOPT, NUMPOS,
     +                        TEXT)
               IF (ISEND.EQ.1) THEN
                  CALL X_GETSTR ('New text (or edit current text)',
     +                           SSAV2(J:J))
                  IF (ICHAR(SSAV2(J:J)).LT.N127) THEN
                     ASAV2(J:J) = '0'
                  ELSE
                     ASAV2(J:J) = '8'
                  ENDIF
               ELSE
                  IF (ISEND.EQ.N2) THEN
                     ISEND = N8
                  ELSEIF (ISEND.EQ.N3) THEN
                     ISEND = N20
                  ELSEIF (ISEND.EQ.N4) THEN
                     ISEND = N3
                  ELSEIF (ISEND.EQ.N5) THEN
                     ISEND = N7
                  ELSE
                     ISEND = N9
                  ENDIF
                  I = ICHAR(SSAV2(J:J))
                  CALL W_ACCENT (ISEND, I)
                  SSAV2(J:J) = CHAR(I)
                  ASAV2(J:J) = LETTER(ISEND)
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Edit a key
C
            J = NUMCHAR
            IF (J.GT.N0) THEN
               WRITE (TEXT,200)
               I = N1
               NUMOPT = N22
               CALL X_LBOX02 (ICOLOR, IXL, IYL, I, NUMOPT, NUMPOS,
     +                        TEXT)
               ASAV2(J:J) = LETTER(I - N1)
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Delete a character (and associated index-key automatically)
C
            IF (KS.EQ.N0) THEN
               CALL X_PUTFAT ('Nothing left to delete')
            ELSE
               J = NUMCHAR
               IF (J.GT.N0) THEN
                  IF (J.LT.KS) THEN
                     DO I = J, KS - N1
                        SSAV2(I:I) = SSAV2(I + N1:I + N1)
                     ENDDO
                  ENDIF
                  SSAV2(KS:KS) = BLANK
                  KS = KS - N1
                  IF (J.LT.KA) THEN
                     DO I = J, KA - N1
                        ASAV2(I:I) = ASAV2(I + N1:I + N1)
                     ENDDO
                  ENDIF
                  ASAV2(KA:KA) = BLANK
                  KA = KA - N1
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Delete a key
C
            IF (KA.EQ.N0) THEN
               CALL X_PUTFAT ('Nothing left to delete')
            ELSE
               J = NUMCHAR
               IF (J.GT.N0) THEN
                  IF (J.LT.KA) THEN
                     DO I = J, KA - N1
                        ASAV2(I:I) = ASAV2(I + N1:I + N1)
                     ENDDO
                  ENDIF
                  ASAV2(KA:KA) = QUEST
                  KA = KA - N1
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Insert a letter
C
            IF (KS.EQ.LB .OR. KA.EQ.LA) THEN
               CALL X_PUTFAT ('No space for more text/index-keys')
            ELSE
               J = NUMCHAR
               IF (J.GT.N0) THEN
                  J = J + N1
                  K = KS + N1
                  IF (J.LT.K) THEN
                     DO I = KS, J, - N1
                        SSAV2(I + N1:I + N1) = SSAV2(I:I)
                     ENDDO
                  ENDIF
                  KS = KS + N1
                  K = KA + N1
                  IF (J.LT.K) THEN
                     DO I = KA, J, - N1
                        ASAV2(I + N1:I + N1) = ASAV2(I:I)
                     ENDDO
                  ENDIF
                  KA = KA + N1
                  WRITE (TEXT,100)
                  ISEND = N1
                  NUMOPT = N6
                  CALL X_LBOX02 (ICOLOR, IXL, IYL, ISEND, NUMOPT,
     +                           NUMPOS,
     +                           TEXT)
                  IF (ISEND.EQ.1) THEN
                     SSAV2(J:J) = BLANK
                     CALL X_GETSTR ('New character required',
     +                              SSAV2(J:J))
                     IF (ICHAR(SSAV2(J:J)).LT.N127) THEN
                        ASAV2(J:J) = '0'
                     ELSE
                        ASAV2(J:J) = '8'
                     ENDIF
                  ELSE
                     IF (ISEND.EQ.N2) THEN
                        ISEND = N8
                     ELSEIF (ISEND.EQ.N3) THEN
                        ISEND = N20
                     ELSEIF (ISEND.EQ.N4) THEN
                        ISEND = N3
                     ELSEIF (ISEND.EQ.N5) THEN
                        ISEND = N7
                     ELSE
                        ISEND = N9
                     ENDIF
                     I = ICHAR(SSAV2(J:J))
                     CALL W_ACCENT (ISEND, I)
                     SSAV2(J:J) = CHAR(I)
                     ASAV2(J:J) = LETTER(ISEND)
                  ENDIF
               ENDIF
            ENDIF
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Insert a key
C
            IF (KA.EQ.LA) THEN
               CALL X_PUTFAT ('No space for more keys')
            ELSE
               J = NUMCHAR
               IF (J.GT.N0) THEN
                  J = J + N1
                  K = KA + N1
                  IF (J.LT.K) THEN
                     DO I = KA, J, - N1
                        ASAV2(I + N1:I + N1) = ASAV2(I:I)
                     ENDDO
                  ENDIF
                  WRITE (TEXT,200)
                  I = N1
                  NUMOPT = N22
                  CALL X_LBOX02 (ICOLOR, IXL, IYL, I, NUMOPT, NUMPOS,
     +                           TEXT)
                  ASAV2(J:J) = LETTER(I - N1)
                  KA = KA + N1
               ENDIF
            ENDIF
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Check the string
C
      CALL X_STRCHK (SSAV2)
      KS = X_LEN200(SSAV2)
      IF (KS.GT.KA) THEN
         DO I = KA + N1, KS
            ASAV2(I:I) = QUEST
         ENDDO
         KA = KS
      ELSEIF (KS.LT.KA) THEN
         DO I = KS + N1, KA
            ASAV2(I:I) = BLANK
         ENDDO
         KA = KS
      ENDIF
      ARRAY = ASAV1//ASAV2(N1:KA)//ASAV3
      STRNG = SSAV1//SSAV2(N1:KS)//SSAV3(N1:NFIX2 - NFIX1 + N1)
C
C Format statements
C      
  100 FORMAT (
     + 'Use Keyboard/Keypad'
     +/'Mouse click (Latin)'
     +/'Mouse click (Symbol)'
     +/'Mouse click (Maths)'
     +/'Mouse click (Wingdings)'
     +/'Mouse click (Webdings)')
  200 FORMAT (
     + '0: normal'
     +/'1: normal subscript'
     +/'2: normal superscript'
     +/'3: maths'
     +/'4: maths subscript'
     +/'5: maths superscript'
     +/'6: maths bold'
     +/'7: ZapfDingbats (PS), WingDings (Windows)'
     +/'8: Isolatin1Encoding'
     +/'9: special (PS), Webdings (Windows)'
     +/'A: grave'
     +/'B: acute'
     +/'C: hat (circumflex)',
     +/'D: tilde'
     +/'E: bar (macron/overline)'
     +/'F: dieresis'
     +/'G: maths-hat'
     +/'H: maths-bar'
     +/'I: maths-hat bold'
     +/'J: maths-bar bold'
     +/'K: Symbol'
     +/'L: Symbol bold')
      END
C
c