C
C
      SUBROUTINE X_STRSUB (IDIM1, ISTORE, NSTORE, 
     +                     SUBSTR, STRNG)
C
C ACTION : Find substrings SUBSTR in a string STRING
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          26/11/1999 corrected calculation of NSTART
C          23/04/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: IDIM1
      INTEGER,             INTENT (OUT) :: ISTORE(IDIM1), NSTORE 
      CHARACTER (LEN = *), INTENT (IN)  :: SUBSTR, STRNG
C
C Locals
C      
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    ITEMP, NLEN, NSTART, NSTOP
      EXTERNAL   X_PUTFAT
      INTRINSIC  INDEX, LEN
C
C Initialise ISTORE and NSTORE
C
      NSTORE = N0
      DO ITEMP = N1, IDIM1
         ISTORE(ITEMP) = N0
      ENDDO
      ITEMP = INDEX(STRNG, SUBSTR)
      IF (ITEMP.LE.N0) THEN
         RETURN
      ELSE
         NSTORE = NSTORE + N1
         ISTORE(NSTORE) = ITEMP
         NLEN = LEN(SUBSTR)
         NSTART = ISTORE(NSTORE) + NLEN
         NSTOP = LEN(STRNG)
      ENDIF
      DO WHILE (NSTART.LE.NSTOP - N1)
         ITEMP = INDEX(STRNG(NSTART:NSTOP), SUBSTR)
         IF (ITEMP.GT.N0) THEN
            NSTORE = NSTORE + N1
            ISTORE(NSTORE) = NSTART + ITEMP - N1
         ELSE
            RETURN
         ENDIF
         NSTART = ISTORE(NSTORE) + NLEN
         IF (NSTORE.EQ.IDIM1) THEN
            CALL X_PUTFAT (
     +     'Max. dimension of ISTORE reached in X_STRSUB')
            RETURN
         ENDIF
      ENDDO
      END
C
C
