c
c
      recursive subroutine x_switch (mode)
c
c action: toggle on/off or re-configure the speedup options 
c author: w.g.bardsley, university of manchester, u.k., 17/08/2015
c
c         04/10/2017 must not be called unless add_stop_option is disabled in w_lbox01 
c         10/12/2017 made it recursive
c      
c
c mode =  4,  5,  6,  7,  8,  9 ... toggle corresponding nval(mode)
c mode = 31, 32, 33, 34, 35, 36 ... toggle corresponding kval(mode - 24) as follows
c      = 31: open/view/cancel
c      = 32: Windows messages
c      = 33: now input
c      = 34: type-in
c      = 35: first-time user message
c      = 36: advanced graphics exit
c otherwise diplay the options
c 
c Note: output format for writing first line to w_simfit.cfg is i5,1x,a
c      
      implicit   none
c
c argument
c      
      integer, intent (in) :: mode
c
c locals
c      
      integer    n1, n_items
      parameter (n1 = 1, n_items = 12)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 5, numsta = 6)
      integer    kval(n_items), lval(n_items), nval(n_items)
      integer    isend, num_in, num_out
      integer    i, iadd1, ios, k, l, nout
      integer    k_input, n_input
      integer    numbld(30)  
      character (len = 1024) cval(n_items)
      character (len = 1024) path, full_path
      character (len = 100 ) line, text(30) 
      character (len = 10  ) cipher
      character (len = 1   ) blank, pcent
      parameter (blank = ' ', pcent = '%')
      logical    extra, op, repeet, suppress
      logical    read_only, there
      data       numbld / 30*0 /
      external   x_cfgdir, x_attrib, x_getnou, x_putfat, x_lstbox,
     +           x_putadv, x_getcfg 
      external   speedup, help_speedup
      intrinsic  index
      
      suppress = .false.
      kval(1) = 1!to silence ftn95
      nval(1) = kval(1)!to silence ftn95
      kval(1) = nval(1)!to silence ftn95

c
c define k_input and n_input
c      
      k_input = 0
      n_input = 0
      if (mode.ge.4 .and. mode.le.9) then
         n_input = mode
      elseif (mode.ge.31 .and. mode.le.36) then
         k_input = mode - 24
      endif     
      if (k_input.lt.0 .or. k_input.gt.n_items) k_input = 0
      if (n_input.lt.0 .or. n_input.gt.n_items) n_input = 0
c
c initialise ios = 0 then get configuration file details
c      
      ios = 0
      call x_cfgdir (k,
     +               path)      
      full_path = path(1:k)//'w_simfit.cfg'
      call x_attrib (full_path,
     +               there, read_only)      
      if (.not.there) then  
c        
c check for error 1            
c
         write (line,100) 
         call x_putfat (line)
         return
      elseif (read_only) then
c        
c check for error 2            
c      
         write (line,200)
         call x_putfat (line)
         return
      else
c        
c check for error 3            
c        
         inquire (file = full_path, opened = op, iostat = ios) 
         if (ios.eq.0 .and. op) then
            write (line,300) 
            return
         endif
         call x_getnou (nout) 
         open (unit = nout, file = full_path, iostat = ios)   
      endif 
      if (ios.ne.0) then
c        
c check for error 4 (should never happen)           
c        
         write (line,400) ios
         call x_putfat (line)
         close (unit = nout)
         return
      else
         iadd1 = 0
         do while (ios.eq.0 .and. iadd1.lt.48)
            iadd1 = iadd1 + 1
            if (iadd1.eq.1) then
               read (nout,'(a)',iostat=ios) line
               if (ios.ne.0) then
c        
c check for error 5            
c                 
                  write (line,500) ios
                  call x_putfat (line)
                  close (unit = nout)
                  return
               endif   
               k = index(line,pcent)
c        
c check for error 6            
c               
               if (k.le.0) then
                  write (line, 600)
                  call x_putfat (line)
                  close (unit = nout)
                  return 
               endif 
               read (line(1:k - 1),*,iostat=ios) nval(iadd1)
c        
c check for error 7            
c               
               if (ios.ne.0) then
                  write (line,700) ios
                  call x_putfat (line)
                  close (unit = nout)
                  return
               endif
               l = len_trim(line)
               cipher = blank
               cipher(1:l - k + 1) = line(k:l) 
            elseif (iadd1.le.12) then
               read (nout,*, iostat = ios) nval(iadd1)
            elseif (iadd1.le.24) then
               read (nout,'(a)',iostat=ios) cval(iadd1 - 12)
            elseif (iadd1.le.36) then
               read (nout,*,iostat=ios) kval(iadd1 - 24) 
            elseif (iadd1.le.48) then 
               read (nout,*,iostat=ios) lval(iadd1 - 36)                              
            endif
         enddo           
      endif
      close (unit = nout)
      if (iadd1.ne.48) then
c        
c check for error 8            
c        
         write (line,800) iadd1
         call x_putfat (line)
         return
      endif

c
c find out how many options are in (num_in) and how many out (num_out)
c
      isend = 0
      call speedup (isend, kval, nval, n_items, num_in, num_out,
     +              extra) 
      if (n_input.ne.0) then
c
c toggle nval(n_input)
c        
         if (nval(n_input).ne.0) then
            suppress = .true.
            nval(n_input) = 0
         else
            nval(n_input) = 1
         endif      
      elseif (k_input.ne.0) then
c
c toggle kval(k_input)
c      
         if (kval(k_input).ne.0) then
            suppress = .true.
            kval(k_input) = 0
         else
            kval(k_input) = 1
         endif      
      else      
c
c offer speedup re-configuration options
c
         repeet = .true.
         do while (repeet)
            write (text,900) num_in, num_out
            numdec = numopt - 1
            numtxt = numsta + numopt - 1
            numbld(1) = 1
            call x_lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                     text)
            numbld(1) = 0
            repeet = .false.
            if (numdec.le.3) then
               isend = numdec
               extra = .false.
               call speedup (isend, kval, nval, n_items, num_in,
     +                       num_out,
     +                       extra) 
            elseif (numdec.eq.numopt - 1) then
               call help_speedup('speedup')
               repeet = .true.
            else
               return   
            endif
         enddo
      endif
c
c write new data to the file w_simfit.cfg
c         
      call x_getnou (nout)
      open (unit = nout, file = full_path, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         write (line,1100)
         call x_putfat (line)
         return
      endif
      write (nout,1200,iostat=ios) nval(1), cipher  
      do i = 2, n_items
         write (nout,'(i5)', iostat=ios) nval(i) 
      enddo   
      do i = 1, n_items
         k = len_trim(cval(i))
         write (nout,'(a)',iostat=ios) cval(i)(1:k)
      enddo
      do i = 1, n_items
         write (nout,'(i5)',iostat=ios) kval(i)
      enddo
      do i = 1, n_items
         write (nout,'(i5)',iostat=ios) lval(i)
      enddo
      write (nout,'(a)',iostat=ios) '% End of configuration parameters'
      close (unit = nout) 
      call x_getcfg (n1, nval,
     +               cval)      
c
c message if required
c      
      if (k_input.ne.0 .or. n_input.ne.0) then
         if (suppress) then
            write (line,1300) mode
         else
            write (line,1400) mode
         endif       
         call x_putadv (line)
      endif   
c
c format statements
c      
  100 format ('X_SWITCH Error 1: cannot find w_simfit.cfg')
  200 format ('X_SWITCH Error 2: w_simfit.cfg is read_only')
  300 format ('X_SWITCH Error 3: w_simfit.cfg is connected')
  400 format ('X_SWITCH Error 4: cannot open w_simfit.cfg, IOSTAT =',i6)
  500 format ('X_SWITCH Error 5: cannot read w_simfit.cfg, IOSTAT =',i6)
  600 format ('X_SWITCH Error 6: no % on w_simfit.cfg line 1')
  700 format ('X_SWITCH Error 7: cannot read NVAL(1), IOSTAT =',I6)
  800 format ('X_SWITCH Error 8: IADD1 =', i6) 
  900 format (
     +' Changing the speedup message options'
     +/
     +/'Number active =',i3
     +/'Number suppressed =', i3 
     +/
     +/'Activate all advisory messages'
     +/'Suppress all advisory messages'
     +/'Cutomise'
     +/'Help'
     +/'Quit ... Exit speedup options')
c 1000 format (
c     + 'Configuring the Simfit speedup options'
c     +/
c     +/'When installed for the first time Simfit activates several'
c     +/'advisory messages to help new users.'
c     +/
c     +/'None of these messages are strictly necessary, and they can'
c     +/'be annoying for experienced users. So you can re-configure now'
c     +/'or at any time from the Advanced Configuration options.'
c     +/
c     +/'Some messages are more important than others. For instance,'
c     +/'when graphs have been extensively edited, a message warns'
c     +/'users that the editing will be lost unless a metafile is saved'
c     +/'to resume editing retrospectively, so you may choose to leave'
c     +/'this option switched on.'
c     +/
c     +/'Also, choosing to input a vector or matrix from the terminal in'
c     +/'real time rather than from files can be very useful, e.g., when'
c     +/'typing in 2 by 2 contingency tables for chi-square testing.'
c     +/ 
c     +/'The options are described in configure.pdf and speedup.pdf'
c     +/'distributed with the Simfit and simdem packages, and also'
c     +/'available from the Simfit website (https//simfit.org.uk).')
 1100 format ('Cannot write to w_simfit.cfg')
 1200 format (i5,1x,a) 
 1300 format ('Configuration option',i3,' suppressed ... ',
     +'To restore use [Configure], [Advanced], [Speedup]')   
 1400 format ('Configuration option',i3,' activated ... ',
     +'To suppress use [Configure], [Advanced], [Speedup]')       
      end
c
c
      recursive integer function i_call_x_switch()
      implicit none
      integer mode
      parameter (mode = 0)
      external x_switch
      i_call_x_switch = 1
      call x_switch (mode)
      end      
c
c
