c
c
      subroutine x_table1 (icolor,
     +                     strng)
c
c action: call w_table1
c author: w.g.bardsley, university of manchester, u.k., 15/04/2010
c         24/04/2012 changed .le. to .lt. at check for bogus 'CLOSE' 
c
c This version is protected to prevent bogus calls to w_table1 as follows:
c icount < 0: waiting to be opened
c icount = 0: first genuine call
c icount > 0: subsequent genuine calls 
c
      implicit none
c
c arguments
c
      integer,             intent (in) :: icolor
      character (len = *), intent (in) :: strng
c
c locals
c    
      integer   icount, icolor_sav   
      save      icount, icolor_sav
      data      icount, icolor_sav / -1, 15 /
      external  w_table1
      
      if (strng.eq.'OPEN' .or. strng.eq.'open') then
         if (icount.lt.0) then
c
c a genuine call to open w_table1 so set icount = 0 and save icolor_sav
c           
            icount = 0
            icolor_sav = icolor
         else
c
c a bogus call to open w_table1 which is already open
c           
            return
         endif
      elseif (strng.eq.'CLOSE' .or. strng.eq.'close') then
         if (icount.lt.0) then
c
c a bogus call to close w_table1 which is already closed 
c           
            return
         else
c
c a genuine call to close w_table1 so set icount = -1
c           
            icount = -1
            call w_table1 (icolor, 'CLOSE')
         endif      
      else
         if (icount.lt.0) then
c
c a bogus call to write to an unopened window
c           
            return
         elseif (icount.eq.0) then
c
c called with the first character string for w_table1 so set icount = 1
c         
            icount = 1
            call w_table1 (icolor_sav, 'OPEN')
         endif       
                         
c
c pass subsequent arguments on to w_table1
c           
         call w_table1 (icolor, strng)
      endif
      
      end
c
c                       
      