c
c
      subroutine x_txt2i1 (ival,
     +                     line,
     +                     abort)
c
c action: read an integer off line
c author: w.g.bardsley, university of manchester, u.k., 27/10/2010
c         11/08/2011 added facility to strip out blanks
c     
      implicit none
c
c arguments
c      
      integer,             intent (inout) :: ival
      character (len = *), intent (inout) :: line
      logical,             intent (out)   :: abort
c
c locals
c      
      integer    i, ios, itemp, j, k, l
      character (len = 12) copy_12
      character (len = 1 ) letter
      character (len = 1 ) blank, comma, dot, minus, plus
      parameter (blank = ' ', comma = ',', dot = '.',
     +           minus = '-', plus = '+')      
      intrinsic  adjustl, ichar, index
c
c initialise, check for blank line, then make a left justified copy 
c      
      abort = .true.
      if (line.eq.blank) return
      copy_12 = line
      copy_12 = adjustl(copy_12)
      k = len_trim(copy_12)
c
c check singular case with just one character
c     
      if (k.eq.1) then
         letter = copy_12(1:1)
         l = ichar(letter)
         if (l.lt.48 .or. l.gt.57) return
         read (letter,'(i1)',iostat=ios) itemp
         if (ios.eq.0) then
            abort = .false.
            ival = itemp
            line = copy_12
         endif  
         return    
      endif 
c
c strip out intermediate blanks
c      
      j = index(copy_12(1:k),blank)
      do while (j.gt.1)
         do i = j, k - 1
            copy_12(i:i) = copy_12(i + 1:i + 1)
         enddo
         copy_12(k:k) = blank
         k = len_trim(copy_12)
         j = index(copy_12(1:k),blank)  
      enddo      
c
c test for commas and dots
c 
      j = index(copy_12,comma)
      if (j.gt.0) return
      j = index(copy_12,dot)       
      if (j.gt.0) return
c
c check for invalid characters
c              
      j = 0
      do while (j.lt.k)
         j = j + 1
         letter = copy_12(j:j)
         l = ichar(letter)
         if (j.eq.1) then
            if (letter.eq.plus .or. letter.eq.minus) then
               if (copy_12(j + 1:j + 1).eq.'0') return
            else     
               if (l.lt.49 .or. l.gt.57) return
            endif    
         else
            if (l.lt.48 .or. l.gt.57) return
         endif
      enddo 
c
c read integers
c           
      read (copy_12,*,iostat=ios) itemp
      if (ios.eq.0) then
         abort = .false.
         ival = itemp
         line = copy_12
      endif   
      end 
c
c       